/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.contracts.CloudInstanceService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.CloudInstanceOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@type(value="comvmwarevcimngc:CloudInstance")
public class CloudInstanceDataService
extends VCimDataService
implements CloudInstanceService {
    private final AdapterWrapper adapterWrapper;
    public static final String CLOUD_INSTANCE_DSN = "comvmwarevcimngc:CloudInstance";

    public CloudInstanceDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AdapterWrapper adapterWrapper) {
        super(CLOUD_INSTANCE_DSN, resourceTypeResolverRegistry, userSessionService);
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<VCimVpc> vpcs = null;
        if (CLOUD_INSTANCE_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + CLOUD_INSTANCE_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        vpcs = objects;
                    }
                }
            }
            if (!cacheHit) {
                vpcs = this.getVpcs();
                this.cacheUtil.addEntry(cacheKey, vpcs);
            }
            if (vpcs != null) {
                for (VCimVpc vpc : vpcs) {
                    ResultItem ri = this.getVpcProperties(vpc, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
        }
        return items;
    }

    @Override
    protected Object getObject(Object target) {
        return this.getVpc(target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getVpcProperties((VCimVpc)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private ResultItem getVpcProperties(VCimVpc vpc, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = vpc.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = vpc.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!CLOUD_INSTANCE_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("id")) {
                    propValue = vpc.getId();
                } else if (prop.equals("vpcName")) {
                    propValue = vpc.getName();
                } else if (prop.equals("name")) {
                    propValue = vpc.getName();
                } else if (prop.equals("href")) {
                    propValue = vpc.getHref();
                } else if (prop.equals("cpuAvailable")) {
                    propValue = vpc.getCpuAvailable();
                } else if (prop.equals("storageAvailable")) {
                    propValue = vpc.getStorageAvailable();
                } else if (prop.equals("memoryAvailable")) {
                    propValue = vpc.getMemoryAvailable();
                } else if (prop.equals("publicIpsAvailable")) {
                    propValue = vpc.isShared() ? "-" : Long.valueOf(vpc.getPublicIpsAvailable());
                } else if (prop.equals("cpuAllocated")) {
                    propValue = vpc.getCpuAllocated();
                } else if (prop.equals("storageAllocated")) {
                    propValue = vpc.getStorageAllocated();
                } else if (prop.equals("memoryAllocated")) {
                    propValue = vpc.getMemoryAllocated();
                } else if (prop.equals("publicIpsAllocated")) {
                    propValue = vpc.getPublicIpsAllocated();
                } else if (prop.equals("cpuPurchased")) {
                    propValue = vpc.getCpuPurchased();
                } else if (prop.equals("storagePurchased")) {
                    propValue = vpc.getStoragePurchased();
                } else if (prop.equals("memoryPurchased")) {
                    propValue = vpc.getMemoryPurchased();
                } else if (prop.equals("publicIpsPurchased")) {
                    propValue = vpc.getPublicIpsPurchased();
                } else if (prop.equals("description")) {
                    propValue = vpc.getDescription();
                } else if (prop.equals("regionName")) {
                    propValue = vpc.getRegionName();
                } else if (prop.equals("regionId")) {
                    propValue = vpc.getRegionId();
                } else if (prop.equals("cloudType")) {
                    propValue = vpc.isShared() ? (CloudTypeType.DR_2_C == vpc.getCloudType() ? "Disaster Recovery Cloud" : "Shared Cloud") : "Dedicated Cloud";
                } else if (prop.equals("isDR2C")) {
                    propValue = vpc.isDR2C();
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = vpc.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public VCimVpc getVpcById(Object vpcId) {
        VCimVpc vpc = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VPC_BY_ID#" + vpcId + "#" + sessionId;
        vpc = (VCimVpc)this.queryUtil.getResults(key, vpcId);
        return vpc;
    }

    @Override
    public VCimVpc getVpc(Object vpcUri) {
        VCimVpc vpc = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VPC#" + ((URI)vpcUri).toString() + "#" + sessionId;
        vpc = (VCimVpc)this.queryUtil.getResults(key, vpcUri);
        return vpc;
    }

    @Override
    public List<VCimVpc> getVpcs() {
        List vpcs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VPCS#" + sessionId;
        vpcs = (List)this.queryUtil.getResults(key, new Object[0]);
        return vpcs;
    }

    @Override
    public List<VCimVpc> getPrivateVpcs() {
        List vpcs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_PRIVATE_VPCS#" + sessionId;
        vpcs = (List)this.queryUtil.getResults(key, new Object[0]);
        return vpcs;
    }

    @Override
    public List<VCimVpc> getVpcsForRegion(String regionId) {
        List vpcs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VPCS_FOR_REGION#" + sessionId;
        vpcs = (List)this.queryUtil.getResults(key, regionId);
        return vpcs;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_VPC_BY_ID#")) {
            if (arguments.length > 0) {
                return this.getCloudAdapter().getVpcById(sessionId, (String)arguments[0]);
            }
        } else if (identifier.startsWith("GET_VPC#")) {
            if (arguments.length > 0) {
                return this.getCloudAdapter().getVpc(sessionId, (URI)arguments[0]);
            }
        } else {
            if (identifier.startsWith("GET_VPCS#")) {
                CloudInstanceOperations cIo = this.getCloudAdapter();
                return cIo.getVpcs(sessionId);
            }
            if (identifier.startsWith("GET_VPCS_FOR_REGION#")) {
                if (arguments.length > 0) {
                    return this.getCloudAdapter().getVpcsForRegion(sessionId, (String)arguments[0]);
                }
            } else if (identifier.startsWith("GET_PRIVATE_VPCS#")) {
                return this.getCloudAdapter().getPrivateVpcs(sessionId);
            }
        }
        return null;
    }

    private CloudInstanceOperations getCloudAdapter() {
        return (CloudInstanceOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.CLOUD));
    }
}

