/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.contracts.TemplateService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.Network;
import com.vmware.vcim.ngc.service.model.TemplateContainer;
import com.vmware.vcim.ngc.service.model.VCimTemplate;
import com.vmware.vcim.ngc.service.model.VCimTemplateType;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VMStorage;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.TemplateOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@type(value="comvmwarevcimngc:Template")
public class TemplateDataService
extends VCimDataService
implements TemplateService {
    private AccessController accessController;
    private AdapterWrapper adapterWrapper;
    private static final String TEMPLATE_DSN = "comvmwarevcimngc:Template";
    private static final String DEPLOY_VM = "DEPLOY_VM";

    public TemplateDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AccessController accessController, AdapterWrapper adapterWrapper) {
        super(TEMPLATE_DSN, resourceTypeResolverRegistry, userSessionService);
        this.accessController = accessController;
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<VCimTemplate> templates = null;
        if (TEMPLATE_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + TEMPLATE_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        templates = objects;
                    }
                }
            }
            if (!cacheHit) {
                templates = this.getAllTemplates(sessionId);
                this.cacheUtil.addEntry(cacheKey, templates);
            }
            for (VCimTemplate template : templates) {
                ResultItem ri = this.getTemplateProperties(template, propertySpecs);
                if (null == ri) continue;
                items.add(ri);
            }
        }
        return items;
    }

    private List<VCimTemplate> getAllTemplates(String sessionId) {
        List templates = null;
        String key = "GET_ALL_TEMPLATES#" + sessionId;
        templates = (List)this.queryUtil.getResults(key, new Object[0]);
        return templates;
    }

    @Override
    protected Object getObject(Object target) {
        String sessionId = this.getClientSessionId();
        String key = "GET_TEMPLATE#" + ((URI)target).toString() + "#" + sessionId;
        return (VCimTemplate)this.queryUtil.getResults(key, target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getTemplateProperties((VCimTemplate)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ObjectIdentityConstraint oic = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
        if (rc.relation.equals("vdcToTemplate")) {
            URI vdcUri = (URI)oic.target;
            String vdcId = VCimVirtualDatacenter.getVdcId(vdcUri);
            String key = "GET_TEMPLATE_FOR_VDC#" + vdcId + "#" + this.getClientSessionId();
            List templates = (List)this.queryUtil.getResults(key, vdcId);
            for (VCimTemplate template : templates) {
                ResultItem ri = this.getTemplateProperties(template, propertySpecs);
                if (null == ri) continue;
                items.add(ri);
            }
            return items;
        }
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private ResultItem getTemplateProperties(VCimTemplate template, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = template.getUri();
        VCimTemplateType templateType = template.getTemplate();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = template.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!TEMPLATE_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("templateId")) {
                    propValue = templateType.getTemplateId();
                } else if (prop.equals("memory")) {
                    propValue = templateType.getMemoryMB();
                } else if (prop.equals("storage")) {
                    int storageValue = 0;
                    for (Integer storage : templateType.getStorageMB()) {
                        storageValue += storage.intValue();
                    }
                    propValue = storageValue;
                } else if (prop.equals("vcpu")) {
                    propValue = templateType.getVcpu();
                } else if (prop.equals("operatingSystem")) {
                    propValue = templateType.getOperatingSystemName();
                } else if (prop.equals("instructionSet")) {
                    propValue = templateType.getOsInstructionSet();
                } else if (prop.equals("vdcId")) {
                    propValue = template.getVdcId();
                } else if (prop.equals("name")) {
                    propValue = templateType.getName();
                } else if (prop.equals("description")) {
                    propValue = templateType.getDescription();
                } else if (prop.equals("isChargeable")) {
                    propValue = templateType.isIsChargeable();
                } else if (prop.equals("isDeployAllowed")) {
                    propValue = this.accessController.operationAllowed(DEPLOY_VM);
                } else if (prop.equals("catalogType")) {
                    propValue = template.getCatalogType() == VCimTemplate.CatalogType.GLOBAL ? "Global" : "Local";
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = template.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public void deployTemplate(Object templateUri, String vmName, int vcpu, long memory, List<VMStorage> storage, List<Network> networks) {
        URI uri = null;
        if (templateUri instanceof URI) {
            uri = (URI)templateUri;
        } else {
            try {
                uri = new URI((String)templateUri);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this.getTemplateAdapter().deployTemplate(this.getClientSessionId(), uri, vmName, vcpu, memory, storage, networks);
    }

    @Override
    public VCimTemplateType getTemplate(Object templateUri) {
        VCimTemplate template = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_TEMPLATE#" + ((URI)templateUri).toString() + "#" + sessionId;
        template = (VCimTemplate)this.queryUtil.getResults(key, templateUri);
        return template.getTemplate();
    }

    @Override
    public TemplateContainer getTemplate2(Object templateUri) {
        VCimTemplate template = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_TEMPLATE#" + ((URI)templateUri).toString() + "#" + sessionId;
        template = (VCimTemplate)this.queryUtil.getResults(key, templateUri);
        VCimTemplateType t = template.getTemplate();
        TemplateContainer vcimTemplate = new TemplateContainer(t.getName(), t.getId(), t.getTemplateId(), t.getOperatingSystemName(), t.getOsInstructionSet(), t.getVcpu(), t.getMemoryMB(), t.getStorageMB(), t.getStoragePorts(), t.getHref(), template.getVdcId(), t.isIsChargeable());
        vcimTemplate.setTemplateUri(template.getUri().toString());
        return vcimTemplate;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_TEMPLATES#")) {
            return this.getTemplateReadOnlyAdapter().getTemplates(sessionId);
        }
        if (identifier.startsWith("GET_TEMPLATE#")) {
            if (arguments.length > 0) {
                return this.getTemplateReadOnlyAdapter().getTemplate(sessionId, (URI)arguments[0]);
            }
        } else if (identifier.startsWith("GET_TEMPLATE_FOR_VDC#") && arguments.length > 0) {
            return this.getTemplateReadOnlyAdapter().getTemplatesForVdc(sessionId, (String)arguments[0]);
        }
        return null;
    }

    @Override
    public List<TemplateContainer> getTemplatesForVdc(String vdcId) {
        List templates = null;
        ArrayList<TemplateContainer> vcimTemplates = new ArrayList<TemplateContainer>();
        String sessionId = this.getClientSessionId();
        String key = "GET_TEMPLATE_FOR_VDC#" + vdcId + "#" + sessionId;
        templates = (List)this.queryUtil.getResults(key, vdcId);
        for (VCimTemplate template : templates) {
            VCimTemplateType t = template.getTemplate();
            TemplateContainer vcimTemplate = new TemplateContainer(t.getName(), t.getId(), t.getTemplateId(), t.getOperatingSystemName(), t.getOsInstructionSet(), t.getVcpu(), t.getMemoryMB(), t.getStorageMB(), t.getStoragePorts(), t.getHref(), template.getVdcId(), t.isIsChargeable());
            vcimTemplate.setTemplateUri(template.getUri().toString());
            vcimTemplates.add(vcimTemplate);
        }
        return vcimTemplates;
    }

    private TemplateOperations getTemplateReadOnlyAdapter() {
        return (TemplateOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.TEMPLATE));
    }

    private TemplateOperations getTemplateAdapter() {
        return (TemplateOperations)((Object)this.adapterWrapper.getWritableAdapter(VchsObjectType.TEMPLATE));
    }
}

