/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.ares.auth.v1.SessionType;
import com.vmware.vcim.ngc.service.common.CacheUtilImpl;
import com.vmware.vcim.ngc.service.common.crypt.Cryptor;
import com.vmware.vcim.ngc.service.common.crypt.EncryptionException;
import com.vmware.vcim.ngc.service.contracts.Authenticator;
import com.vmware.vcim.ngc.service.exception.VCimException;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.AuthenticatedUser;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.vpc.notification.impl.VcimNotificationChannelMgr;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class VCimAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(VCimAuthenticator.class);
    private Cryptor cryptor;
    private VcimRestClient vcimRestClient;
    private VcimNotificationChannelMgr notificationChannelMgr;
    private VcimSessionManager vcimSessionMgr;
    public static final int AUTH_FAILED = 401;
    public static final int USER_LOCKED = 412;
    public static final int SERVER_PROBLEM = 500;
    public static final int INVALID_SERVER = 400;
    public static final int TOS_CHANGED = 403;
    public static final int TOS_ACCEPTANCE_SUCCEEDED = 204;
    public static final int TOS_ACCEPTANCE_FAILED = 502;
    public static final int UNREACHABLE_SERVER = 404;
    public static final int SESSION_RENEWED = 204;
    public static final String SERVER_NOT_KNOWN = "UnknownHostException";
    public static final String SSL_CERTI_NOTVALID = "Server Certificate Not Verified";
    private static final String KEY_NOT_FOUND = "KeyStore File Not Found";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_PASS = "proxyPassword";
    private static final String PROXY_PORT = "proxyPort";
    @Autowired
    private final ConfigurationService _confgurationService;

    public VCimAuthenticator(Cryptor cryptor, VcimSessionManager vcimSessionMgr, VcimRestClient vcimRestClient, VcimNotificationChannelMgr notificationChannelMgr, ConfigurationService conf) {
        this.cryptor = cryptor;
        this.vcimSessionMgr = vcimSessionMgr;
        this.vcimRestClient = vcimRestClient;
        this.notificationChannelMgr = notificationChannelMgr;
        this._confgurationService = conf;
    }

    public VcimRestClient getVcimRestClient() {
        return this.vcimRestClient;
    }

    public AuthenticatedUser login(String clientSessionId, String vpcUrl, String username, String password, boolean isCredEncrypted, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        logger.info("Login to vCHS with URL: " + vpcUrl + ", Username: " + username);
        VCimSession vCimSession = this.vcimSessionMgr.getSession(clientSessionId);
        if (null != vCimSession && vCimSession.getVchsSession().getUser().isTosAccepted()) {
            logger.info("vCHS Session already available for user: " + username + ", Client Id: " + clientSessionId);
        } else {
            this.login(clientSessionId, vpcUrl, username, password, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy, true, isCredEncrypted);
        }
        return this.getAuthenticatedUserFromVCimSession(clientSessionId);
    }

    private void login(String clientSessionId, String vpcUrl, String username, String password, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy, boolean createNewSession, boolean isCredEncrypted) {
        String loginURL = vpcUrl + "/api/private/sessions";
        URI loginURI = URI.create(loginURL);
        proxyUrl = this._confgurationService.getProperty(PROXY_HOST);
        proxyPort = this._confgurationService.getProperty(PROXY_PORT);
        proxyUsername = this._confgurationService.getProperty(PROXY_USER);
        proxyPassword = this._confgurationService.getProperty(PROXY_PASS);
        if (proxyUrl == null || proxyUrl.equals("")) {
            useProxy = false;
        } else {
            logger.debug("Proxy server name " + proxyUrl);
            useProxy = true;
        }
        if (useProxy) {
            if (proxyPort == null || proxyPort.equals("")) {
                logger.error("Proxy Port Not Specified " + username);
                throw new VCimException(404, "Proxy Port Not Specified");
            }
            logger.debug("Proxy port number " + proxyPort);
            if (proxyUsername == null) {
                proxyUsername = "";
                logger.debug("Proxy username is null");
            }
            if (proxyPassword == null) {
                proxyPassword = "";
                logger.debug("Proxy password is null");
            }
        }
        if (!loginURI.isOpaque() && loginURI.getScheme() != null) {
            try {
                RestTemplate restTemplate = this.vcimRestClient.createRestTemplate(loginURI, username, password, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
                VCimSession vCimSession = null;
                vCimSession = createNewSession ? this.vcimSessionMgr.createSession(this, clientSessionId) : this.vcimSessionMgr.getSession(clientSessionId);
                vCimSession.setRestTemplate(restTemplate);
                vCimSession.setVpcUrl(vpcUrl);
                vCimSession.setUsername(username);
                password = !isCredEncrypted ? this.cryptor.encrypt(password) : password;
                vCimSession.setPassword(password);
                vCimSession.setProxyUrl(proxyUrl);
                vCimSession.setProxyPort(proxyPort);
                vCimSession.setProxyUsername(proxyUsername);
                vCimSession.setProxyPassword(proxyPassword);
                HashMap<String, String> customHeaders = new HashMap<String, String>();
                customHeaders.put("x-ares-api-client-id", "f3cf7fc0-8189-4be0-9d47-43eee4acc0bcH7MKGbUKo6xLtGWdMMgf0Af*d8rEQWkvPLcLOVd4MA%$P#@hDURUck$9QsaQ$JAL38c4ZIufmpB3oRPndD933r!!i#z*m!4lytaB");
                logger.info("Login to vCHS endpoint - " + vpcUrl);
                ResponseEntity responseEntity = (ResponseEntity)this.vcimRestClient.sendPostRequest("/api/private/sessions", null, SessionType.class, customHeaders, clientSessionId);
                SessionType sessionType = (SessionType)responseEntity.getBody();
                logger.info("vCHS Login successful for user: " + username);
                if (!sessionType.getUser().isTosAccepted()) {
                    logger.error("Terms of Service has changed for user - " + username);
                    throw new VCimException(403, "Terms of Service has Changed");
                }
                vCimSession.setVchsSession(sessionType);
                return;
            }
            catch (VCimException ex) {
                this.cleanup(clientSessionId);
                if (ex.getStatusCode() == 412) {
                    logger.error("vCHS user " + username + " is locked");
                    throw new VCimException(412, "This account is locked for 15-minutes, due to 5 consecutive failed login attempts. Please try again after 15-minutes. If you are still unable to login, contact your Account Administrator.");
                }
                if (ex.getStatusCode() == 401) {
                    throw new VCimException(401, "User is disabled or entered credentials are not proper.");
                }
                if (ex.getStatusCode() == 500 && ex.getMessage().contains(SERVER_NOT_KNOWN)) {
                    throw new VCimException(404, "Unable to reach Server. Please check server URL");
                }
                if (ex.getStatusCode() == 500 && ex.getMessage().contains(SSL_CERTI_NOTVALID)) {
                    throw new VCimException(404, "Server Certificate not Verified");
                }
                if (ex.getStatusCode() == 500 && ex.getMessage().contains(KEY_NOT_FOUND)) {
                    throw new VCimException(404, KEY_NOT_FOUND);
                }
                throw new VCimException(404, ex.getMessage());
            }
            catch (EncryptionException ex) {
                logger.error("Unable to encrypt password", (Throwable)ex);
                this.cleanup(clientSessionId);
                throw new VCimException(500, "Unable to encrypt password");
            }
            catch (Exception ex) {
                logger.error("vCHS login failed.", (Throwable)ex);
                this.cleanup(clientSessionId);
                throw new VCimException(404, "Unable to reach Server. Please check server URL");
            }
        }
        logger.error("Invalid vCHS URL..Can't login");
        throw new VCimException(400, "Invalid Server URL");
    }

    public AuthenticatedUser acceptTos(String clientSessionId) {
        logger.info("Accepting TOS");
        try {
            this.vcimRestClient.sendPutRequest("/api/private/user/accepttermsofservice", null, null, clientSessionId);
        }
        catch (VCimException e) {
            logger.error("TOS acceptance failed", (Throwable)e);
            throw new VCimException(502, "Failed to accept Terms of Service");
        }
        VCimSession vCimSession = this.vcimSessionMgr.getSession(clientSessionId);
        if (null == vCimSession) {
            logger.error("No valid VCIM Session found");
            throw new VCimException(502, "Failed to accept Terms of Service");
        }
        logger.info("Initiating login after successful TOS acceptance.");
        this.login(clientSessionId, vCimSession.getVpcUrl(), vCimSession.getUsername(), vCimSession.getPassword(), vCimSession.getProxyUrl(), vCimSession.getProxyPort(), vCimSession.getProxyUsername(), vCimSession.getProxyPassword(), vCimSession.isUseProxy(), false, true);
        return this.getAuthenticatedUserFromVCimSession(clientSessionId);
    }

    public AuthenticatedUser getAuthenticatedUserFromVCimSession(String clientSessionId) {
        VCimSession vCimSession = this.vcimSessionMgr.getSession(clientSessionId);
        if (vCimSession == null) {
            return null;
        }
        AuthenticatedUser authUser = new AuthenticatedUser(vCimSession);
        return authUser;
    }

    public boolean isRegisteredToVPC(String clientSessionId) {
        VCimSession vCimSession = this.vcimSessionMgr.getSession(clientSessionId);
        return null != vCimSession;
    }

    public void renewSession(String clientSessionId) {
        logger.info("Renewing vCHS session for client - " + clientSessionId);
        VCimSession vcimSession = this.vcimSessionMgr.getSession(clientSessionId);
        Date origLastActivity = vcimSession.getLastActivityTimeStamp();
        boolean sessionRenew = true;
        try {
            this.vcimRestClient.sendGetRequest("/api/private/session", null, null, clientSessionId);
            vcimSession.setLastActivityTimeStamp(origLastActivity);
        }
        catch (VCimException e) {
            logger.info("Session renewal failed for user " + vcimSession.getUsername() + ". About to clean up session.");
            sessionRenew = false;
        }
        if (!sessionRenew) {
            this.cleanup(clientSessionId);
            this.notificationChannelMgr.closeChannel(vcimSession.getVchsSession().getUser().getUserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String clientSessionId) {
        logger.info("Logout vCHS session for client - " + clientSessionId);
        try {
            this.vcimRestClient.sendDeleteRequest("/api/private/session", null, null, null, clientSessionId);
        }
        finally {
            this.cleanup(clientSessionId);
        }
    }

    private void cleanup(String clientSessionId) {
        if (this.vcimSessionMgr.isSessionAvailable(clientSessionId)) {
            this.vcimSessionMgr.getSession(clientSessionId).cleanup();
            this.vcimSessionMgr.removeSession(clientSessionId);
            CacheUtilImpl.getInstance().removeCache(clientSessionId);
        }
    }
}

