/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.ares.common.v1.LinkType;
import com.vmware.ares.vcd.v1.GatewaySnapshotType;
import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.FlexObjectMarker;
import java.net.URI;

public class VCimGateway
extends GatewaySnapshotType
implements FlexObjectMarker {
    private String vpcId;
    private String vdcId;
    private Boolean privateGateway;
    private String gatewayVcdUri;
    private boolean dr2cvm;

    public boolean isDr2cvm() {
        return this.dr2cvm;
    }

    public void setDr2cvm(boolean dr2cvm) {
        this.dr2cvm = dr2cvm;
    }

    public VCimGateway(GatewaySnapshotType gateway) {
        this.id = gateway.getId();
        this.name = gateway.getGatewayName();
        this.description = gateway.getDescription();
        this.type = gateway.getType();
        this.vdcName = gateway.getVDCName();
        this.gatewayIP = gateway.getGatewayIP();
        this.gatewayBackingConfig = gateway.getGatewayBackingConfig();
        this.haEnabled = gateway.isHaEnabled();
        this.numberOfOrgNetworks = gateway.getNumberOfOrgNetworks();
        this.publicIP = gateway.getPublicIP();
        this.gatewayStatus = gateway.getGatewayStatus();
        this.gatewayName = gateway.getGatewayName();
        this.href = gateway.getHref();
        this.link = gateway.getLink();
        this.haEnabled = gateway.isHaEnabled();
        this.state = gateway.getState();
        this.vCloudUILink = gateway.getVCloudUILink();
        for (LinkType link : gateway.getVCloudUILink()) {
            if (!link.getName().equalsIgnoreCase("OrgVdcVGatewayList")) continue;
            this.gatewayVcdUri = link.getHref();
            break;
        }
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVdcId() {
        return this.vdcId;
    }

    public void setVdcId(String vdcId) {
        this.vdcId = vdcId;
    }

    public String getVdcName() {
        return this.vdcName;
    }

    public void setVdcName(String vdcName) {
        this.vdcName = vdcName;
    }

    public Boolean getPrivateGateway() {
        return this.privateGateway;
    }

    public void setPrivateGateway(Boolean privateGateway) {
        this.privateGateway = privateGateway;
    }

    public static String getGatewayName(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String idString = urlParts[urlParts.length - 1];
        String[] nameId = idString.split("\\+");
        return nameId[1];
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[1];
        }
        return null;
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[3];
        }
        return urlParts[1];
    }

    public static String getGatewayId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String idString = urlParts[urlParts.length - 1];
        String[] nameId = idString.split("\\+");
        return nameId[0];
    }

    public static String getProcessedURL(URI uri) {
        String originalUri = UriUtils.getUrlFromUri(uri);
        if (originalUri.contains("+")) {
            String[] urlParts = originalUri.split("\\+");
            return urlParts[0];
        }
        return originalUri;
    }

    public String getGatewayVcdUri() {
        return this.gatewayVcdUri;
    }

    public void setGatewayVcdUri(String gatewayVcdUri) {
    }

    @Override
    public URI getUri() {
        if (this.vpcId != null && !this.vpcId.equals("")) {
            return UriUtils.createURIUsingDefaults("Gateway", CloudType.PRIVATE.url(), this.vpcId, "vdc", this.vdcId, "edgeGateways", this.id);
        }
        if (this.dr2cvm) {
            return UriUtils.createURIUsingDefaults("Gateway", CloudType.DR_2_C.url(), this.vdcId, "edgeGateways", this.id);
        }
        return UriUtils.createURIUsingDefaults("Gateway", CloudType.SHARED.url(), this.vdcId, "edgeGateways", this.id);
    }
}

