/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.ares.vcd.v1.OperatingSystemCatalogRecordType;
import com.vmware.ares.vcd.v2.MyImageRecordType;
import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.FlexObjectMarker;
import com.vmware.vcim.ngc.service.model.VCimTemplateType;
import com.vmware.vcim.ngc.service.model.adapters.ImageRecordAdapter;
import com.vmware.vcim.ngc.service.model.adapters.OsCatalogRecordAdapter;
import java.net.URI;

public class VCimTemplate
implements FlexObjectMarker {
    private VCimTemplateType template;
    private boolean isPrivate;
    private String vpcId;
    private String vdcId;
    private CatalogType catalogType;

    public VCimTemplateType getTemplate() {
        return this.template;
    }

    public VCimTemplate(Object refType, boolean isPrivate, String vdcId) {
        this(refType, isPrivate, null, vdcId);
    }

    public VCimTemplate(Object refType, boolean isPrivate, String vpcId, String vdcId) {
        if (refType instanceof OperatingSystemCatalogRecordType) {
            this.template = new OsCatalogRecordAdapter((OperatingSystemCatalogRecordType)refType);
            this.catalogType = CatalogType.GLOBAL;
        }
        if (refType instanceof MyImageRecordType) {
            this.template = new ImageRecordAdapter((MyImageRecordType)refType);
            this.catalogType = CatalogType.LOCAL;
        }
        this.isPrivate = isPrivate;
        this.vpcId = vpcId;
        this.vdcId = vdcId;
    }

    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public String getVdcId() {
        return this.vdcId;
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[1];
        }
        return null;
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[3];
        }
        return urlParts[1];
    }

    @Override
    public URI getUri() {
        if (this.isPrivate()) {
            return UriUtils.createURIUsingDefaults("Template", CloudType.PRIVATE.url(), this.vpcId, "vdc", this.vdcId, "catalog", this.template.getId());
        }
        return UriUtils.createURIUsingDefaults("Template", CloudType.SHARED.url(), this.vdcId, "catalog", this.template.getId());
    }

    public static enum CatalogType {
        GLOBAL,
        LOCAL;

    }
}

