/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.ares.common.v1.LinkType;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.common.v2.StorageTierType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.FlexObjectMarker;
import com.vmware.vcim.ngc.service.model.StorageProfile;
import flex.messaging.io.BeanProxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class VCimVirtualDatacenter
extends VdcSnapshotType
implements FlexObjectMarker {
    private long vcpuAllocated;
    private long vcpuAvailable;
    private long vcpuConsumed;
    private long memoryAllocated;
    private long memoryAvailable;
    private long memoryConsumed;
    private long storageAllocated;
    private long storageAvailable;
    private long storageConsumed;
    private List<StorageProfile> storageTier;
    private long vpcVcpuAvailable;
    private long vpcMemoryAvailable;
    private long vpcStorageAvailable;
    private List<StorageProfile> vpcStorageTiersAvailable;
    private int vmQuota;
    private String regionId;
    private String regionName;
    private String vcdUrl;
    private boolean sharedVdc;

    public VCimVirtualDatacenter() {
    }

    public VCimVirtualDatacenter(VdcSnapshotType vdc) {
        this.id = vdc.getId();
        this.name = vdc.getName();
        this.regionName = "hello world";
        this.description = vdc.getDescription();
        this.type = vdc.getType();
        this.cloudName = vdc.getCloudName();
        this.containerCloudType = vdc.getContainerCloudType();
        this.cloudId = this.isPrivate() ? vdc.getCloudId() : vdc.getId();
        this.cpuMhz = vdc.getCpuMhz();
        this.memoryMb = vdc.getMemoryMb();
        this.storageMb = vdc.getStorageMb();
        this.href = vdc.getHref();
        this.link = vdc.getLink();
        this.vCloudUILink = vdc.getVCloudUILink();
        if (null != this.vCloudUILink) {
            for (LinkType linkType : this.vCloudUILink) {
                if (!linkType.getName().equalsIgnoreCase("OrgVdcVAppsList")) continue;
                this.vcdUrl = linkType.getHref();
                break;
            }
        }
        this.dpsProvisioned = vdc.isDPSProvisioned();
        this.isEnabled = vdc.isIsEnabled();
        this.state = vdc.getState();
        this.vcpuAllocated = vdc.getCpuMhz().getAllocated();
        this.vcpuAvailable = vdc.getCpuMhz().getAvailable();
        this.vcpuConsumed = vdc.getCpuMhz().getConsumed();
        this.storageAllocated = vdc.getStorageMb().getAllocated();
        this.storageAvailable = vdc.getStorageMb().getAvailable();
        this.storageConsumed = vdc.getStorageMb().getConsumed();
        this.memoryAllocated = vdc.getMemoryMb().getAllocated();
        this.memoryAvailable = vdc.getMemoryMb().getAvailable();
        this.memoryConsumed = vdc.getMemoryMb().getConsumed();
        this.storageTier = new ArrayList<StorageProfile>();
        for (StorageTierType st : vdc.getStorageTiers().getStorageTier()) {
            if (st == null) continue;
            this.storageTier.add(new StorageProfile(st.getName(), st.getCapacity(), st.getUsed() != null ? st.getUsed() : 0, st.getFree() != null ? st.getFree() : 0, st.isDefault()));
        }
    }

    public boolean isPrivate() {
        return this.getContainerCloudType() == CloudTypeType.DC;
    }

    public boolean isNormalVdc() {
        return this.getContainerCloudType() != CloudTypeType.DR_2_C;
    }

    public boolean isDR2CVdc() {
        return this.getContainerCloudType() == CloudTypeType.DR_2_C;
    }

    public long getVcpuAvailable() {
        return this.vcpuAvailable;
    }

    public void setVcpuAvailable(long vcpuAvailable) {
        this.vcpuAvailable = vcpuAvailable;
    }

    public long getMemoryAvailable() {
        return this.memoryAvailable;
    }

    public void setMemoryAvailable(long memoryAvailable) {
        this.memoryAvailable = memoryAvailable;
    }

    public long getStorageAvailable() {
        return this.storageAvailable;
    }

    public void setStorageAvailable(long storageAvailable) {
        this.storageAvailable = storageAvailable;
    }

    public long getVpcVcpuAvailable() {
        return this.vpcVcpuAvailable;
    }

    public void setVpcVcpuAvailable(long vpcVcpuAvailable) {
        this.vpcVcpuAvailable = vpcVcpuAvailable;
    }

    public long getVpcMemoryAvailable() {
        return this.vpcMemoryAvailable;
    }

    public void setVpcMemoryAvailable(long vpcMemoryAvailable) {
        this.vpcMemoryAvailable = vpcMemoryAvailable;
    }

    public long getVpcStorageAvailable() {
        return this.vpcStorageAvailable;
    }

    public void setVpcStorageAvailable(long vpcStorageAvailable) {
        this.vpcStorageAvailable = vpcStorageAvailable;
    }

    public String getVpcName() {
        return this.cloudName;
    }

    public void setVpcName(String vpcName) {
        this.cloudName = vpcName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public int getVmQuota() {
        return this.vmQuota;
    }

    public void setVmQuota(int vmQuota) {
        this.vmQuota = vmQuota;
    }

    public long getVcpuAllocated() {
        return this.vcpuAllocated;
    }

    public void setVcpuAllocated(long vcpuAllocated) {
        this.vcpuAllocated = vcpuAllocated;
    }

    public long getMemoryAllocated() {
        return this.memoryAllocated;
    }

    public void setMemoryAllocated(long memoryAllocated) {
        this.memoryAllocated = memoryAllocated;
    }

    public long getStorageAllocated() {
        return this.storageAllocated;
    }

    public void setStorageAllocated(long storageAllocated) {
        this.storageAllocated = storageAllocated;
    }

    public String getVcdUrl() {
        return this.vcdUrl;
    }

    public void setVcdUrl(String vcdUrl) {
        this.vcdUrl = vcdUrl;
    }

    public long getVcpuConsumed() {
        return this.vcpuConsumed;
    }

    public void setVcpuConsumed(long vcpuConsumed) {
        this.vcpuConsumed = vcpuConsumed;
    }

    public long getMemoryConsumed() {
        return this.memoryConsumed;
    }

    public void setMemoryConsumed(long memoryConsumed) {
        this.memoryConsumed = memoryConsumed;
    }

    public long getStorageConsumed() {
        return this.storageConsumed;
    }

    public void setStorageConsumed(long storageConsumed) {
        this.storageConsumed = storageConsumed;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public boolean isSharedVdc() {
        return !this.isPrivate();
    }

    public void setSharedVdc(boolean sharedVdc) {
        this.sharedVdc = sharedVdc;
    }

    public String getVpcId() {
        return this.cloudId;
    }

    public void setVpcId(String vpcId) {
        this.cloudId = vpcId;
    }

    public String getVcdSsoTokenUrl() {
        for (LinkType link : this.getLink()) {
            if (!link.getName().equalsIgnoreCase("vcdsso")) continue;
            String ssoUri = link.getHref();
            return ssoUri;
        }
        return null;
    }

    public static boolean isPrivate(String href) {
        String[] hrefParts;
        for (String hrefPart : hrefParts = href.split("/")) {
            if (!hrefPart.equalsIgnoreCase("dc")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrivate(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        return urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url());
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[1];
        }
        String[] ids = urlParts[1].split("\\+");
        return ids[1];
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String[] ids = urlParts[urlParts.length - 1].split("\\+");
        return ids[0];
    }

    public static String getRegionId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String[] ids = urlParts[urlParts.length - 1].split("\\+");
        return ids[ids.length - 1];
    }

    public static String getProcessedURL(URI uri) {
        String originalUri = UriUtils.getUrlFromUri(uri);
        if (originalUri.contains("+")) {
            String[] urlParts = originalUri.split("\\+");
            return urlParts[0];
        }
        return originalUri;
    }

    public List<StorageProfile> getStorageTier() {
        return this.storageTier;
    }

    public void setStorageTier(List<StorageProfile> storageTier) {
        this.storageTier = storageTier;
    }

    public List<StorageProfile> getVpcStorageTiersAvailable() {
        return this.vpcStorageTiersAvailable;
    }

    public void setVpcStorageTiersAvailable(List<StorageProfile> storageTier) {
        this.vpcStorageTiersAvailable = storageTier;
    }

    @Override
    public URI getUri() {
        if (this.isPrivate()) {
            return UriUtils.createURIUsingDefaults("Datacenter", CloudType.PRIVATE.url(), this.getCloudId(), "vdc", this.getId() + "+" + this.regionId);
        }
        if (this.isDR2CVdc()) {
            return UriUtils.createURIUsingDefaults("Datacenter", CloudType.DR_2_C.url(), this.getId() + "+" + this.getCloudId() + "+" + this.regionId);
        }
        return UriUtils.createURIUsingDefaults("Datacenter", CloudType.SHARED.url(), this.getId() + "+" + this.getCloudId() + "+" + this.regionId);
    }

    static {
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"storageTiers");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"state");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"type");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"storageMb");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"memoryMb");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"enabled");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"cloudId");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"DPSProvisioned");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"cpuMhz");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"containerCloudType");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"tasks");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"cloudName");
        BeanProxy.addIgnoreProperty(VCimVirtualDatacenter.class, (String)"default");
    }
}

