/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.ares.common.v1.LinkType;
import com.vmware.ares.vcd.v2.VMRecordType;
import com.vmware.ares.vcd.v2.VMStatusInfoType;
import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.FlexObjectMarker;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachineReplicationStatus;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCimVirtualMachine
extends VMRecordType
implements FlexObjectMarker {
    private int allocatedCPU;
    private long allocatedMemory;
    private long allocatedStorage;
    private String vpcId;
    private boolean snapshotStateBoolean;
    private String vAppName;
    private Boolean guestOSCustomization;
    private String guestOSPassword;
    private String vmwareTools;
    private VCimVirtualDatacenter vdc;
    private boolean isDR2cVm = false;
    private String recoveryStatus;
    private String runningTime;
    private VMStatusInfoType status;
    private final int[][] menuState = new int[][]{{0, 0, 0}, {1, 0, 1}, {0, 0, 0}, {0, 1, 0}, {0, 1, 0}, {0, 0, 0}, {0, 1, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 1}, {0, 0, 0}};
    private final int[][] MenuItem = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 0, 1, 0}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0}, {-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final String STANDARD = "Standard";
    public static final String PLACEHOLDER = "Replication in Progress";
    public static final String TEST_IN_PROGRESS = "Test in Progress";
    public static final String TEST = "Test Ready";
    public static final String TEST_ERROR = "Test Error";
    public static final String CLEANUP_IN_PROGRESS = "Cleanup in Progress";
    public static final String CLEANUP_ERROR = "Cleanup Error";
    public static final String RECOVERY_IN_PROGRESS = "Recovery in Progress";
    public static final String RECOVERED = "Recovered";
    public static final String RECOVERY_ERROR = "Recovery Error";
    public static final String UNDEFINED = "--";
    private List<VCimVirtualMachineReplicationStatus> listOfStatuses = null;
    private final Logger logger = LoggerFactory.getLogger(VCimVirtualMachine.class);

    public boolean isDR2cVm() {
        return this.isDR2cVm;
    }

    public void setDR2cVm(boolean isDR2cVm) {
        this.isDR2cVm = isDR2cVm;
    }

    public String getRecoveryStatus() {
        if (!this.isDR2cVm) {
            return UNDEFINED;
        }
        VMSTATE state = this.getRecoveryStatusCode();
        switch (state) {
            case STANDARD: {
                return STANDARD;
            }
            case PLACEHOLDER: {
                return PLACEHOLDER;
            }
            case TEST_IN_PROGRESS: {
                return TEST_IN_PROGRESS;
            }
            case TEST: {
                return TEST;
            }
            case TEST_ERROR: {
                return TEST_ERROR;
            }
            case CLEANUP_IN_PROGRESS: {
                return CLEANUP_IN_PROGRESS;
            }
            case CLEANUP_ERROR: {
                return CLEANUP_ERROR;
            }
            case RECOVERY_IN_PROGRESS: {
                return RECOVERY_IN_PROGRESS;
            }
            case RECOVERED: {
                return RECOVERED;
            }
            case RECOVERY_ERROR: {
                return RECOVERY_ERROR;
            }
            case UNDEFINED: {
                return UNDEFINED;
            }
        }
        return UNDEFINED;
    }

    public VMSTATE getRecoveryStatusCode() {
        this.logger.debug("**** :" + this.status);
        if (this.status != null) {
            String recoveryState = this.status.getRecoveryState();
            String testRecoveryState = this.status.getTestRecoveryState();
            String replicationState = "";
            if (testRecoveryState == null && recoveryState == null && replicationState.intern() == "".intern()) {
                return VMSTATE.STANDARD;
            }
            if (recoveryState != null) {
                if (testRecoveryState.intern() == "none".intern() && recoveryState.intern() == "notStarted".intern()) {
                    return VMSTATE.PLACEHOLDER;
                }
                if (recoveryState.intern() == "ok".intern()) {
                    return VMSTATE.RECOVERED;
                }
                if (testRecoveryState.intern() == "complete".intern()) {
                    return VMSTATE.TEST;
                }
                if (testRecoveryState.intern() == "testError".intern()) {
                    return VMSTATE.TEST_ERROR;
                }
                if (testRecoveryState.intern() == "testInProgress".intern()) {
                    return VMSTATE.TEST_IN_PROGRESS;
                }
                if (testRecoveryState.intern() == "cleanupInProgress".intern()) {
                    return VMSTATE.CLEANUP_IN_PROGRESS;
                }
                if (testRecoveryState.intern() == "cleanupError".intern()) {
                    return VMSTATE.CLEANUP_ERROR;
                }
                if (recoveryState.intern() == "inprogress".intern()) {
                    return VMSTATE.RECOVERY_IN_PROGRESS;
                }
                if (recoveryState.intern() == "error".intern()) {
                    return VMSTATE.RECOVERY_ERROR;
                }
            }
        }
        return VMSTATE.UNDEFINED;
    }

    public void setRecoveryStatus(String recoveryStatus) {
        this.recoveryStatus = recoveryStatus;
    }

    public String getRunningTime() {
        if (this.status == null) {
            this.runningTime = UNDEFINED;
        } else {
            String date = this.status.getRecoveryCompletionTime();
            if (!(date != null && date.intern() != "".intern() || (date = this.status.getTestRecoveryCompletionTime()) != null && date.intern() != "".intern())) {
                return UNDEFINED;
            }
            Calendar calendar = DatatypeConverter.parseDateTime((String)date);
            long duration = System.currentTimeMillis() - calendar.getTime().getTime();
            long days = TimeUnit.MILLISECONDS.toDays(duration);
            if (days == 0L) {
                this.runningTime = "Today";
            } else if (days > 0L) {
                this.runningTime = days + " Days";
            }
        }
        return this.runningTime;
    }

    public void setRunningTime(String runningTime) {
        this.runningTime = runningTime;
    }

    public boolean testdr2cvmBoolean() {
        if (!this.isDR2cVm) {
            return false;
        }
        VMSTATE state = this.getRecoveryStatusCode();
        this.logger.debug("IN TEST FOR STATE:" + state.i + " menuState[state.getVMSTATE()][0]:" + this.menuState[state.getVMSTATE()][0]);
        return this.menuState[state.getVMSTATE()][0] != 0;
    }

    public boolean cleandr2cvmBoolean() {
        if (!this.isDR2cVm) {
            return false;
        }
        VMSTATE state = this.getRecoveryStatusCode();
        this.logger.debug("IN CLEANUP FOR STATE:" + state.i + " menuState[state.getVMSTATE()][1]:" + this.menuState[state.getVMSTATE()][1]);
        return this.menuState[state.getVMSTATE()][1] != 0;
    }

    public boolean recoverdr2vmBoolean() {
        if (!this.isDR2cVm) {
            return false;
        }
        VMSTATE state = this.getRecoveryStatusCode();
        this.logger.debug("IN RECOVER DR2C FOR STATE:" + state.i + " menuState[state.getVMSTATE()][2]:" + this.menuState[state.getVMSTATE()][2]);
        return this.menuState[state.getVMSTATE()][2] != 0;
    }

    public boolean removeRepliationAllowed() {
        if (!this.isDR2cVm) {
            return false;
        }
        if (this.listOfStatuses != null) {
            String myId = null;
            for (LinkType type : this.link) {
                if (!type.getRel().equalsIgnoreCase("delete:placeholder")) continue;
                String[] href = type.getHref().split("/");
                myId = href[href.length - 1];
                break;
            }
            if (myId != null) {
                for (VCimVirtualMachineReplicationStatus s : this.listOfStatuses) {
                    String thatId = s.getId();
                    if (!myId.equalsIgnoreCase(thatId)) continue;
                    this.logger.debug("REMOVE REPLICATION:true");
                    return true;
                }
            }
        }
        this.logger.debug("REMOVE REPLICATION:false");
        return false;
    }

    public boolean dr2cTestDeleteVM() {
        return this.MenuItem[3][8] == 1;
    }

    public void setVDC(VCimVirtualDatacenter vdc) {
        this.vdc = vdc;
    }

    public VCimVirtualDatacenter getVDC() {
        return this.vdc;
    }

    public String getvAppName() {
        return this.vAppName;
    }

    public void setvAppName(String vAppName) {
        this.vAppName = vAppName;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public boolean isVmPoweredOn() {
        return this.vmState.equalsIgnoreCase("POWERED_ON");
    }

    public boolean isVmSuspended() {
        return this.vmState.equalsIgnoreCase("SUSPENDED");
    }

    public boolean isSnapshotStateBoolean() {
        return this.snapshotStateBoolean;
    }

    public void setSnapshotStateBoolean(boolean snapshotStateBoolean) {
        this.snapshotStateBoolean = snapshotStateBoolean;
    }

    public int getAllocatedCPU() {
        return this.allocatedCPU;
    }

    public void setAllocatedCPU(int allocatedCPU) {
        this.allocatedCPU = allocatedCPU;
    }

    public long getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public void setAllocatedMemory(long allocatedMemory) {
        this.allocatedMemory = allocatedMemory;
    }

    public long getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(long allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Boolean getGuestOSCustomization() {
        return this.guestOSCustomization;
    }

    public void setGuestOSCustomization(Boolean guestOSCustomization) {
        this.guestOSCustomization = guestOSCustomization;
    }

    public String getGuestOSPassword() {
        return this.guestOSPassword;
    }

    public void setGuestOSPassword(String guestOSPassword) {
        this.guestOSPassword = guestOSPassword;
    }

    public String getVmwareTools() {
        return this.vmwareTools;
    }

    public void setVmwareTools(String vmwareTools) {
        this.vmwareTools = vmwareTools;
    }

    public VCimVirtualMachine(VMRecordType vmRecord, String vpcId) {
        this.vpcId = null == vpcId ? "" : vpcId;
        this.status = vmRecord.getVMStatusInfo();
        this.id = vmRecord.getId();
        this.name = vmRecord.getName();
        this.description = vmRecord.getDescription();
        this.type = vmRecord.getType();
        this.state = vmRecord.getState();
        this.cloudName = vmRecord.getCloudName();
        this.vdcId = vmRecord.getVDCId();
        this.vdcName = vmRecord.getVDCName();
        this.vmState = vmRecord.getVMState();
        this.vmName = vmRecord.getVMName();
        this.expired = vmRecord.isExpired();
        this.href = vmRecord.getHref();
        this.link = vmRecord.getLink();
        this.liveUsage = vmRecord.getLiveUsage();
        this.operatingSystem = vmRecord.getOperatingSystem();
        this.tasks = vmRecord.getTasks();
        this.vAppDetails = vmRecord.getVAppDetails();
        this.vcpu = vmRecord.getVCPU();
        this.recoveryStatus = this.getRecoveryStatus();
        this.runningTime = this.getRunningTime();
    }

    public VCimVirtualMachine(VMRecordType vmRecord, String vpcId, boolean isDR2cVm, List<VCimVirtualMachineReplicationStatus> listOfStatuses) {
        this(vmRecord, vpcId);
        this.isDR2cVm = isDR2cVm;
        this.listOfStatuses = listOfStatuses;
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[1];
        }
        return null;
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[3];
        }
        return urlParts[1];
    }

    public static String getVappId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[5];
        }
        return urlParts[3];
    }

    public static String getVmId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[7];
        }
        return urlParts[5];
    }

    public static String getVMUrl(URI uri) {
        String originalUri = UriUtils.getUrlFromUri(uri);
        originalUri.replaceAll("vapp/*/", "");
        return originalUri;
    }

    @Override
    public URI getUri() {
        if (this.vpcId != null && !this.vpcId.equals("")) {
            return UriUtils.createURIUsingDefaults("VirtualMachine", CloudType.PRIVATE.url(), this.vpcId, "vdc", this.vdcId, "vapp", this.vAppDetails.getVAPP(), "vm", this.getId());
        }
        return UriUtils.createURIUsingDefaults("VirtualMachine", CloudType.SHARED.url(), this.vdcId, "vapp", this.vAppDetails.getVAPP(), "vm", this.getId());
    }

    @Override
    public VMStatusInfoType getVMStatusInfo() {
        return this.status;
    }

    @Override
    public void setVMStatusInfo(VMStatusInfoType value) {
        this.status = value;
    }

    static enum VMSTATE {
        STANDARD(0),
        PLACEHOLDER(1),
        TEST_IN_PROGRESS(2),
        TEST(3),
        TEST_ERROR(4),
        CLEANUP_IN_PROGRESS(5),
        CLEANUP_ERROR(6),
        RECOVERY_IN_PROGRESS(7),
        RECOVERED(8),
        RECOVERY_ERROR(9),
        UNDEFINED(10);

        private int i;

        private VMSTATE(int i) {
            this.i = i;
        }

        public int getVMSTATE() {
            return this.i;
        }
    }
}

