/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.ares.common.v1.LinkType;
import com.vmware.ares.vcd.v2.DR2CPlaceholderType;
import com.vmware.ares.vcd.v2.DR2CStatisticsType;
import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.FlexObjectMarker;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCimVirtualMachineReplicationStatus
extends DR2CPlaceholderType
implements FlexObjectMarker {
    private final DR2CPlaceholderType placeholder;
    private final DR2CStatisticsType stats;
    private final List<LinkType> links;
    private String vpcId;
    private VCimVirtualDatacenter vdc;
    private final String name;
    private final String replicationState;
    private final String recoveryCompletionTime;
    private final Long duration;
    private String durationMin;
    private final Long bytes;
    private String bytesGB;
    private final Long rpo;
    private String rpohours;
    private static final int HOUR = 60;
    private static final int MIN = 60;
    private static final Logger logger = LoggerFactory.getLogger(VCimVirtualMachineReplicationStatus.class);
    public static final String ERROR = "error".intern();
    public static final String ERROR_RPO = "Error (RPO Violation)".intern();
    public static final String MOVING = "moving".intern();
    public static final String CONFIGURING = "configuring".intern();
    public static final String PAUSED = "paused".intern();
    public static final String INITIAL_FULL_SYNC = "initialFullSync".intern();
    public static final String FULL_SYNC_RPO = "Full Sync (RPO Violation)".intern();
    public static final String FULL_SYNC = "fullSync".intern();
    public static final String SYNC_RPO = "Sync (RPO Violation)".intern();
    public static final String SYNC = "sync".intern();
    public static final String NOT_ACTIVE_RPO = "Not Active (RPO Violation)".intern();
    public static final String NOT_ACTIVE = "notActive".intern();
    public static final String SUCCESS_RPO = "Success (RPO Violation)".intern();
    public static final String SUCCESS = "OK".intern();
    public static final String RECOVERED = "recovered".intern();
    public static final String RECOVERING = "recovering".intern();
    public static final String ERROR_STATUS = "Error";
    public static final String ERROR_RPO_STATUS = "Error (RPO Violation)";
    public static final String MOVING_STATUS = "Moving";
    public static final String CONFIGURING_STATUS = "Configuring";
    public static final String PAUSED_STATUS = "Paused";
    public static final String INITIAL_FULL_SYNC_STATUS = "Initial Full Sync";
    public static final String FULL_SYNC_RPO_STATUS = "Full Sync (RPO Violation)";
    public static final String FULL_SYNC_STATUS = "Full Sync";
    public static final String SYNC_RPO_STATUS = "Sync (RPO Violation)";
    public static final String SYNC_STATUS = "Sync";
    public static final String NOT_ACTIVE_RPO_STATUS = "Not Active (RPO Violation)";
    public static final String NOT_ACTIVE_STATUS = "Not Active";
    public static final String SUCCESS_RPO_STATUS = "Success (RPO Violation)";
    public static final String SUCCESS_STATUS = "Success";
    public static final String RECOVERED_STATUS = "Recovered";
    public static final String RECOVERING_STATUS = "Recovering";

    public void setVDC(VCimVirtualDatacenter vdc) {
        this.vdc = vdc;
    }

    public VCimVirtualDatacenter getVDC() {
        return this.vdc;
    }

    public VCimVirtualMachineReplicationStatus(DR2CPlaceholderType placeholder, String vpcId) {
        this.vpcId = null == vpcId ? "" : vpcId;
        this.placeholder = placeholder;
        this.stats = this.placeholder.getStats();
        this.id = placeholder.getId();
        this.name = placeholder.getName();
        this.description = placeholder.getDescription();
        this.type = placeholder.getType();
        this.state = placeholder.getState();
        this.replicationState = placeholder.getReplicationState();
        this.recoveryCompletionTime = this.getRecoveryCompletionTime();
        this.duration = placeholder.getStats().getTransferSeconds();
        this.bytes = placeholder.getStats().getTransferBytes();
        this.rpo = placeholder.getRpo();
        this.rpohours = this.getRpohours();
        this.durationMin = this.getDurationMin();
        this.bytesGB = this.getBytesGB();
        this.links = this.getLink();
        if (null != this.links) {
            for (LinkType linkType : this.links) {
                logger.debug(linkType.getName());
            }
        }
        logger.debug("id : " + this.id + "\n" + "name :" + this.name + "\n" + "type: " + this.type + "\n" + "state : " + (Object)((Object)this.state) + "\n" + "replicationState: " + this.replicationState + "\n" + "recoveryCompletionTime: " + this.recoveryCompletionTime + "\n" + "durationMin: " + this.durationMin + "\n" + "bytes: " + this.bytes + "\n" + "bytes in gb: " + this.bytesGB + "\n" + "rpo: " + this.rpo + "\n" + "rpohours: " + this.rpohours + "\n");
    }

    public void setDurationMin(String durationMin) {
        this.durationMin = durationMin;
    }

    public void setBytesGB(String bytesGB) {
        this.bytesGB = bytesGB;
    }

    public void setRpohours(String rpohours) {
        this.rpohours = rpohours;
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.DR_2_C.url())) {
            return urlParts[1];
        }
        return null;
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.DR_2_C.url())) {
            return urlParts[3];
        }
        return urlParts[1];
    }

    public static String getVappId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.DR_2_C.url())) {
            return urlParts[5];
        }
        return urlParts[3];
    }

    public static String getVmId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.DR_2_C.url())) {
            return urlParts[7];
        }
        return urlParts[5];
    }

    public static String getVMUrl(URI uri) {
        String originalUri = UriUtils.getUrlFromUri(uri);
        originalUri.replaceAll("vapp/*/", "");
        return originalUri;
    }

    @Override
    public URI getUri() {
        URI uri = UriUtils.createURIUsingDefaults("VirtualMachine", CloudType.DR_2_C.url(), this.getId());
        logger.debug("VCimVirtualMachineReplicationStatus getUri():" + uri.toString());
        return uri;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReplicationState() {
        if (this.placeholder.isPaused()) {
            return PAUSED_STATUS;
        }
        String repState = this.placeholder.getReplicationState();
        long currentRpoCount = 0L;
        if (this.placeholder.getCurrentRpoViolation() != null) {
            currentRpoCount = this.placeholder.getCurrentRpoViolation().longValue();
        }
        if (repState.intern() == ERROR) {
            if (currentRpoCount > 0L) {
                return ERROR_RPO_STATUS;
            }
            return ERROR_STATUS;
        }
        if (repState.intern() == MOVING) {
            return MOVING_STATUS;
        }
        if (repState.intern() == CONFIGURING) {
            return CONFIGURING_STATUS;
        }
        if (repState.intern() == PAUSED) {
            return PAUSED_STATUS;
        }
        if (repState.intern() == INITIAL_FULL_SYNC) {
            return INITIAL_FULL_SYNC_STATUS;
        }
        if (repState.intern() == FULL_SYNC) {
            if (currentRpoCount > 0L) {
                return FULL_SYNC_RPO_STATUS;
            }
            return FULL_SYNC_STATUS;
        }
        if (repState.intern() == SYNC) {
            if (currentRpoCount > 0L) {
                return SYNC_RPO_STATUS;
            }
            return SYNC_STATUS;
        }
        if (repState.intern() == NOT_ACTIVE) {
            if (currentRpoCount > 0L) {
                return NOT_ACTIVE_RPO_STATUS;
            }
            return NOT_ACTIVE_STATUS;
        }
        if (repState.intern() == SUCCESS) {
            if (currentRpoCount > 0L) {
                return SUCCESS_RPO_STATUS;
            }
            return SUCCESS_STATUS;
        }
        if (repState.intern() == RECOVERED) {
            return RECOVERED_STATUS;
        }
        if (repState.intern() == RECOVERING) {
            return RECOVERING_STATUS;
        }
        return this.replicationState.toUpperCase(Locale.US);
    }

    @Override
    public String getRecoveryCompletionTime() {
        if (this.stats != null) {
            String transferTime = this.stats.getTransferStartTime();
            if (transferTime != null) {
                long seconds = this.stats.getTransferSeconds();
                SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                SimpleDateFormat pstFormat = new SimpleDateFormat("MM/dd/YYYY HH:mm a");
                pstFormat.setTimeZone(TimeZone.getDefault());
                String state = this.placeholder.getReplicationState();
                if (state.intern() == RECOVERED) {
                    if (this.placeholder.getStats() != null && this.placeholder.getStats().getRecoveryCompletionTime() != null && !this.placeholder.getStats().getRecoveryCompletionTime().trim().isEmpty()) {
                        Calendar calendar = DatatypeConverter.parseDateTime((String)this.placeholder.getStats().getRecoveryCompletionTime());
                        return pstFormat.format(calendar.getTime());
                    }
                    return "--";
                }
                if (transferTime == null || transferTime.equalsIgnoreCase("")) {
                    return "--";
                }
                Date date = DatatypeConverter.parseDateTime((String)transferTime).getTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(13, (int)seconds);
                return pstFormat.format(calendar.getTime());
            }
            return "--";
        }
        return "--";
    }

    public String getDurationMin() {
        if (this.duration != null) {
            StringBuffer output = new StringBuffer();
            String FORMAT = "%02d";
            if (this.durationMin == null) {
                if (this.duration != null && this.duration > 60L) {
                    long min = this.duration / 60L;
                    long sec = this.duration % 60L;
                    output.append(min).append(":");
                    output.append(String.format(FORMAT, sec)).append(" min");
                    this.durationMin = output.toString();
                } else if (this.duration != null && this.duration < 60L) {
                    long sec = this.duration % 60L;
                    output.append("0").append(":");
                    output.append(String.format(FORMAT, sec)).append(" min");
                    this.durationMin = output.toString();
                }
            }
            return this.durationMin;
        }
        return "--";
    }

    public String getBytesGB() {
        if (this.bytes != null) {
            if (this.bytesGB == null) {
                if (this.bytes == null || this.bytes == 0L) {
                    this.bytesGB = "--";
                } else if (this.bytes != null && this.bytes > 0L) {
                    int unit;
                    boolean si = false;
                    int n = unit = si ? 1000 : 1024;
                    if (this.bytes < (long)unit) {
                        return this.bytes + " B";
                    }
                    int exp = (int)(Math.log(this.bytes.longValue()) / Math.log(unit));
                    String pre = "G";
                    this.bytesGB = String.format("%.1f %sB", (double)this.bytes.longValue() / Math.pow(unit, exp), pre);
                }
            }
            return this.bytesGB;
        }
        return "--";
    }

    public String getRpohours() {
        if (this.rpo != null) {
            StringBuffer output = new StringBuffer();
            String FORMAT = "%02d";
            if (this.rpohours == null) {
                if (this.rpo != null && this.rpo > 60L) {
                    long hours = this.rpo / 60L;
                    long min = this.rpo % 60L;
                    output.append(hours).append(":");
                    output.append(String.format(FORMAT, min)).append(" hr");
                } else {
                    output.append("0:").append(String.format(FORMAT, this.rpo)).append(" hr");
                }
                this.rpohours = output.toString();
            }
            return this.rpohours;
        }
        return "--";
    }
}

