/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.rest;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.util.ClassUtils;

public class CustomJaxbMsgConvertor
extends Jaxb2RootElementHttpMessageConverter {
    private static final Logger logger = LoggerFactory.getLogger(CustomJaxbMsgConvertor.class);

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return clazz.isAnnotationPresent(XmlType.class) && this.canRead(mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return AnnotationUtils.findAnnotation(clazz, XmlType.class) != null && this.canWrite(mediaType);
    }

    protected void writeToResult(Object o, HttpHeaders headers, Result result) throws IOException {
        Class clazz = ClassUtils.getUserClass((Object)o);
        try {
            Marshaller marshaller = this.createMarshaller(clazz);
            this.setCharset(headers.getContentType(), marshaller);
            marshaller.marshal((Object)this.getJAXBElement(headers, clazz, o), result);
            if (logger.isDebugEnabled()) {
                StringWriter xmlWriter = new StringWriter();
                marshaller.marshal((Object)this.getJAXBElement(headers, clazz, o), (Result)new StreamResult(xmlWriter));
                logger.debug(xmlWriter.toString());
            }
        }
        catch (MarshalException ex) {
            logger.error("HttpMessageNotWritableException: Unable to marshall object to " + clazz.getName(), (Throwable)ex);
            throw new HttpMessageNotWritableException("Could not marshal [" + o + "]: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            logger.error("JAXBException: Unable to marshall object to " + clazz.getName(), (Throwable)ex);
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected Object readFromSource(Class<?> clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller(clazz);
            JAXBElement jaxbElement = unmarshaller.unmarshal(source, clazz);
            return jaxbElement.getValue();
        }
        catch (UnmarshalException ex) {
            logger.error("HttpMessageNotReadableException : Unable to unmarshall object to " + clazz.getName(), (Throwable)ex);
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + clazz + "]: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            logger.error("JAXBException : Unable to unmarshall object to " + clazz.getName(), (Throwable)ex);
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void setCharset(MediaType mediaType, Marshaller marshaller) throws PropertyException {
        if (mediaType != null && mediaType.getCharSet() != null) {
            marshaller.setProperty("jaxb.encoding", (Object)mediaType.getCharSet().name());
        }
    }

    private Class<?> getObjectFactoryClass(Class<?> clazz) {
        try {
            String packageName = clazz.getPackage().getName();
            String objectFactoryClassName = packageName + ".ObjectFactory";
            Class<?> objectFactoryClass = clazz.getClassLoader().loadClass(objectFactoryClassName);
            return objectFactoryClass;
        }
        catch (ClassNotFoundException ex) {
            throw new HttpMessageConversionException("Could not find ObjectFactory class", (Throwable)ex);
        }
    }

    private Object getObjectFactory(Class<?> objectFactoryClass) {
        try {
            return objectFactoryClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new HttpMessageConversionException("Could not instantiate ObjectFactory class", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new HttpMessageConversionException("Could not instantiate ObjectFactory class", (Throwable)ex);
        }
    }

    private Method getMethod(String className, Class<?> clazz) {
        if (className != null) {
            String name = "create" + className.substring(className.lastIndexOf(".") + 1);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equalsIgnoreCase(name)) continue;
                return method;
            }
        }
        throw new HttpMessageConversionException("Unable to create JAXBElement for " + className);
    }

    private String getContentType(HttpHeaders headers) {
        String subMediaType = headers.getContentType().getSubtype();
        String className = null;
        int idx = subMediaType.indexOf("+");
        if (idx != -1) {
            className = subMediaType.substring(0, subMediaType.indexOf("+"));
        } else {
            Map params = headers.getContentType().getParameters();
            className = (String)params.get("class");
        }
        return className;
    }

    private JAXBElement getJAXBElement(HttpHeaders headers, Class<?> clazz, Object o) {
        String className = this.getContentType(headers);
        try {
            Class<?> objectFactoryClass = this.getObjectFactoryClass(clazz);
            Object objectFactory = this.getObjectFactory(objectFactoryClass);
            Method method = this.getMethod(className, objectFactoryClass);
            return (JAXBElement)method.invoke(objectFactory, o);
        }
        catch (Exception e) {
            logger.debug("Exception converting to JAXB " + e.getMessage());
            if (className != null) {
                return new JAXBElement(new QName(className), clazz, o);
            }
            logger.debug("className in the contenttype null");
            return new JAXBElement(new QName(clazz.getName()), clazz, o);
        }
    }
}

