/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.rest.vcim;

import com.vmware.vcim.ngc.service.common.CommonUtils;
import com.vmware.vcim.ngc.service.common.crypt.Cryptor;
import com.vmware.vcim.ngc.service.common.crypt.EncryptionException;
import com.vmware.vcim.ngc.service.exception.VCimException;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.rest.CustomJaxbMsgConvertor;
import com.vmware.vcim.ngc.service.rest.RestClient;
import com.vmware.vcim.ngc.service.rest.RestTemplateFactory;
import com.vmware.vcim.ngc.service.rest.VcimResponseErrorHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class VcimRestClient
extends RestClient {
    private final RestTemplateFactory restTemplateFactory;
    private final VcimSessionManager vcimSessionMgr;
    private final Cryptor cryptor;
    private static final Logger logger = LoggerFactory.getLogger(VcimRestClient.class);
    private static final String VERSION_PARAM_VALUE = "2";
    private static final String MEDIA_SUB_TYPE = "xml";
    public static final String ACCEPT_HEADER_VALUE = "application/xml;version=2;charset=utf-8";
    private static final String ARES_AUTHENTICATION_HEADER = "x-ares-authentication";
    private static final int AUTH_FAILED = 401;

    public VcimRestClient(RestTemplateFactory restTemplateFactory, Cryptor cryptor, VcimSessionManager vcimSessionMgr) {
        this.restTemplateFactory = restTemplateFactory;
        this.cryptor = cryptor;
        this.vcimSessionMgr = vcimSessionMgr;
    }

    public <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, String clientSessionId) {
        return super.sendGetRequest(url, responseType, clientSessionId);
    }

    public <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, Map<String, String> customHeaders, String clientSessionId) {
        return super.sendGetRequest(url, responseType, customHeaders, clientSessionId);
    }

    public <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, String clientSessionId) {
        return super.sendPostRequest(url, requestData, responseType, clientSessionId);
    }

    public <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, String clientSessionId) {
        return super.sendPostRequest(url, requestData, responseType, customHeaders, clientSessionId);
    }

    public <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, String clientSessionId) {
        return super.sendPutRequest(url, requestData, responseType, clientSessionId);
    }

    public <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, String clientSessionId) {
        return super.sendPutRequest(url, requestData, responseType, customHeaders, clientSessionId);
    }

    public <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, String clientSessionId) {
        return super.sendDeleteRequest(url, requestData, responseType, clientSessionId);
    }

    public <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, String clientSessionId) {
        return super.sendDeleteRequest(url, requestData, responseType, customHeaders, clientSessionId);
    }

    public RestTemplate createRestTemplate(URI url, String username, String password, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        this.restTemplateFactory.setMessageConverters(this.getMessageConvertors());
        RestTemplate restTemplate = this.restTemplateFactory.createRestTemplate(url, username, password, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
        restTemplate.setErrorHandler((ResponseErrorHandler)new VcimResponseErrorHandler());
        return restTemplate;
    }

    private List<HttpMessageConverter<?>> getMessageConvertors() {
        CustomJaxbMsgConvertor converter = new CustomJaxbMsgConvertor();
        ArrayList<MediaType> supportedTypes = new ArrayList<MediaType>();
        for (String mediaClass : this.getSupportedClassTypes()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("class", mediaClass);
            parameters.put("version", VERSION_PARAM_VALUE);
            MediaType type = new MediaType("application", MEDIA_SUB_TYPE, parameters);
            supportedTypes.add(type);
        }
        converter.setSupportedMediaTypes(supportedTypes);
        ArrayList lst = new ArrayList();
        lst.add((HttpMessageConverter<?>)converter);
        lst.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        return lst;
    }

    private String[] getSupportedClassTypes() {
        String[] classTypes = new String[]{"vnd.vmware.ares.vmscreenticket", "vnd.vmware.ares.adminvmrecordlist", "vnd.vmware.ares.myimageslist", "vnd.vmware.ares.dcsnapshotlist", "vnd.vmware.ares.vdcsnapshotlist", "vnd.vmware.ares.catalogosrecordlist", "vnd.vmware.ares.myimageslist", "vnd.vmware.ares.deployvmfromcatalogparams", "vnd.vmware.ares.vmsettings", "vnd.vmware.ares.networksnapshotlist", "vnd.vmware.ares.vmnetworklist", "vnd.vmware.ares.vdcuseraccesslist", "vnd.vmware.ares.vmowner", "vnd.vmware.ares.gatewaysnapshotlist", "vnd.vmware.ares.vdc", "vnd.vmware.ares.dcvdc", "vnd.vmware.ares.gatewayparams", "vnd.vmware.ares.snapshotparams", "vnd.vmware.ares.snapshot", "vnd.vmware.ares.userlist", "vnd.vmware.ares.rolelist", "vnd.vmware.ares.backupparams", "vnd.vmware.ares.vcdsessiontoken", "vnd.vmware.ares.session", "vnd.vmware.ares.cloudsnapshotlist", "vnd.vmware.ares.sharedcloudvdcput", "vnd.vmware.ares.gatewaynetworks", "vnd.vmware.ares.gateway", "vnd.vmware.ares.dr2ctestfailoverparams", "vnd.vmware.ares.task", "vnd.vmware.ares.error"};
        return classTypes;
    }

    private void injectSecurityHeaders(VCimSession vCimSession, HttpHeaders headers) {
        try {
            String username = vCimSession.getUsername();
            String password = this.cryptor.decrypt(vCimSession.getPassword());
            String credential = "Basic " + CommonUtils.getBase64Encoding(username + ":" + password);
            headers.set("Authorization", credential);
            headers.set(ARES_AUTHENTICATION_HEADER, vCimSession.getAresAuthToken());
        }
        catch (EncryptionException e) {
            logger.error("Unable to decrypt password", (Throwable)e);
            throw new VCimException(500, "Unable to decrypt password");
        }
        catch (Exception e) {
            logger.error("Error injecting security headers", (Throwable)e);
            throw new VCimException(500, e.getMessage());
        }
    }

    @Override
    protected HttpHeaders getHeaders(Map<String, String> customHeaders, Object ... args) {
        VCimSession vCimSession = this.getVcimSession(args);
        HttpHeaders headers = new HttpHeaders();
        this.injectSecurityHeaders(vCimSession, headers);
        headers.set("Accept", ACCEPT_HEADER_VALUE);
        headers.set("User-Agent", "vSphere Web Client vCloud Air Plugin;version=1.5.1");
        if (null != customHeaders) {
            for (String header : customHeaders.keySet()) {
                if (header.equalsIgnoreCase("Content-Type")) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("class", customHeaders.get(header));
                    parameters.put("version", VERSION_PARAM_VALUE);
                    parameters.put("charset", "utf-8");
                    headers.setContentType(new MediaType("application", MEDIA_SUB_TYPE, parameters));
                    continue;
                }
                headers.set(header, customHeaders.get(header));
            }
        }
        return headers;
    }

    private String getClientSessionId(Object ... args) {
        if (args == null || args.length == 0) {
            throw new VCimException(500, "No ClientSessionId found");
        }
        String clientSessionId = (String)args[0];
        return clientSessionId;
    }

    private VCimSession getVcimSession(Object ... args) {
        String clientSessionId = this.getClientSessionId(args);
        VCimSession vCimSession = this.vcimSessionMgr.getSession(clientSessionId);
        if (null == vCimSession) {
            throw new VCimException(401, "No active session");
        }
        return vCimSession;
    }

    @Override
    protected RestTemplate getRestTemplate(Object ... args) {
        VCimSession vCimSession = this.getVcimSession(args);
        return vCimSession.getRestTemplate();
    }

    @Override
    protected String processUrl(String url, Object ... args) {
        VCimSession vCimSession = this.getVcimSession(args);
        if (url.startsWith("http://")) {
            url.replaceFirst("http://", "");
        }
        if (url.startsWith("https://")) {
            url.replaceFirst("https://", "");
        }
        if (url.indexOf("/api") != -1) {
            url = url.substring(url.indexOf("/api"));
        }
        url = vCimSession.getVpcUrl() + url;
        return url;
    }

    @Override
    protected HttpEntity<?> processResponse(HttpEntity<?> responseEntity, Object ... args) {
        VCimSession vCimSession = this.getVcimSession(args);
        HttpHeaders responseHeaders = responseEntity.getHeaders();
        String aresAuthToken = this.getAuthToken(responseHeaders);
        if (!StringUtils.isEmpty((String)aresAuthToken)) {
            vCimSession.setAresAuthToken(aresAuthToken);
            vCimSession.enableSessionRenew();
            return responseEntity;
        }
        vCimSession.setLastActivityTimeStamp(new Date());
        return responseEntity;
    }

    private String getAuthToken(HttpHeaders responseHeaders) {
        String aresAuthToken = "";
        for (String key : responseHeaders.keySet()) {
            List headerValues = responseHeaders.get((Object)key);
            if (!key.equalsIgnoreCase(ARES_AUTHENTICATION_HEADER) || StringUtils.isEmpty((String)(aresAuthToken = (String)headerValues.get(0)))) continue;
            logger.info("x-ares-authentication token found.");
            return aresAuthToken;
        }
        return null;
    }
}

