/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.rest.vcim;

import com.vmware.ares.common.v1.LinkType;
import com.vmware.vcim.ngc.service.exception.VCimException;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.rest.CustomJaxbMsgConvertor;
import com.vmware.vcim.ngc.service.rest.RestClient;
import com.vmware.vcim.ngc.service.rest.RestTemplateFactory;
import com.vmware.vcim.ngc.service.rest.VcimResponseErrorHandler;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordsType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class VcloudRestClient
extends RestClient {
    private RestTemplateFactory restTemplateFactory;
    private VirtualDatacenterOperations vdcAdapter;
    private VcimSessionManager vcimSessionMgr;
    private Map<String, VdcProperties> vdcPropertiesMap = new HashMap<String, VdcProperties>();
    private static final String VERSION_PARAM_VALUE = "5.6";
    private static final String MEDIA_SUB_TYPE = "xml";
    public static final String ACCEPT_HEADER_VALUE = "application/*+xml;version=5.6;charset=utf-8";
    private static final String VCLOUD_AUTHORIZATION_HEADER = "x-vcloud-authorization";
    private static final int AUTH_FAILED = 401;
    private static final Logger logger = LoggerFactory.getLogger(VcloudRestClient.class);

    public VcloudRestClient(RestTemplateFactory restTemplateFactory, VcimSessionManager vcimSessionMgr, VirtualDatacenterOperations vdcAdapter) {
        this.restTemplateFactory = restTemplateFactory;
        this.vdcAdapter = vdcAdapter;
        this.vcimSessionMgr = vcimSessionMgr;
    }

    public <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, String clientSessionId, String vdcId) {
        return super.sendGetRequest(url, responseType, clientSessionId, vdcId);
    }

    public <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, Map<String, String> customHeaders, String clientSessionId, String vdcId) {
        return super.sendGetRequest(url, responseType, customHeaders, clientSessionId, vdcId);
    }

    public HttpEntity<QueryResultRecordsType> sendQueryRequest(String type, String filter, String clientSessionId, String vdcId) {
        String url = "/api/query?type={type}&format={format}&filterEncoded=true";
        if (filter != null && filter != "") {
            url = url + "&filter={filter}";
        }
        try {
            logger.info("GET: " + url);
            HttpHeaders headers = this.getHeaders(null, clientSessionId, vdcId);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            RestTemplate restTemplate = this.getRestTemplate(clientSessionId, vdcId);
            url = this.processUrl(url, clientSessionId, vdcId);
            if (restTemplate == null) {
                throw new VCimException(500, "No RestTemplate Instance available");
            }
            logger.debug("Request Url is {}", (Object)url);
            this.logHttpEntity(requestEntity, false);
            HttpEntity<?> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity, QueryResultRecordsType.class, new Object[]{type, "idrecords", filter});
            this.logHttpEntity(responseEntity, true);
            responseEntity = this.processResponse(responseEntity, clientSessionId, vdcId);
            return responseEntity;
        }
        catch (VcimResponseErrorHandler.VcimResponseException ex) {
            throw new VCimException(ex.getHttpStatusCode().value(), ex.getMessage());
        }
        catch (ResourceAccessException ex) {
            logger.error("Exception in http" + HttpMethod.GET.name() + " for url " + url, (Throwable)ex);
            throw new VCimException(500, "UnknownHostException");
        }
        catch (Exception ex) {
            logger.error("Exception in http" + HttpMethod.GET.name() + " for url " + url, (Throwable)ex);
            throw new VCimException(500, "Could not complete action");
        }
    }

    public <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, String clientSessionId, String vdcId) {
        return super.sendPostRequest(url, requestData, responseType, clientSessionId, vdcId);
    }

    public <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, String clientSessionId, String vdcId) {
        return super.sendPostRequest(url, requestData, responseType, customHeaders, clientSessionId, vdcId);
    }

    public <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, String clientSessionId, String vdcId) {
        return super.sendPutRequest(url, requestData, responseType, clientSessionId, vdcId);
    }

    public <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, String clientSessionId, String vdcId) {
        return super.sendPutRequest(url, requestData, responseType, customHeaders, clientSessionId, vdcId);
    }

    public <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, String clientSessionId, String vdcId) {
        return super.sendDeleteRequest(url, requestData, responseType, clientSessionId, vdcId);
    }

    public <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, String clientSessionId, String vdcId) {
        return super.sendDeleteRequest(url, requestData, responseType, customHeaders, clientSessionId, vdcId);
    }

    private void injectSecurityHeaders(HttpHeaders headers, Object ... args) {
        String clientSessionId = this.getClientSessionId(args);
        String vdcId = this.getVdcId(args);
        VdcProperties vdcProperties = this.getVdcProperties(clientSessionId, vdcId);
        VCimVirtualDatacenter vdc = new VCimVirtualDatacenter();
        vdc.getLink().add(vdcProperties.vcdSsoTokenLink);
        String vdcSsoToken = this.vdcAdapter.getVcdSsoToken(clientSessionId, vdc);
        logger.debug("Retrieved the SSO Token for the VDC");
        headers.set(VCLOUD_AUTHORIZATION_HEADER, vdcSsoToken);
    }

    @Override
    protected HttpHeaders getHeaders(Map<String, String> customHeaders, Object ... args) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", ACCEPT_HEADER_VALUE);
        this.injectSecurityHeaders(headers, args);
        if (null != customHeaders) {
            for (String header : customHeaders.keySet()) {
                if (header.equalsIgnoreCase("Content-Type")) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("version", VERSION_PARAM_VALUE);
                    parameters.put("charset", "utf-8");
                    headers.setContentType(new MediaType("application", customHeaders.get(header) + "+" + MEDIA_SUB_TYPE, parameters));
                    continue;
                }
                headers.set(header, customHeaders.get(header));
            }
        }
        return headers;
    }

    private String getClientSessionId(Object ... args) {
        if (args == null || args.length == 0) {
            throw new VCimException(500, "No ClientSessionId found");
        }
        String clientSessionId = (String)args[0];
        if (clientSessionId == null || clientSessionId.equals("")) {
            throw new VCimException(500, "No ClientSessionId found");
        }
        return clientSessionId;
    }

    private VCimSession getVcimSession(Object ... args) {
        String clientSessionId = this.getClientSessionId(args);
        VCimSession vCimSession = this.vcimSessionMgr.getSession(clientSessionId);
        if (null == vCimSession) {
            throw new VCimException(401, "No active session");
        }
        return vCimSession;
    }

    private String getVdcId(Object ... args) {
        if (args == null || args.length == 0) {
            throw new VCimException(500, "No VDC Id found");
        }
        String vdcId = (String)args[1];
        if (vdcId == null || vdcId.equals("")) {
            throw new VCimException(500, "No VDC Id found");
        }
        return vdcId;
    }

    @Override
    protected RestTemplate getRestTemplate(Object ... args) {
        String clientSessionId = this.getClientSessionId(args);
        String vdcId = this.getVdcId(args);
        return this.getVdcProperties((String)clientSessionId, (String)vdcId).restTemplate;
    }

    @Override
    protected String processUrl(String url, Object ... args) {
        String clientSessionId = this.getClientSessionId(args);
        String vdcId = this.getVdcId(args);
        if (url.startsWith("http://")) {
            url.replaceFirst("http://", "");
        }
        if (url.startsWith("https://")) {
            url.replaceFirst("https://", "");
        }
        if (url.indexOf("/api") != -1) {
            url = url.substring(url.indexOf("/api"));
        }
        url = this.getVdcProperties((String)clientSessionId, (String)vdcId).url + url;
        return url;
    }

    @Override
    protected HttpEntity<?> processResponse(HttpEntity<?> responseEntity, Object ... args) {
        return responseEntity;
    }

    private VdcProperties getVdcProperties(String clientSessionId, String vdcId) {
        if (this.vdcPropertiesMap.containsKey(vdcId)) {
            return this.vdcPropertiesMap.get(vdcId);
        }
        VCimVirtualDatacenter vdc = this.vdcAdapter.getVDCById(clientSessionId, vdcId);
        String url = vdc.getVcdUrl();
        VCimSession vcimSession = this.getVcimSession(clientSessionId);
        VdcProperties vdcProperties = new VdcProperties(vdc);
        vdcProperties.restTemplate = this.createRestTemplate(url, vcimSession.getProxyUrl(), vcimSession.getProxyPort(), vcimSession.getProxyUsername(), vcimSession.getProxyPassword(), vcimSession.isUseProxy());
        this.vdcPropertiesMap.put(vdcId, vdcProperties);
        return vdcProperties;
    }

    private RestTemplate createRestTemplate(String url, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        this.restTemplateFactory.setMessageConverters(this.getMessageConvertors());
        RestTemplate restTemplate = this.restTemplateFactory.createRestTemplate(url, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
        restTemplate.setErrorHandler((ResponseErrorHandler)new VcimResponseErrorHandler());
        return restTemplate;
    }

    private List<HttpMessageConverter<?>> getMessageConvertors() {
        CustomJaxbMsgConvertor converter = new CustomJaxbMsgConvertor();
        ArrayList<MediaType> supportedTypes = new ArrayList<MediaType>();
        for (String mediaClass : this.getSupportedClassTypes()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("version", VERSION_PARAM_VALUE);
            MediaType type = new MediaType("application", mediaClass + "+" + MEDIA_SUB_TYPE, parameters);
            supportedTypes.add(type);
        }
        converter.setSupportedMediaTypes(supportedTypes);
        ArrayList lst = new ArrayList();
        lst.add((HttpMessageConverter<?>)converter);
        lst.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        return lst;
    }

    private String[] getSupportedClassTypes() {
        String[] classTypes = new String[]{"vnd.vmware.vcloud.task", "vnd.vmware.vcloud.error", "vnd.vmware.vcloud.snapshotsection", "vnd.vmware.vcloud.vdc", "vnd.vmware.vcloud.createSnapshotParams", "vnd.vmware.vcloud.query.records", "vnd.vmware.vcloud.query.idrecords", "vnd.vmware.vcloud.undeployVAppParams"};
        return classTypes;
    }

    private class VdcProperties {
        public RestTemplate restTemplate;
        public String url;
        private LinkType vcdSsoTokenLink;

        public VdcProperties(VCimVirtualDatacenter vdc) {
            this.url = vdc.getVcdUrl();
            this.url = this.url.substring(0, this.url.indexOf("/cloud"));
            for (LinkType link : vdc.getLink()) {
                if (!link.getName().equalsIgnoreCase("vcdsso")) continue;
                this.vcdSsoTokenLink = link;
            }
        }
    }
}

