/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.tasks.impl;

import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.tasks.TaskException;
import com.vmware.vcim.ngc.service.tasks.TaskListener;
import com.vmware.vcim.ngc.service.tasks.TaskService;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServiceImpl
implements TaskService {
    private final int MAX_COMPLETED_TASKS = 50;
    private Map<String, Map<String, VCimTask>> userToRunningTasks = new HashMap<String, Map<String, VCimTask>>();
    private Map<String, Map<String, VCimTask>> userToCompletedTasks = new HashMap<String, Map<String, VCimTask>>();
    private Map<String, TaskListener> listeners;
    private VcimSessionManager vcimSessionMgr;
    private static final Logger logger = LoggerFactory.getLogger(TaskServiceImpl.class);

    public TaskServiceImpl(VcimSessionManager vcimSessionMgr) {
        this.vcimSessionMgr = vcimSessionMgr;
    }

    public void setListeners(Map<String, TaskListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void pushTask(VCimTask task) throws TaskException {
        logger.debug("Pushing task " + (StringUtils.isEmpty((String)task.getName()) ? "" : task.getName()) + ", owner - " + task.getOwner());
        if (this.vcimSessionMgr.getSessionForUser(task.getOwner()) == null) {
            logger.warn("Ignoring task as task owner " + task.getOwner() + "is not active");
            return;
        }
        if (VCimTask.TaskState.RUNNING == task.getState()) {
            Map<String, VCimTask> completedTasks = this.getCompletedTasks(task.getOwner());
            if (completedTasks.containsKey(task.getId())) {
                this.updateTask(completedTasks.get(task.getId()), task);
                return;
            }
            this.addRunningTask(task);
        } else {
            Map<String, VCimTask> runningTasks = this.getRunningTasks(task.getOwner());
            if (runningTasks.containsKey(task.getId())) {
                this.updateTask(runningTasks.get(task.getId()), task);
                return;
            }
            this.addCompletedTask(task);
        }
    }

    @Override
    public List<VCimTask> getTasks(VCimTask.TaskState state) {
        LinkedList<VCimTask> result = new LinkedList<VCimTask>();
        if (state == VCimTask.TaskState.RUNNING) {
            for (Map.Entry<String, Map<String, VCimTask>> entry : this.userToRunningTasks.entrySet()) {
                result.addAll(entry.getValue().values());
            }
        }
        if (state == VCimTask.TaskState.ERROR || state == VCimTask.TaskState.SUCCESS) {
            for (Map.Entry<String, Map<String, VCimTask>> entry : this.userToCompletedTasks.entrySet()) {
                result.addAll(entry.getValue().values());
            }
        }
        return result;
    }

    private Map<String, VCimTask> getRunningTasks(String username) {
        if (this.userToRunningTasks.containsKey(username)) {
            return this.userToRunningTasks.get(username);
        }
        LinkedHashMap<String, VCimTask> userTasks = new LinkedHashMap<String, VCimTask>();
        this.userToRunningTasks.put(username, userTasks);
        return userTasks;
    }

    private Map<String, VCimTask> getCompletedTasks(String username) {
        if (this.userToCompletedTasks.containsKey(username)) {
            return this.userToCompletedTasks.get(username);
        }
        LinkedHashMap<String, VCimTask> userTasks = new LinkedHashMap<String, VCimTask>();
        this.userToCompletedTasks.put(username, userTasks);
        return userTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTask(VCimTask existingTask, VCimTask newTask) throws TaskException {
        if (VCimTask.TaskState.RUNNING == newTask.getState() && VCimTask.TaskState.SUCCESS == existingTask.getState() || VCimTask.TaskState.RUNNING == newTask.getState() && VCimTask.TaskState.ERROR == existingTask.getState()) {
            logger.error("Invalid task state - " + newTask.getState().value() + " for task " + existingTask.getName());
            throw new TaskException(TaskException.REASON.INVALID_NEW_STATE);
        }
        VCimTask vCimTask = existingTask;
        synchronized (vCimTask) {
            if (newTask.getNotification() != null) {
                existingTask.setNotification(newTask.getNotification());
            }
            existingTask.setOwner(newTask.getOwner());
            existingTask.setState(newTask.getState());
            existingTask.setEndTime(newTask.getEndTime());
            existingTask.setCompanyId(newTask.getCompanyId());
            if (VCimTask.TaskState.SUCCESS == newTask.getState() || VCimTask.TaskState.ERROR == newTask.getState()) {
                logger.info("Moving task from running to completed task queue: task type - " + existingTask.getOperationType());
                Map<String, VCimTask> runningTasks = this.getRunningTasks(existingTask.getOwner());
                if (runningTasks.containsKey(existingTask.getId())) {
                    Map<String, VCimTask> map = runningTasks;
                    synchronized (map) {
                        runningTasks.remove(existingTask.getId());
                    }
                    this.addCompletedTask(existingTask);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunningTask(VCimTask task) throws TaskException {
        Map<String, VCimTask> runningTasks = this.getRunningTasks(task.getOwner());
        if (runningTasks.containsKey(task.getId())) {
            this.updateTask(runningTasks.get(task.getId()), task);
        }
        logger.warn("Adding new running task: type - " + (StringUtils.isEmpty((String)task.getOperationType()) ? "" : task.getOperationType()) + ", name - " + (StringUtils.isEmpty((String)task.getName()) ? "" : task.getName()) + " to running queue for user - " + task.getOwner());
        Map<String, VCimTask> map = runningTasks;
        synchronized (map) {
            runningTasks.put(task.getId(), task);
        }
        this.publishChange(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompletedTask(VCimTask task) throws TaskException {
        Map<String, VCimTask> completedTasks = this.getCompletedTasks(task.getOwner());
        if (completedTasks.containsKey(task.getId())) {
            this.updateTask(completedTasks.get(task.getId()), task);
        }
        logger.warn("Adding new completed task: type - " + (StringUtils.isEmpty((String)task.getOperationType()) ? "" : task.getOperationType()) + ", name - " + (StringUtils.isEmpty((String)task.getName()) ? "" : task.getName()) + " to running queue for user - " + task.getOwner());
        Map<String, VCimTask> map = completedTasks;
        synchronized (map) {
            if (50 == completedTasks.size()) {
                logger.debug("Removing least recently completed task from queue for user - " + task.getOwner());
                Map.Entry<String, VCimTask> firstCompletedTask = completedTasks.entrySet().iterator().next();
                completedTasks.remove(firstCompletedTask.getKey());
            }
            completedTasks.put(task.getId(), task);
        }
        this.publishChange(task);
    }

    private void publishChange(VCimTask task) {
        for (Map.Entry<String, TaskListener> listener : this.listeners.entrySet()) {
            try {
                listener.getValue().callback(task);
            }
            catch (Exception ex) {
                logger.error("Unable to publish to listener with id {} for task with id {}", (Object)listener.getKey(), (Object)task.getId());
                logger.error("Unable to publish to listener", (Throwable)ex);
            }
        }
    }

    @Override
    public List<VCimTask> getTasks(String username) {
        ArrayList<VCimTask> tasks = new ArrayList<VCimTask>();
        tasks.addAll(this.getRunningTasks(username).values());
        tasks.addAll(this.getCompletedTasks(username).values());
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeTasks(String username) {
        logger.info("Purging all tasks for user - " + username);
        Map<String, Map<String, VCimTask>> map = this.userToRunningTasks;
        synchronized (map) {
            this.userToRunningTasks.remove(username);
        }
        map = this.userToCompletedTasks;
        synchronized (map) {
            this.userToCompletedTasks.remove(username);
        }
    }
}

