/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.product.v2.DcSnapshotListType;
import com.vmware.ares.product.v2.DcSnapshotType;
import com.vmware.ares.vcd.v2.VdcSnapshotListType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.vpc.contracts.CloudInstanceOperations;
import com.vmware.vcim.ngc.service.vpc.impl.RegionVpcAdapter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class CloudInstanceVpcAdapter
implements CloudInstanceOperations,
DataAdapter {
    private final RegionVpcAdapter regionAdapter;
    private final VcimRestClient vcimRestClient;
    private DataAdapterFactory dataAdapterFactory;
    private static final Logger logger = LoggerFactory.getLogger(CloudInstanceVpcAdapter.class);

    public CloudInstanceVpcAdapter(VcimRestClient vcimRestClient, RegionVpcAdapter regionAdapter) {
        this.vcimRestClient = vcimRestClient;
        this.regionAdapter = regionAdapter;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimVpc> getVpcs(String clientSessionId) {
        ArrayList<VCimVpc> vPCs = new ArrayList<VCimVpc>();
        logger.info("Getting cloud instances for client request: " + clientSessionId);
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vPCs.addAll(this.getVpcsForRegion(clientSessionId, region));
        }
        return vPCs;
    }

    @Override
    public VCimVpc getVpcById(String clientSessionId, String vpcId) {
        logger.info("Getting cloud instances for cloud Id: " + vpcId);
        List<VCimVpc> vPCs = this.getVpcs(clientSessionId);
        for (VCimVpc vpc : vPCs) {
            if (!vpc.getId().equals(vpcId)) continue;
            return vpc;
        }
        return null;
    }

    @Override
    public VCimVpc getVpc(String clientSessionId, URI vpcUri) {
        logger.info("Getting cloud instances based on cloud URI: " + vpcUri.toString());
        String regionId = VCimVpc.getRegionId(vpcUri);
        boolean isPrivate = VCimVpc.isPrivate(vpcUri);
        VCimRegion region = this.regionAdapter.getRegion(clientSessionId, regionId);
        List<Object> vPCs = new ArrayList();
        if (isPrivate) {
            logger.info("Requested cloud is private cloud: " + vpcUri.toString());
            vPCs = this.getPrivateVpcsForRegion(clientSessionId, region);
        } else {
            logger.info("Requested cloud is shared cloud: " + vpcUri.toString());
            vPCs = this.getSharedVpcsForRegion(clientSessionId, region);
            vPCs.addAll(this.getDR2CVpcsForRegion(clientSessionId, region));
        }
        for (VCimVpc vCimVpc : vPCs) {
            if (!vCimVpc.getUri().equals(vpcUri)) continue;
            return vCimVpc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VCimVpc> getVpcsForRegion(final String clientSessionId, final VCimRegion region) {
        ArrayList<VCimVpc> vPCs = new ArrayList<VCimVpc>();
        ExecutorService execSrvc = Executors.newFixedThreadPool(3);
        HashSet<Callable<List<VCimVpc>>> callables = new HashSet<Callable<List<VCimVpc>>>(3);
        callables.add(new Callable<List<VCimVpc>>(){

            @Override
            public List<VCimVpc> call() throws Exception {
                return CloudInstanceVpcAdapter.this.getPrivateVpcsForRegion(clientSessionId, region);
            }
        });
        callables.add(new Callable<List<VCimVpc>>(){

            @Override
            public List<VCimVpc> call() throws Exception {
                return CloudInstanceVpcAdapter.this.getSharedVpcsForRegion(clientSessionId, region);
            }
        });
        callables.add(new Callable<List<VCimVpc>>(){

            @Override
            public List<VCimVpc> call() throws Exception {
                return CloudInstanceVpcAdapter.this.getDR2CVpcsForRegion(clientSessionId, region);
            }
        });
        try {
            List futures = execSrvc.invokeAll(callables);
            while (!futures.isEmpty()) {
                Iterator it = futures.iterator();
                while (it.hasNext()) {
                    Future future = it.next();
                    if (!future.isDone()) continue;
                    vPCs.addAll((Collection)future.get());
                    it.remove();
                }
            }
        }
        catch (Exception ex) {
            logger.error("Unable to get Cloud Instances", (Throwable)ex);
        }
        finally {
            execSrvc.shutdown();
        }
        return vPCs;
    }

    @Override
    public List<VCimVpc> getVpcsForRegion(String clientSessionId, String regionId) {
        VCimRegion region = this.regionAdapter.getRegion(clientSessionId, regionId);
        return this.getVpcsForRegion(clientSessionId, region);
    }

    private List<VCimVpc> getPrivateVpcsForRegion(String clientSessionId, VCimRegion region) {
        ArrayList<VCimVpc> privateVpcs = new ArrayList<VCimVpc>();
        String url = "/api/private/region/<REGION_ID>/dcs";
        url = url.replace("<REGION_ID>", region.getId());
        logger.info("Getting dedicated clouds for region " + region.getName() + ": Url - " + url + ", Client Id - " + clientSessionId);
        ResponseEntity vpcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, DcSnapshotListType.class, null, clientSessionId);
        if (null != vpcResponse) {
            DcSnapshotListType vpcs = (DcSnapshotListType)vpcResponse.getBody();
            for (DcSnapshotType dc : vpcs.getDcSnapshot()) {
                VCimVpc vCimVpc = new VCimVpc(dc, region.getId());
                vCimVpc.setRegionName(region.getName());
                logger.info("Got cloud " + vCimVpc.getName() + " for region " + region.getName());
                privateVpcs.add(vCimVpc);
            }
        }
        return privateVpcs;
    }

    private List<VCimVpc> getSharedVpcsForRegion(String clientSessionId, VCimRegion region) {
        ArrayList<VCimVpc> sharedVpcs = new ArrayList<VCimVpc>();
        String url = "/api/private/region/<REGION_ID>/vdcs";
        url = url.replace("<REGION_ID>", region.getId());
        logger.info("Getting shared clouds for region " + region.getName() + ": Url - " + url + ", Client Id - " + clientSessionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcSnapshotListType.class, null, clientSessionId);
        if (null != vdcResponse) {
            VdcSnapshotListType vdcs = (VdcSnapshotListType)vdcResponse.getBody();
            for (VdcSnapshotType vdc : vdcs.getVdcSnapshot()) {
                if (CloudTypeType.VPC != vdc.getContainerCloudType()) continue;
                VCimVpc vCimVpc = new VCimVpc(vdc, region.getId());
                vCimVpc.setRegionName(region.getName());
                logger.info("Got cloud " + vCimVpc.getName() + " for region " + region.getName());
                sharedVpcs.add(vCimVpc);
            }
        }
        return sharedVpcs;
    }

    private List<VCimVpc> getDR2CVpcsForRegion(String clientSessionId, VCimRegion region) {
        ArrayList<VCimVpc> dr2cVpcs = new ArrayList<VCimVpc>();
        String url = "/api/private/region/<REGION_ID>/vdcs";
        url = url.replace("<REGION_ID>", region.getId());
        logger.info("Getting shared clouds for region " + region.getName() + ": Url - " + url + ", Client Id - " + clientSessionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcSnapshotListType.class, null, clientSessionId);
        if (null != vdcResponse) {
            VdcSnapshotListType vdcs = (VdcSnapshotListType)vdcResponse.getBody();
            for (VdcSnapshotType vdc : vdcs.getVdcSnapshot()) {
                if (CloudTypeType.DR_2_C != vdc.getContainerCloudType()) continue;
                VCimVpc vCimVpc = new VCimVpc(vdc, region.getId());
                vCimVpc.setRegionName(region.getName());
                vCimVpc.setCloudType(vdc.getContainerCloudType());
                vCimVpc.setDR2C(true);
                logger.info("Got cloud " + vCimVpc.getName() + " for region " + region.getName());
                dr2cVpcs.add(vCimVpc);
            }
        }
        return dr2cVpcs;
    }

    @Override
    public List<VCimVpc> getPrivateVpcs(String clientSessionId) {
        ArrayList<VCimVpc> vPCs = new ArrayList<VCimVpc>();
        logger.info("Private clouds requested for client Id - " + clientSessionId);
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vPCs.addAll(this.getPrivateVpcsForRegion(clientSessionId, region));
        }
        return vPCs;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.CLOUD;
    }
}

