/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.common.v1.TaskType;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.vcd.v1.GatewayConfigType;
import com.vmware.ares.vcd.v1.GatewayParamsType;
import com.vmware.ares.vcd.v1.GatewaySnapshotListType;
import com.vmware.ares.vcd.v1.GatewaySnapshotType;
import com.vmware.ares.vcd.v1.GatewayType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.model.VCimGateway;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.vpc.contracts.GatewayOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.impl.VpcAdapter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class GatewayVpcAdapter
extends VpcAdapter
implements GatewayOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private final AdapterWrapper adapterWrapper;
    private static final Logger logger = LoggerFactory.getLogger(GatewayVpcAdapter.class);
    public static final String ADD_GATEWAY_DESCRIPTION = "Creating Gateway";
    public static final String UPDATE_GATEWAY_DESCRIPTION = "Updating Gateway";
    public static final String DELETE_GATEWAY_DESCRIPTION = "Deleting Gateway";

    public GatewayVpcAdapter(VcimRestClient vcimRestClient, AdapterWrapper adapterWrapper) {
        super(vcimRestClient);
        this.adapterWrapper = adapterWrapper;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimGateway> getGateways(String clientSessionId) {
        ArrayList<VCimGateway> gateways = new ArrayList<VCimGateway>();
        logger.info("Gateways requested for client request: " + clientSessionId);
        List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDC.isPrivate()) {
                    if (CloudTypeType.DR_2_C == vDC.getContainerCloudType()) {
                        gateways.addAll(this.getSharedDR2CGateways(clientSessionId, vDC));
                        continue;
                    }
                    gateways.addAll(this.getSharedGateways(clientSessionId, vDC));
                    continue;
                }
                gateways.addAll(this.getPrivateGateways(clientSessionId, vDC));
            }
        }
        return gateways;
    }

    private List<VCimGateway> getSharedGateways(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching gateways for shared VDC: " + vDC.getName());
        List<VCimGateway> gateways = null;
        String url = "/api/private/vpc/<VDC_ID>/edgeGateways";
        url = url.replace("<VDC_ID>", vDC.getId());
        gateways = this.getGateways(clientSessionId, url, "", vDC.getId());
        for (VCimGateway gateway : gateways) {
            gateway.setVDCName(vDC.getName());
            gateway.setPrivateGateway(!vDC.isSharedVdc());
        }
        return gateways;
    }

    private List<VCimGateway> getSharedDR2CGateways(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching gateways for shared VDC: " + vDC.getName());
        List<VCimGateway> gateways = null;
        String url = "/api/private/dr2c/<VDC_ID>/edgeGateways";
        url = url.replace("<VDC_ID>", vDC.getId());
        gateways = this.getGateways(clientSessionId, url, "", vDC.getId());
        for (VCimGateway gateway : gateways) {
            gateway.setVDCName(vDC.getName());
            gateway.setPrivateGateway(!vDC.isSharedVdc());
            gateway.setDr2cvm(true);
        }
        return gateways;
    }

    private List<VCimGateway> getPrivateGateways(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching gateways for dedicated VDC: " + vDC.getName());
        List<VCimGateway> gateways = null;
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/edgeGateways";
        url = url.replace("<VPC_ID>", vDC.getCloudId());
        url = url.replace("<VDC_ID>", vDC.getId());
        gateways = this.getGateways(clientSessionId, url, vDC.getCloudId(), vDC.getId());
        for (VCimGateway gateway : gateways) {
            gateway.setVDCName(vDC.getName());
            gateway.setPrivateGateway(vDC.isSharedVdc());
        }
        return gateways;
    }

    private List<VCimGateway> getGateways(String clientSessionId, String url, String vpcId, String vdcId) {
        logger.info("Fetching gateways for cloud Id - " + vpcId + ", vdc Id - " + vdcId);
        ArrayList<VCimGateway> gateways = new ArrayList<VCimGateway>();
        ResponseEntity gatewayResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, GatewaySnapshotListType.class, null, clientSessionId);
        if (null != gatewayResponse) {
            GatewaySnapshotListType gateWays = (GatewaySnapshotListType)gatewayResponse.getBody();
            for (GatewaySnapshotType gatewaySnapshot : gateWays.getGatewaySnapshot()) {
                VCimGateway gateway = new VCimGateway(gatewaySnapshot);
                gateway.setVpcId(vpcId);
                gateway.setVdcId(vdcId);
                gateways.add(gateway);
            }
        }
        return gateways;
    }

    @Override
    public VCimGateway getGateway(String clientSessionId, URI gatewayUri) {
        logger.info("Fetching gateway with URI: " + gatewayUri.toString());
        List<Object> gateways = new ArrayList();
        String vdcId = VCimGateway.getVdcId(gatewayUri);
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (vDC != null) {
            gateways = !vDC.isPrivate() ? (CloudTypeType.DR_2_C == vDC.getContainerCloudType() ? this.getSharedDR2CGateways(clientSessionId, vDC) : this.getSharedGateways(clientSessionId, vDC)) : this.getPrivateGateways(clientSessionId, vDC);
        }
        for (VCimGateway gateway : gateways) {
            if (!gateway.getUri().equals(gatewayUri)) continue;
            logger.info("Gateway found for URI: " + gatewayUri.toString());
            return gateway;
        }
        return null;
    }

    @Override
    public void addGateway(String clientSessionId, String vpcId, String vdcId, String gatewayName, String gatewayDesc, int gatewayIpCount) {
        logger.info("Adding gateway for cloud Id - " + vpcId + ", vdc Id - " + vdcId + ". Gateway name - " + gatewayName + ", description - " + gatewayDesc + ", IP count - " + gatewayIpCount);
        GatewayParamsType gatewayParams = new GatewayParamsType();
        GatewayConfigType gatewayConfigType = new GatewayConfigType();
        gatewayConfigType.setName(gatewayName);
        gatewayConfigType.setIpQuantity(gatewayIpCount);
        gatewayConfigType.setDescription(gatewayDesc);
        gatewayParams.setConfig(gatewayConfigType);
        StringBuilder templateConfig = new StringBuilder();
        templateConfig.append("<GatewayBackingConfig>compact</GatewayBackingConfig>").append("<ApplyRateLimit>true</ApplyRateLimit><InRateLimit>1024</InRateLimit>").append("<OutRateLimit>1024</OutRateLimit><HaEnabled>true</HaEnabled>").append("<UseDefaultRouteForDnsRelay>true</UseDefaultRouteForDnsRelay>");
        gatewayParams.setTemplateConfig(templateConfig.toString());
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/edgeGateways";
        url = url.replace("<VPC_ID>", vpcId);
        url = url.replace("<VDC_ID>", vdcId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.gatewayparams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, gatewayParams, String.class, headers, clientSessionId);
        int responseStatusCode = taskTypeResponse.getStatusCode().value();
        TaskType task = this.unMarshallTask(responseStatusCode, (String)taskTypeResponse.getBody());
        this.startTask(task, clientSessionId, gatewayName, ADD_GATEWAY_DESCRIPTION);
    }

    @Override
    public List<VCimGateway> getGatewaysForVDC(String clientSessionId, String vpcId, String vdcId) {
        List<VCimGateway> gateways = null;
        logger.info("Fetching gateways for cloud Id - " + vpcId + ", vdc Id - " + vdcId);
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (vDC != null) {
            gateways = !vDC.isPrivate() ? (CloudTypeType.DR_2_C == vDC.getContainerCloudType() ? this.getSharedDR2CGateways(clientSessionId, vDC) : this.getSharedGateways(clientSessionId, vDC)) : this.getPrivateGateways(clientSessionId, vDC);
        }
        return gateways;
    }

    @Override
    public void updateGateway(String clientSessionId, String href, String gatewayName, String gatewayDesc) {
        logger.info("Update requested for gateway with href - " + href + ", gateway name - " + gatewayName + ", description - " + gatewayDesc);
        GatewayType gateway = new GatewayType();
        gateway.setName(gatewayName);
        gateway.setDescription(gatewayDesc);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.gateway");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPutRequest(href, gateway, TaskType.class, headers, clientSessionId);
        this.startTask((TaskType)taskTypeResponse.getBody(), clientSessionId, null, UPDATE_GATEWAY_DESCRIPTION);
    }

    @Override
    public void deleteGateway(String clientSessionId, String href) {
        logger.info("Gateway deletion requested for gateway with href - " + href);
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendDeleteRequest(href, null, TaskType.class, null, clientSessionId);
        this.startTask((TaskType)taskTypeResponse.getBody(), clientSessionId, null, DELETE_GATEWAY_DESCRIPTION);
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.GATEWAY;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }
}

