/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.vcd.v1.DirectLinkDetailsType;
import com.vmware.ares.vcd.v1.FenceModeType;
import com.vmware.ares.vcd.v1.GatewayNetworkType;
import com.vmware.ares.vcd.v1.IpRangeType;
import com.vmware.ares.vcd.v1.NetworkSnapshotListType;
import com.vmware.ares.vcd.v1.NetworkSnapshotType;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.model.IpRange;
import com.vmware.vcim.ngc.service.model.Network;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.vpc.contracts.NetworkOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class NetworkVpcAdapter
implements NetworkOperations,
DataAdapter {
    private VcimRestClient vcimRestClient;
    private DataAdapterFactory dataAdapterFactory;
    private static final Logger logger = LoggerFactory.getLogger(NetworkVpcAdapter.class);
    private final String PLC_NETWORK_NAME = "PRIVATE LINK CONNECT";

    public NetworkVpcAdapter(VcimRestClient vcimRestClient) {
        this.vcimRestClient = vcimRestClient;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<Network> getNetworks(String clientSessionId, String vpcId, String vdcId) {
        ArrayList<Network> networks = new ArrayList<Network>();
        NetworkSnapshotListType networkSnapshotListType = null;
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/networks";
        if (!StringUtils.isEmpty((String)vpcId) && !StringUtils.isEmpty((String)vdcId)) {
            logger.info("Getting networks for cloud id - " + vpcId + ", vdc Id - " + vdcId);
            url = url.replace("<VPC_ID>", vpcId);
        } else {
            logger.info("Getting networks for shared vdc id - " + vdcId);
            url = "/api/private/vpc/<VDC_ID>/networks";
        }
        url = url.replace("<VDC_ID>", vdcId);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, NetworkSnapshotListType.class, null, clientSessionId);
        networkSnapshotListType = (NetworkSnapshotListType)response.getBody();
        logger.info("Got networks for cloud id - " + vpcId + ", vdc Id - " + vdcId);
        for (NetworkSnapshotType networkSnapshot : networkSnapshotListType.getNetworkSnapshot()) {
            Network network = new Network(networkSnapshot.getId(), networkSnapshot.getName(), networkSnapshot.getHref());
            network.setType("NonPlc");
            network.setDefault(networkSnapshot.isDefaultNetwork());
            network.setEdgeGatewayName("");
            Network.FenceMode fenceMode = Network.FenceMode.ISOLATED;
            if (FenceModeType.NAT_ROUTED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.NAT_ROUTED;
                network.setEdgeGatewayName(networkSnapshot.getRoutedNetwork().getEdgeGatewayName());
                network.setEdgeGatewayAddress(networkSnapshot.getRoutedNetwork().getEdgeGatewayAddress());
                network.setAllocatedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getAllocated());
                network.setUsedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getUsed());
            } else if (FenceModeType.BRIDGED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.BRIDGED;
            }
            network.setFenceMode(fenceMode);
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId("");
            networks.add(network);
        }
        return networks;
    }

    @Override
    public List<Network> getNetworksForGateway(String clientSessionId, String vpcId, String vdcId, String gatewayId) {
        Network network;
        ArrayList<Network> networksForGateway = new ArrayList<Network>();
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/edgeGateway/<GATEWAY_ID>/networks";
        if (!StringUtils.isEmpty((String)vpcId) && !StringUtils.isEmpty((String)vdcId)) {
            logger.info("Getting networks for cloud id - " + vpcId + ", vdc Id - " + vdcId + ", gateway id - " + gatewayId);
            url = url.replace("<VPC_ID>", vpcId);
        } else {
            logger.info("Getting networks for vdc Id - " + vdcId + ", gateway id - " + gatewayId);
            url = "/api/private/vpc/<VDC_ID>/edgeGateway/<GATEWAY_ID>/networks";
        }
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<GATEWAY_ID>", gatewayId);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, GatewayNetworkType.class, null, clientSessionId);
        GatewayNetworkType gatewayNetworkType = (GatewayNetworkType)response.getBody();
        logger.info("Got networks for gateway id - " + gatewayId);
        for (NetworkSnapshotType networkSnapshot : gatewayNetworkType.getNetworkList().getNetworkSnapshot()) {
            network = new Network(networkSnapshot.getId(), networkSnapshot.getName(), networkSnapshot.getHref());
            network.setDefault(networkSnapshot.isDefaultNetwork());
            network.setEdgeGatewayName("");
            Network.FenceMode fenceMode = Network.FenceMode.ISOLATED;
            if (FenceModeType.NAT_ROUTED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.NAT_ROUTED;
                network.setEdgeGatewayName(networkSnapshot.getRoutedNetwork().getEdgeGatewayName());
                network.setEdgeGatewayAddress(networkSnapshot.getRoutedNetwork().getEdgeGatewayAddress());
                network.setAllocatedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getAllocated());
                network.setUsedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getUsed());
            } else if (FenceModeType.BRIDGED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.BRIDGED;
            }
            network.setAllocatedVMs(networkSnapshot.getVmsAllocated());
            network.setPoweredOnVMs(networkSnapshot.getVmsPoweredOn());
            if (networkSnapshot.getIpRanges() != null) {
                for (IpRangeType ipRange : networkSnapshot.getIpRanges().getIpRange()) {
                    IpRange range = new IpRange(ipRange.getStartAddress(), ipRange.getEndAddress());
                    network.getIpRange().add(range);
                }
            }
            network.setDefaultGatewayIp(networkSnapshot.getDefaultGateway());
            network.setFenceMode(fenceMode);
            network.setType("NonPlc");
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId(gatewayId);
            networksForGateway.add(network);
        }
        for (DirectLinkDetailsType directLink : gatewayNetworkType.getDirectLinksList().getDirectLinkDetails()) {
            network = new Network(directLink.getGatewayAddress(), "PRIVATE LINK CONNECT", "");
            network.setType("Plc");
            network.setIpPool(directLink.getIpPool());
            network.setEdgeGatewayName(directLink.getGatewayName());
            network.setEdgeGatewayAddress(directLink.getGatewayAddress());
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId(gatewayId);
            networksForGateway.add(network);
            logger.info("Got PLC network " + directLink.getGatewayName() + " for gateway - " + gatewayId);
        }
        return networksForGateway;
    }

    @Override
    public Network getNetwork(String clientSessionId, String vpcId, String vdcId, URI networkUri) {
        String gatewayId = Network.getGatewayId(networkUri);
        logger.info("Getting network for cloud id - " + vpcId + ", vdc id - " + vdcId + " and having URI - " + networkUri.toString());
        List<Network> networks = this.getNetworksForGateway(clientSessionId, vpcId, vdcId, gatewayId);
        for (Network network : networks) {
            if (!network.getUri().equals(networkUri)) continue;
            logger.info("Found network having URI - " + networkUri.toString());
            return network;
        }
        return null;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.NETWORK;
    }

    @Override
    public Object getDR2CNetworks(String clientSessionId, String vpcId, String vdcId) {
        ArrayList<Network> networks = new ArrayList<Network>();
        NetworkSnapshotListType networkSnapshotListType = null;
        String url = "/api/private/dr2c/<VDC_ID>/networks";
        if (!StringUtils.isEmpty((String)vpcId) && !StringUtils.isEmpty((String)vdcId)) {
            logger.info("Getting networks for cloud id - " + vpcId + ", vdc Id - " + vdcId);
            url = url.replace("<VPC_ID>", vpcId);
        }
        url = url.replace("<VDC_ID>", vdcId);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, NetworkSnapshotListType.class, null, clientSessionId);
        networkSnapshotListType = (NetworkSnapshotListType)response.getBody();
        logger.info("Got networks for cloud id - " + vpcId + ", vdc Id - " + vdcId);
        for (NetworkSnapshotType networkSnapshot : networkSnapshotListType.getNetworkSnapshot()) {
            Network network = new Network(networkSnapshot.getId(), networkSnapshot.getName(), networkSnapshot.getHref());
            network.setType("NonPlc");
            network.setDefault(networkSnapshot.isDefaultNetwork());
            network.setEdgeGatewayName("");
            Network.FenceMode fenceMode = Network.FenceMode.ISOLATED;
            if (FenceModeType.NAT_ROUTED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.NAT_ROUTED;
                network.setEdgeGatewayName(networkSnapshot.getRoutedNetwork().getEdgeGatewayName());
                network.setEdgeGatewayAddress(networkSnapshot.getRoutedNetwork().getEdgeGatewayAddress());
                network.setAllocatedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getAllocated());
                network.setUsedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getUsed());
            } else if (FenceModeType.BRIDGED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.BRIDGED;
            }
            network.setFenceMode(fenceMode);
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId("");
            network.setDr2cvm(true);
            networks.add(network);
        }
        return networks;
    }

    @Override
    public Network getDR2CNetwork(String clientSessionId, String vpcId, String vdcId, URI networkUri) {
        String gatewayId = Network.getGatewayId(networkUri);
        logger.info("Getting network for cloud id - " + vpcId + ", vdc id - " + vdcId + " and having URI - " + networkUri.toString());
        List<Network> networks = this.getDR2CNetworksForGateway(clientSessionId, vpcId, vdcId, gatewayId);
        for (Network network : networks) {
            if (!network.getUri().equals(networkUri)) continue;
            logger.info("Found network having URI - " + networkUri.toString());
            return network;
        }
        return null;
    }

    @Override
    public List<Network> getDR2CNetworksForGateway(String clientSessionId, String vpcId, String vdcId, String gatewayId) {
        Network network;
        ArrayList<Network> networksForGateway = new ArrayList<Network>();
        String url = "/api/private/dr2c/<VDC_ID>/edgeGateway/<GATEWAY_ID>/networks";
        if (!StringUtils.isEmpty((String)vpcId) && !StringUtils.isEmpty((String)vdcId)) {
            logger.info("Getting networks for cloud id - " + vpcId + ", vdc Id - " + vdcId + ", gateway id - " + gatewayId);
            url = url.replace("<VPC_ID>", vpcId);
        }
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<GATEWAY_ID>", gatewayId);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, GatewayNetworkType.class, null, clientSessionId);
        GatewayNetworkType gatewayNetworkType = (GatewayNetworkType)response.getBody();
        logger.info("Got networks for gateway id - " + gatewayId);
        for (NetworkSnapshotType networkSnapshot : gatewayNetworkType.getNetworkList().getNetworkSnapshot()) {
            network = new Network(networkSnapshot.getId(), networkSnapshot.getName(), networkSnapshot.getHref());
            network.setDefault(networkSnapshot.isDefaultNetwork());
            network.setEdgeGatewayName("");
            Network.FenceMode fenceMode = Network.FenceMode.ISOLATED;
            if (FenceModeType.NAT_ROUTED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.NAT_ROUTED;
                network.setEdgeGatewayName(networkSnapshot.getRoutedNetwork().getEdgeGatewayName());
                network.setEdgeGatewayAddress(networkSnapshot.getRoutedNetwork().getEdgeGatewayAddress());
                network.setAllocatedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getAllocated());
                network.setUsedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getUsed());
            } else if (FenceModeType.BRIDGED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.BRIDGED;
            }
            network.setAllocatedVMs(networkSnapshot.getVmsAllocated());
            network.setPoweredOnVMs(networkSnapshot.getVmsPoweredOn());
            if (networkSnapshot.getIpRanges() != null) {
                for (IpRangeType ipRange : networkSnapshot.getIpRanges().getIpRange()) {
                    IpRange range = new IpRange(ipRange.getStartAddress(), ipRange.getEndAddress());
                    network.getIpRange().add(range);
                }
            }
            network.setDefaultGatewayIp(networkSnapshot.getDefaultGateway());
            network.setFenceMode(fenceMode);
            network.setType("NonPlc");
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId(gatewayId);
            network.setDr2cvm(true);
            networksForGateway.add(network);
        }
        for (DirectLinkDetailsType directLink : gatewayNetworkType.getDirectLinksList().getDirectLinkDetails()) {
            network = new Network(directLink.getGatewayAddress(), "PRIVATE LINK CONNECT", "");
            network.setType("Plc");
            network.setIpPool(directLink.getIpPool());
            network.setEdgeGatewayName(directLink.getGatewayName());
            network.setEdgeGatewayAddress(directLink.getGatewayAddress());
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId(gatewayId);
            networksForGateway.add(network);
            logger.info("Got PLC network " + directLink.getGatewayName() + " for gateway - " + gatewayId);
        }
        return networksForGateway;
    }
}

