/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class TaskManager {
    private List<TaskDetail> tasks = new ArrayList<TaskDetail>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushTask(String entityName, String description) {
        Date date = new Date();
        TaskDetail taskDetail = new TaskDetail(entityName, description, date.getTime());
        List<TaskDetail> list = this.tasks;
        synchronized (list) {
            this.tasks.add(taskDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskDetail> getTasks() {
        ArrayList<TaskDetail> filteredTasks = new ArrayList<TaskDetail>();
        for (TaskDetail task : this.tasks) {
            filteredTasks.add(task);
        }
        Date date = new Date();
        long currentTime = date.getTime();
        Iterator iterator = filteredTasks.iterator();
        while (iterator.hasNext()) {
            long diffInMins;
            TaskDetail task = (TaskDetail)iterator.next();
            if (task.isCompleted()) {
                iterator.remove();
            }
            if ((diffInMins = Math.abs(currentTime - task.getStartTime()) / 60000L) < 1L) continue;
            task.setCompleted(true);
        }
        List<TaskDetail> list = this.tasks;
        synchronized (list) {
            this.tasks = filteredTasks;
        }
        return filteredTasks;
    }

    public static class TaskDetail {
        private String taskName;
        private String taskDescription;
        private long startTime;
        private boolean completed;

        public TaskDetail(String taskName, String taskDescription, long startTime) {
            this.taskName = taskName;
            this.taskDescription = taskDescription;
            this.startTime = startTime;
            this.completed = false;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskDescription() {
            return this.taskDescription;
        }

        public void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }
    }
}

