/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.notification.impl;

import com.ning.http.client.ProxyServer;
import com.vmware.vcim.ngc.service.model.Notification;
import com.vmware.vcim.ngc.service.model.SubscriptionDetails;
import com.vmware.vcim.ngc.service.vpc.notification.AtmosphereOptions;
import com.vmware.vcim.ngc.service.vpc.notification.NotificationCallback;
import com.vmware.vcim.ngc.service.vpc.notification.NotificationChannelStateListener;
import com.vmware.vcim.ngc.service.vpc.notification.NotificationService;
import com.vmware.vcim.ngc.service.vpc.notification.impl.AtmosphereOptionsBuilder;
import com.vmware.vcim.ngc.service.vpc.notification.impl.ProxyAtmosphereClient;
import com.vmware.vcim.ngc.service.vpc.notification.impl.VCimNotifierImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.AtmosphereRequest;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNotificationClient
implements NotificationService {
    private static final Logger logger = LoggerFactory.getLogger(AsyncNotificationClient.class);
    private final Map<String, Boolean> statusMap = new HashMap<String, Boolean>();
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private static final String NC_SUFFIX = "_sub";
    private static final String NOTIFICATION_VERSION = "1";
    private final ObjectMapper mapper = new ObjectMapper();
    private NotificationCallback callback;
    private Map<String, NotificationChannelStateListener> listeners;
    private VCimNotifierImpl vcimNotifier;

    public AsyncNotificationClient(NotificationCallback callback, VCimNotifierImpl vcimNotifier) {
        this.callback = callback;
        this.vcimNotifier = vcimNotifier;
    }

    public void setListeners(Map<String, NotificationChannelStateListener> listeners) {
        this.listeners = listeners;
    }

    public void init() {
        this.vcimNotifier.setNotificationService(this);
    }

    @Override
    public void subscribeForNotifications(final SubscriptionDetails details) throws IOException {
        logger.info("Subscribe called for user - " + details.getUserName());
        this.statusMap.put(details.getUserName(), true);
        this.callback.addUser(details.getUserName());
        final ProxyAtmosphereClient client = (ProxyAtmosphereClient)ClientFactory.getDefault().newClient(ProxyAtmosphereClient.class);
        new Thread(){

            @Override
            public void run() {
                try {
                    AsyncNotificationClient.this.setupClient(details, client);
                }
                catch (Exception ex) {
                    logger.error("Exception while setting up notification client..", (Throwable)ex);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unSubscribe(String userName) {
        String waitString;
        logger.info("Unsubscribe called for user - " + userName);
        this.statusMap.put(userName, false);
        String string = waitString = this.getNCString(userName);
        synchronized (string) {
            waitString.notify();
        }
    }

    @Override
    public void unSubscribeAllSessions(String userName) {
        this.unSubscribe(userName);
        this.callback.removeUser(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupClient(SubscriptionDetails details, ProxyAtmosphereClient client) throws IOException {
        final String userName = details.getUserName();
        final String waitString = this.getNCString(userName);
        final Request.TRANSPORT transport = Request.TRANSPORT.LONG_POLLING;
        RequestBuilder request = ((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)client.newRequestBuilder().method(Request.METHOD.GET)).uri(details.getSubscribeUrl())).trackMessageLength(true).decoder((Decoder)new Decoder<String, Notification>(){

            public Notification decode(Event type, String rawData) {
                try {
                    byte[] bytes = rawData.getBytes("UTF-8");
                    String data = new String(bytes, "UTF-8");
                    logger.debug("AsyncNotifClient received message - {}", (Object)data);
                    logger.info("AsyncNotifClient received event type - {}", (Object)type.name());
                    data = data.trim();
                    if (data.length() == 0) {
                        return null;
                    }
                    if (type.equals((Object)Event.MESSAGE)) {
                        try {
                            return (Notification)AsyncNotificationClient.this.mapper.readValue(data, Notification.class);
                        }
                        catch (Exception ex) {
                            logger.error("Exception while trying to read json data into pojo..", (Throwable)ex);
                            AsyncNotificationClient.this.publishError(userName, ex);
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("Encoding exception...", (Throwable)e);
                    AsyncNotificationClient.this.publishError(userName, e);
                }
                return null;
            }
        })).transport(transport).header("username", userName)).header("Content-Type", "application/json;charset=utf-8")).header("Accept", "application/json;charset=utf-8")).header("ares-token", details.getAresAuthenticationToken())).header("company", details.getCompany())).header("notification-version", NOTIFICATION_VERSION)).header("timestamp", details.getLastTimeStamp());
        Socket socket = null;
        if (details.isUseProxy()) {
            ProxyServer ps = new ProxyServer(details.getProxyHost(), details.getProxyPort(), details.getProxyUsername(), details.getProxyPassword());
            AtmosphereOptions options = new AtmosphereOptionsBuilder().proxyServer(ps).build();
            socket = client.create(options);
        } else {
            try {
                socket = client.create();
            }
            catch (Exception e) {
                logger.error("Unable to create socket", (Throwable)e);
            }
        }
        socket.on("message", (Function)new Function<Notification>(){

            public void on(Notification t) {
                if (StringUtils.isNotEmpty((String)t.getId()) && "keep_alive".equals(t.getId())) {
                    logger.info("Keep Alive packet recieved.. Not propogated to callback.. ");
                    return;
                }
                String userName = t.getUserName();
                if (StringUtils.isNotEmpty((String)userName)) {
                    AsyncNotificationClient.this.publishNotification(t.getUserName(), t);
                } else {
                    logger.warn("Dropping notification with invalid/blank username : " + userName + ", Notification : " + t);
                }
            }
        }).on((Function)new Function<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(Throwable t) {
                logger.error("Recieved Exception from the publisher..", t);
                AsyncNotificationClient.this.publishError(userName, t);
                AsyncNotificationClient.this.statusMap.put(userName, false);
                String string = waitString;
                synchronized (string) {
                    waitString.notify();
                }
            }
        }).on(Event.CLOSE.name(), (Function)new Function<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void on(String t) {
                logger.info("Connection closed with msg {} ", (Object)t);
                if (!Request.TRANSPORT.LONG_POLLING.equals((Object)transport)) {
                    AsyncNotificationClient.this.publishClose(userName);
                    AsyncNotificationClient.this.statusMap.put(userName, false);
                    String string = waitString;
                    synchronized (string) {
                        waitString.notify();
                    }
                }
            }
        }).open(request.build());
        try {
            while (this.statusMap.get(userName) != false) {
                String e = waitString;
                synchronized (e) {
                    waitString.wait();
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            logger.warn("Interrupted for} user : " + userName);
            return;
        }
        finally {
            socket.close();
        }
    }

    private String getNCString(String userName) {
        return (userName + NC_SUFFIX).intern();
    }

    private void publishNotification(final String userName, final Notification notification) {
        logger.info("Client received notification for user - " + userName);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncNotificationClient.this.callback.onMessage(userName, notification);
            }
        });
    }

    private void publishError(final String userName, final Throwable error) {
        logger.error("Client received error for user - " + userName, error);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncNotificationClient.this.onError(userName, error);
            }
        });
    }

    private void onError(String userName, Throwable error) {
        logger.error("Error in notification channel for user: " + userName, error);
        if (this.listeners != null && this.listeners.size() > 0) {
            for (NotificationChannelStateListener listener : this.listeners.values()) {
                try {
                    listener.channelError(userName);
                }
                catch (Exception ex) {
                    logger.error("Error in communicating error to channel state listener", (Throwable)ex);
                }
            }
        }
    }

    private void publishClose(final String userName) {
        logger.info("Client received close for user - " + userName);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncNotificationClient.this.onClose(userName);
            }
        });
    }

    private void onClose(String userName) {
        logger.error("Received notification channel closed for user: " + userName);
        if (this.listeners != null && this.listeners.size() > 0) {
            for (NotificationChannelStateListener listener : this.listeners.values()) {
                try {
                    listener.channelClosed(userName);
                }
                catch (Exception ex) {
                    logger.error("Error in communicating close to channel state listener", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        for (String userName : this.statusMap.keySet()) {
            String waitString;
            String string = waitString = this.getNCString(userName);
            synchronized (string) {
                waitString.notify();
            }
        }
        this.statusMap.clear();
    }

    public static void main(String[] args) {
        NotificationCallback callback = new NotificationCallback(){

            @Override
            public void onMessage(String userName, Notification notification) {
                System.out.println("Recieved notification!");
                System.out.println("User : " + userName);
                System.out.println("Notification : " + notification);
            }

            @Override
            public void addUser(String user) {
            }

            @Override
            public void removeUser(String user) {
            }
        };
        AsyncNotificationClient client = new AsyncNotificationClient(callback, new VCimNotifierImpl());
        try {
            client.subscribeForNotifications(new SubscriptionDetails("stu@aries.com", "aries", "52e2b0f2e6d91022da72829293daf3d686a621a7,49724fd6-714d-4c5a-8de3-e024215a080c%3Btoyota%3B17c2ee27-534c-483d-88a6-35228cca724a%3Bstu%40toyota.com%3B9be56a94-c6cf-4dc8-be8d-30e0ae8872c4%3B4%235%231%232%233%3B1379759059192%3Btrue", "https://10.137.93.125/api/private/notifications/subscribe"));
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            System.err.println("Exception : " + ex.getMessage());
        }
    }
}

