/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinuxUtils {
    public static final int DS_DEV_NAME = 2;
    public static final int rd_ios = 3;
    public static final int rd_sect = 4;
    public static final int rd_ticks = 6;
    public static final int wr_ios = 7;
    public static final int wr_sect = 9;
    public static final int wr_ticks = 10;
    public static final int tot_ticks = 12;
    public static final int rq_ticks = 13;
    private static final File DISKSTATS = new File("/proc/diskstats");
    private static final File VMSTAT = new File("/proc/vmstat");
    private static final Log log = LogFactory.getLog(LinuxUtils.class);

    public static List<String> getBlockDevicesList() {
        ArrayList<String> res = new ArrayList<String>();
        List<String[]> stats = LinuxUtils.readFile(DISKSTATS);
        for (String[] fields : stats) {
            File blockDevice = new File("/sys/block/" + fields[2] + "/device/");
            double reads = Double.parseDouble(fields[3]);
            if (!blockDevice.canRead() || !(reads > 0.0)) continue;
            res.add(fields[2]);
        }
        return res;
    }

    public static List<String[]> getBlockDevicesStats() {
        ArrayList<String[]> res = new ArrayList<String[]>();
        List<String[]> stats = LinuxUtils.readFile(DISKSTATS);
        for (String[] fields : stats) {
            double reads = Double.parseDouble(fields[3]);
            if (!(reads > 0.0)) continue;
            res.add(fields);
        }
        return res;
    }

    public static Map<String, Double> getVMStats() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        List<String[]> stats = LinuxUtils.readFile(VMSTAT);
        for (String[] fields : stats) {
            if (fields.length != 2) continue;
            res.put(fields[0], Double.parseDouble(fields[1]));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> readFile(File file) {
        ArrayList<String[]> res = new ArrayList<String[]>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] fields = line.trim().split("\\s+");
                res.add(fields);
            }
        }
        catch (IOException ex) {
            log.debug((Object)("[readFile] " + ex), (Throwable)ex);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                log.debug((Object)("[readFile] " + ex), (Throwable)ex);
            }
        }
        return res;
    }
}

