/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.Relationship;

import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.Relationship.RelationshipUtils;

public class DnsNameExtractor {
    private static final Log log = LogFactory.getLog(DnsNameExtractor.class);
    private SSLSocketFactory originalDefaultSshSocketFactory = null;
    private final int DNS_NAME = 2;

    public Collection<String> getDnsNames(String url) throws Exception {
        Certificate[] certificates;
        HashSet<String> names = new HashSet<String>();
        for (Certificate cert : certificates = this.getCertificates(url)) {
            if (!(cert instanceof X509Certificate)) continue;
            names.addAll(this.getDnsNames((X509Certificate)cert));
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] getCertificates(String url) throws Exception {
        try {
            this.disableCertificateValidation();
            URL destinationURL = new URL(url);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)destinationURL.openConnection();
            httpsURLConnection.connect();
            Certificate[] certificateArray = httpsURLConnection.getServerCertificates();
            return certificateArray;
        }
        finally {
            this.resetCertificateValidation();
        }
    }

    private Collection<String> getDnsNames(X509Certificate cert) throws CertificateParsingException {
        X509Certificate x509Certificate = cert;
        HashSet<String> names = new HashSet<String>();
        String subject = x509Certificate.getSubjectDN().getName();
        log.debug((Object)String.format("Certificate subject: '%s'", subject));
        String cn = this.getCn(subject);
        if (StringUtils.isNotEmpty((String)cn)) {
            names.add(RelationshipUtils.getFqdn(cn));
        }
        for (List<?> alternativeNames : x509Certificate.getSubjectAlternativeNames()) {
            String aName;
            Integer altNameType = (Integer)alternativeNames.get(0);
            if (altNameType != 2 || !StringUtils.isNotEmpty((String)(aName = "" + alternativeNames.get(1)))) continue;
            names.add(RelationshipUtils.getFqdn(aName));
            log.debug((Object)String.format("Alternative DNS name: '%s'", alternativeNames.get(1)));
        }
        return names;
    }

    private String getCn(String subject) {
        String[] subjectTokens;
        for (String subjectToken : subjectTokens = subject.split(",")) {
            if (StringUtils.isEmpty((String)subjectToken) || !subjectToken.startsWith("CN=")) continue;
            return subjectToken.substring(3);
        }
        return null;
    }

    private void resetCertificateValidation() {
        if (this.originalDefaultSshSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(this.originalDefaultSshSocketFactory);
        }
    }

    private void disableCertificateValidation() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] naiveTrustManager = this.getNaiveTrustManager();
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, naiveTrustManager, new SecureRandom());
        this.originalDefaultSshSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private TrustManager[] getNaiveTrustManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

