/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class LongConfigOption
extends ConfigOption
implements Serializable {
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;

    public LongConfigOption(String optName, String optDesc, Long defValue) {
        super(optName, optDesc, defValue == null ? null : defValue.toString());
    }

    @Override
    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        long val;
        try {
            val = Long.parseLong(value);
        }
        catch (NumberFormatException exc) {
            throw this.invalidOption("must be a long");
        }
        if (val < this.getMinValue()) {
            throw this.invalidOption("must be >= " + this.getMinValue());
        }
        if (val > this.getMaxValue()) {
            throw this.invalidOption("must be <= " + this.getMaxValue());
        }
    }

    public void setMinValue(long len) {
        this.minValue = len;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(long len) {
        this.maxValue = len;
    }

    public long getMaxValue() {
        return this.maxValue;
    }
}

