/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.hyperic.hq.measurement.MeasurementConstants;

public class MeasurementInfo
implements Cloneable,
Serializable {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ALIAS = "alias";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_GROUP = "group";
    public static final String ATTR_UNITS = "units";
    public static final String ATTR_RATE = "rate";
    public static final String ATTR_COLLECTION_TYPE = "collectionType";
    public static final String ATTR_DEFAULTON = "defaultOn";
    public static final String ATTR_INDICATOR = "indicator";
    public static final String ATTR_INTERVAL = "interval";
    public static final String SEC_RATE = "1s";
    public static final String MIN_RATE = "1m";
    public static final String HOUR_RATE = "1h";
    public static final String NO_RATE = "none";
    public static final String DEFAULT_RATE = "1m";
    public static final String RATE_KEY = "__RATE__";
    private static final String[] COLL_TYPES = MeasurementConstants.COLL_TYPE_NAMES;
    private Map attrs = new HashMap();
    private int collType = -1;
    private boolean defaultOn = false;
    private boolean indicator = false;
    private long interval = -1L;

    public Object clone() {
        MeasurementInfo info = new MeasurementInfo();
        info.attrs = new HashMap();
        info.attrs.putAll(this.attrs);
        info.collType = this.collType;
        info.defaultOn = this.defaultOn;
        info.interval = this.interval;
        info.indicator = this.indicator;
        return info;
    }

    public void setAttributes(Map attrs) {
        String interval;
        this.attrs.putAll(attrs);
        this.defaultOn = this.getBooleanAttribute(ATTR_DEFAULTON);
        this.indicator = this.getBooleanAttribute(ATTR_INDICATOR);
        String type = this.getAttribute(ATTR_COLLECTION_TYPE);
        for (int i = 0; i < MeasurementConstants.COLL_TYPE_NAMES.length; ++i) {
            if (!MeasurementConstants.COLL_TYPE_NAMES[i].equals(type)) continue;
            this.collType = i;
            break;
        }
        this.interval = (interval = this.getAttribute(ATTR_INTERVAL)) == null ? -1L : (long)Integer.parseInt(interval);
    }

    public String toXML() {
        return this.toXML("");
    }

    private String attr(String key, boolean val) {
        return this.attr(key, String.valueOf(val));
    }

    private String attr(String key, long val) {
        return this.attr(key, String.valueOf(val));
    }

    private String attr(String key, String val) {
        return key + "=\"" + StringEscapeUtils.escapeXml((String)val) + "\"";
    }

    private String attr(String key) {
        return this.attr(key, this.getAttribute(key));
    }

    public String toXML(String indent) {
        String xindent = indent + "        ";
        String NL = "\n";
        return indent + "<metric " + this.attr(ATTR_NAME) + "\n" + xindent + this.attr(ATTR_ALIAS) + "\n" + xindent + this.attr(ATTR_TEMPLATE) + "\n" + xindent + this.attr(ATTR_CATEGORY) + "\n" + xindent + this.attr(ATTR_GROUP) + "\n" + xindent + this.attr(ATTR_DEFAULTON, this.defaultOn) + "\n" + xindent + this.attr(ATTR_INDICATOR, this.indicator) + "\n" + xindent + this.attr(ATTR_UNITS) + "\n" + xindent + this.attr(ATTR_COLLECTION_TYPE, COLL_TYPES[this.collType]) + "\n" + xindent + this.attr(ATTR_INTERVAL, this.interval) + "/>" + "\n";
    }

    public Map getAttributes() {
        return this.attrs;
    }

    private void setAttribute(String key, String val) {
        this.attrs.put(key, val);
    }

    private boolean getBooleanAttribute(String name) {
        return "true".equals(this.getAttribute(name));
    }

    private String getAttribute(String name) {
        return (String)this.attrs.get(name);
    }

    private String getAttribute(String name, String defVal) {
        String val = this.getAttribute(name);
        if (val != null) {
            return val;
        }
        return defVal;
    }

    public String getName() {
        return this.getAttribute(ATTR_NAME);
    }

    public void setName(String name) {
        this.setAttribute(ATTR_NAME, name);
    }

    public String getAlias() {
        return this.getAttribute(ATTR_ALIAS);
    }

    public void setAlias(String alias) {
        this.setAttribute(ATTR_ALIAS, alias);
    }

    public String getTemplate() {
        return this.getAttribute(ATTR_TEMPLATE);
    }

    public void setTemplate(String template) {
        this.setAttribute(ATTR_TEMPLATE, template);
    }

    public String getCategory() {
        return this.getAttribute(ATTR_CATEGORY);
    }

    public void setCategory(String category) {
        this.setAttribute(ATTR_CATEGORY, category);
    }

    public String getGroup() {
        return this.getAttribute(ATTR_GROUP, "");
    }

    public void setGroup(String group) {
        this.setAttribute(ATTR_GROUP, group);
    }

    public boolean isDefaultOn() {
        return this.defaultOn;
    }

    public void setDefaultOn(boolean defaultOn) {
        this.defaultOn = defaultOn;
    }

    public String getUnits() {
        return this.getAttribute(ATTR_UNITS, "");
    }

    public void setUnits(String units) {
        this.setAttribute(ATTR_UNITS, units);
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isIndicator() {
        return this.indicator;
    }

    public void setIndicator(boolean indicator) {
        this.indicator = indicator;
    }

    public int getCollectionType() {
        return this.collType;
    }

    public void setCollectionType(int i) {
        this.collType = i;
    }

    public String getRate() {
        return this.getAttribute(ATTR_RATE, "");
    }

    public void setRate(String rate) {
        this.setAttribute(ATTR_RATE, rate);
    }

    public String getReadableRate() {
        String rate = this.getRate();
        if (rate.equals(SEC_RATE)) {
            return "per Second";
        }
        if (rate.equals("1m")) {
            return "per Minute";
        }
        if (rate.equals(HOUR_RATE)) {
            return "per Hour";
        }
        throw new IllegalArgumentException("Invalid rate type: " + rate);
    }
}

