/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcDiskIO;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcUtil;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class ProcessData {
    public static final String NA = "-";
    public static final String LABEL_PID = "PID";
    public static final String LABEL_USER = "USER";
    public static final String LABEL_STIME = "STIME";
    public static final String LABEL_SIZE = "SIZE";
    public static final String LABEL_RSS = "RSS";
    public static final String LABEL_SHARE = "SHARE";
    public static final String LABEL_STATE = "STATE";
    public static final String LABEL_TIME = "TIME";
    public static final String LABEL_CPU = "%CPU";
    public static final String LABEL_MEM = "%MEM";
    public static final String LABEL_NAME = "COMMAND";
    public static Pattern baseNamePattern = Pattern.compile("\\d+|\\d+:\\d+|u:\\d+");
    public static final String PS_HEADER = "PID\tUSER\tSTIME\tSIZE\tRSS\tSHARE\tSTATE\tTIME\t%CPU\t%MEM\tCOMMAND";
    private long _pid;
    private String _owner;
    private long _startTime;
    private long _size;
    private long _resident;
    private long _share;
    private char _state;
    private long _cpuTotal;
    private double _cpuPerc;
    private double _memPerc;
    private long _totalDiskBytes;
    private long _diskBytesRead;
    private long _diskBytesWritten;
    private String _name;
    private String[] _args;
    private Map _env;
    private ProcState _procState;
    private ProcCredName _procCredName;
    private ProcCpu _procCpu;
    private ProcMem _procMem;
    private ProcDiskIO _procDiskIO;

    public void populate(SigarProxy sigar, long pid) throws SigarException {
        try {
            this._args = sigar.getProcArgs(pid);
        }
        catch (SigarException e) {
            this._args = new String[0];
        }
        try {
            this._env = sigar.getProcEnv(pid);
        }
        catch (SigarException e) {
            this._env = new HashMap();
        }
        this._procState = sigar.getProcState(pid);
        String unknown = "???";
        this._pid = pid;
        try {
            this._procCredName = sigar.getProcCredName(pid);
            this._owner = this._procCredName.getUser();
        }
        catch (SigarException e) {
            this._owner = "???";
        }
        try {
            this._procDiskIO = sigar.getProcDiskIO(pid);
            this._totalDiskBytes = this._procDiskIO.getBytesTotal();
            this._diskBytesRead = this._procDiskIO.getBytesRead();
            this._diskBytesWritten = this._procDiskIO.getBytesWritten();
        }
        catch (SigarException e) {
            this._diskBytesWritten = -1L;
            this._diskBytesRead = -1L;
            this._totalDiskBytes = -1L;
        }
        try {
            this._procCpu = sigar.getProcCpu(pid);
            this._startTime = this._procCpu.getStartTime();
        }
        catch (SigarException e) {
            this._startTime = -1L;
        }
        try {
            this._procMem = sigar.getProcMem(pid);
            this._size = this._procMem.getSize();
            this._resident = this._procMem.getResident();
            this._share = this._procMem.getShare();
            this._memPerc = (double)this._resident / (double)sigar.getMem().getTotal();
        }
        catch (SigarException e) {
            this._share = -1L;
            this._resident = -1L;
            this._size = -1L;
            this._memPerc = -1L;
        }
        this._state = this._procState.getState();
        if (this._procCpu != null) {
            this._cpuTotal = this._procCpu.getTotal();
            this._cpuPerc = this._procCpu.getPercent();
        } else {
            this._cpuTotal = -1L;
            this._cpuPerc = -1L;
        }
        this._name = ProcUtil.getDescription((SigarProxy)sigar, (long)pid);
    }

    public static ProcessData gather(SigarProxy sigar, long pid) throws SigarException {
        ProcessData data = new ProcessData();
        data.populate(sigar, pid);
        return data;
    }

    public String[] getProcArgs() {
        return this._args;
    }

    public Map getProcEnv() {
        return Collections.unmodifiableMap(this._env);
    }

    public ProcState getProcState() {
        return this._procState;
    }

    public ProcCredName getProcCredName() {
        return this._procCredName;
    }

    public ProcCpu getProcCpu() {
        return this._procCpu;
    }

    public ProcMem getProcMem() {
        return this._procMem;
    }

    public long getPid() {
        return this._pid;
    }

    public String getOwner() {
        return this._owner;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getSize() {
        return this._size;
    }

    public long getShare() {
        return this._share;
    }

    public long getResident() {
        return this._resident;
    }

    public char getState() {
        return this._state;
    }

    public long getCpuTotal() {
        return this._cpuTotal;
    }

    public double getCpuPerc() {
        return this._cpuPerc;
    }

    public double getMemPerc() {
        return this._memPerc;
    }

    public String getName() {
        return this._name;
    }

    public String getBaseName() {
        int ix = this._name.lastIndexOf("/");
        if (ix == -1) {
            ix = this._name.lastIndexOf("\\");
        }
        if (ix == -1) {
            return this._name;
        }
        String afterLastSlash = this._name.substring(ix + 1).trim();
        if (StringUtils.isEmpty((String)afterLastSlash) || baseNamePattern.matcher(afterLastSlash).matches()) {
            return this._name;
        }
        return afterLastSlash;
    }

    public String getFormattedStartTime() {
        return ProcessData.getFormattedStartTime(this._startTime);
    }

    public static String getFormattedStartTime(long time) {
        if (time == 0L) {
            return "00:00";
        }
        if (time == -1L) {
            return NA;
        }
        long timeNow = System.currentTimeMillis();
        String fmt = "MMMd";
        if (timeNow - time < 86400000L) {
            fmt = "HH:mm";
        }
        return new SimpleDateFormat(fmt).format(new Date(time));
    }

    public String getFormattedSize() {
        return Sigar.formatSize((long)this._size);
    }

    public String getFormattedShare() {
        return Sigar.formatSize((long)this._share);
    }

    public String getFormattedResident() {
        return Sigar.formatSize((long)this._resident);
    }

    public String getFormattedTotalDiskBytes() {
        return Sigar.formatSize((long)this._totalDiskBytes);
    }

    public String getFormattedDiskReadBytes() {
        return Sigar.formatSize((long)this._diskBytesRead);
    }

    public String getFormattedDiskWrittenBytes() {
        return Sigar.formatSize((long)this._diskBytesWritten);
    }

    public long getTotalDiskBytes() {
        return this._totalDiskBytes;
    }

    public long getdDiskReadBytes() {
        return this._diskBytesRead;
    }

    public long getDiskWrittenBytes() {
        return this._diskBytesWritten;
    }

    public String getFormattedCpuTotal() {
        return ProcessData.getFormattedCpuTotal(this._cpuTotal);
    }

    public static String getFormattedCpuTotal(long total) {
        if (total == -1L) {
            return NA;
        }
        long t = total / 1000L;
        String sec = String.valueOf(t % 60L);
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        return t / 60L + ":" + sec;
    }

    public String getFormattedCpuPerc() {
        if (this._cpuPerc == -1.0) {
            return NA;
        }
        return CpuPerc.format((double)this._cpuPerc);
    }

    public String getFormattedMemPerc() {
        if (this._memPerc == -1.0) {
            return NA;
        }
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(1);
        percentFormat.setMinimumFractionDigits(1);
        return percentFormat.format(this._memPerc);
    }

    public String toString(String delim) {
        return this._pid + delim + this._owner + delim + this.getFormattedStartTime() + delim + this.getFormattedSize() + delim + this.getFormattedResident() + delim + this.getFormattedShare() + delim + this._state + delim + this.getFormattedCpuTotal() + delim + this.getFormattedCpuPerc() + delim + this.getFormattedMemPerc() + delim + this.getBaseName();
    }

    public String toString() {
        return this.toString(",");
    }
}

