/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.snmp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.snmp.MIBLookupException;
import org.hyperic.snmp.MIBTree;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;
import org.snmp4j.AbstractTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

class SNMPSession_v1
implements SNMPSession {
    protected int version = 0;
    protected AbstractTarget target;
    protected Snmp session;
    private Address address;
    private static Snmp sessionInstance = null;
    protected static Log log = LogFactory.getLog((String)"SNMPSession");

    private Snmp getSessionInstance() throws IOException {
        if (sessionInstance == null) {
            String listen = "0.0.0.0/0";
            Object transport = this.address instanceof TcpAddress ? new DefaultTcpTransportMapping(new TcpAddress(listen)) : new DefaultUdpTransportMapping(new UdpAddress(listen));
            sessionInstance = new Snmp((TransportMapping)transport);
            sessionInstance.listen();
        }
        return sessionInstance;
    }

    SNMPSession_v1() {
    }

    protected void initSession(String address, String port, String transport, String retries, String timeout) throws SNMPException {
        if (address == null) {
            address = "127.0.0.1";
        }
        if (port == null) {
            port = SNMPClient.DEFAULT_PORT_STRING;
        }
        this.address = GenericAddress.parse((String)(transport + ":" + address + "/" + port));
        this.target.setAddress(this.address);
        this.target.setVersion(this.version);
        this.target.setRetries(Integer.parseInt(retries));
        this.target.setTimeout((long)Integer.parseInt(timeout));
        try {
            this.session = this.getSessionInstance();
        }
        catch (IOException e) {
            throw new SNMPException(e.getMessage(), e);
        }
    }

    void init(String address, String port, String community, String transport, String retries, String timeout) throws SNMPException {
        CommunityTarget target = new CommunityTarget();
        if (community == null) {
            community = SNMPClient.DEFAULT_COMMUNITY;
        }
        target.setCommunity(new OctetString(community));
        this.target = target;
        this.initSession(address, port, transport, retries, timeout);
    }

    protected static OID getOID(String name) throws MIBLookupException {
        MIBTree mibTree = MIBTree.getInstance();
        int[] oid = mibTree.getOID(name);
        if (oid == null) {
            String msg = "Failed to lookup OID for name=" + name;
            String unfound = mibTree.getLastLookupFailure();
            if (!name.equals(unfound)) {
                msg = msg + " (last lookup failure=" + unfound + ")";
            }
            throw new MIBLookupException(msg);
        }
        return new OID(oid);
    }

    protected PDU newPDU() {
        return new PDU();
    }

    protected PDU getPDU(String oid, int type) throws MIBLookupException {
        return this.getPDU(SNMPSession_v1.getOID(oid), type);
    }

    protected PDU getPDU(OID oid, int type) {
        PDU pdu = this.newPDU();
        pdu.setType(type);
        if (type == -91) {
            pdu.setMaxRepetitions(10);
            pdu.setNonRepeaters(0);
        }
        pdu.add(new VariableBinding(oid));
        return pdu;
    }

    private boolean walk(OID rootOID, List values) throws IOException {
        int requests = 0;
        int vars = 0;
        boolean isError = false;
        TreeUtils treeUtils = new TreeUtils((Session)this.session, (PDUFactory)new DefaultPDUFactory());
        List events = treeUtils.getSubtree((Target)this.target, rootOID);
        for (int i = 0; i < events.size(); ++i) {
            VariableBinding[] vb;
            TreeEvent e = (TreeEvent)events.get(i);
            ++requests;
            if (e.isError()) {
                isError = true;
                log.debug((Object)(rootOID + " walk: " + e.getErrorMessage()), (Throwable)e.getException());
            }
            if ((vb = e.getVariableBindings()) == null) continue;
            vars += vb.length;
            for (int j = 0; j < vb.length; ++j) {
                values.add(new SNMPValue(vb[j]));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(rootOID + " walk: " + requests + " requests, " + vars + " vars, avg=" + vars / requests));
        }
        return !isError;
    }

    private SNMPValue getValue(String name, int type) throws SNMPException {
        PDU request = this.getPDU(name, type);
        ResponseEvent event = null;
        try {
            event = this.session.send(request, (Target)this.target);
        }
        catch (IOException e) {
            throw new SNMPException("Failed to get " + name, e);
        }
        if (event == null) {
            throw new SNMPException("No response for " + name);
        }
        PDU response = event.getResponse();
        this.validateResponsePDU(name, response);
        VariableBinding var = response.get(0);
        if (var.isException()) {
            throw new MIBLookupException(name + ": " + var.getVariable().toString());
        }
        return new SNMPValue(var);
    }

    protected void validateResponsePDU(String name, PDU response) throws SNMPException {
        if (response == null) {
            throw new SNMPException("No response PDU for " + name);
        }
    }

    @Override
    public SNMPValue getSingleValue(String name) throws SNMPException {
        return this.getValue(name, -96);
    }

    @Override
    public SNMPValue getNextValue(String name) throws SNMPException {
        return this.getValue(name, -95);
    }

    @Override
    public List getColumn(String name) throws SNMPException {
        ArrayList values = new ArrayList();
        try {
            if (!this.walk(SNMPSession_v1.getOID(name), values)) {
                throw new SNMPException("No response for " + name);
            }
        }
        catch (IOException e) {
            throw new SNMPException(e.getMessage(), e);
        }
        return values;
    }

    private StringBuffer getSubId(OID oid1, int oid1Len, OID oid2) {
        int oid2Len = oid2.getValue().length;
        StringBuffer sb = new StringBuffer();
        for (int x = oid1Len; x < oid2Len; ++x) {
            sb.append(oid2.get(x));
            if (x >= oid2Len - 1) continue;
            sb.append('.');
        }
        return sb;
    }

    @Override
    public Map getTable(String name, int index) throws SNMPException {
        OID oid = (OID)SNMPSession_v1.getOID(name).clone();
        oid.append(index);
        HashMap<String, SNMPValue> map = new HashMap<String, SNMPValue>();
        List column = this.getColumn(name);
        for (int i = 0; i < column.size(); ++i) {
            SNMPValue value = (SNMPValue)column.get(i);
            StringBuffer sb = this.getSubId(oid, oid.getValue().length, value.oid);
            map.put(sb.toString(), new SNMPValue(value.oid, value.var));
        }
        return map;
    }

    @Override
    public SNMPValue getTableValue(String name, int index, String leaf) throws SNMPException {
        OID oid = (OID)SNMPSession_v1.getOID(name).clone();
        oid.append(index);
        oid.append(leaf);
        PDU request = this.getPDU(oid, -96);
        ResponseEvent event = null;
        try {
            event = this.session.send(request, (Target)this.target);
        }
        catch (IOException e) {
            throw new SNMPException("Failed to get " + name, e);
        }
        if (event == null) {
            throw new SNMPException("No response for " + name);
        }
        PDU response = event.getResponse();
        if (response == null) {
            throw new SNMPException("No response for " + name);
        }
        return new SNMPValue(response.get(0));
    }

    @Override
    public List getBulk(String name) throws SNMPException {
        return this.getColumn(name);
    }
}

