/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.PropertyEncryptionUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.security.SecurityUtil;

public class AutoApproveConfig {
    public static final String PLATFORM_PROPERTY_NAME = "platform";
    private static final Log LOG = LogFactory.getLog((String)AutoApproveConfig.class.getName());
    private static final String AUTO_APPROVE_PROPS_FILE_NAME = "auto-approve.properties";
    private Properties autoApproveProps = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoApproveConfig(String agentConfigDirName, String encryptionKeyFileName) {
        if (StringUtil.isNullOrEmpty(agentConfigDirName)) {
            LOG.error((Object)"Invalid agent configuration directory name - auto configuration of resources is skipped");
            return;
        }
        if (StringUtil.isNullOrEmpty(encryptionKeyFileName)) {
            LOG.error((Object)"Invalid encryption key file name - auto configuration of resources is skipped");
            return;
        }
        File agentConfigDir = new File(agentConfigDirName);
        if (!agentConfigDir.exists()) {
            LOG.error((Object)("Agent configuration directory doesn't exist: " + agentConfigDir.getAbsolutePath() + "- auto configuration of resources is skipped"));
            return;
        }
        File encryptionKeyFile = new File(encryptionKeyFileName);
        if (!encryptionKeyFile.exists()) {
            LOG.error((Object)("Encryption key file doesn't exist: " + encryptionKeyFile.getAbsolutePath() + "- auto configuration of resources is skipped"));
            return;
        }
        File autoApprovePropsFile = new File(agentConfigDir, AUTO_APPROVE_PROPS_FILE_NAME);
        if (autoApprovePropsFile.exists()) {
            char[] encryptionKey;
            String encryptionKeyFilePath = encryptionKeyFile.getAbsolutePath();
            try {
                encryptionKey = PropertyEncryptionUtil.getPropertyEncryptionKey(encryptionKeyFilePath);
            }
            catch (PropertyUtilException e) {
                LOG.error((Object)"Failed to read the properties encryption key - auto configuration of resources is skipped");
                return;
            }
            try {
                this.autoApproveProps = this.loadAutoApproveProps(autoApprovePropsFile, encryptionKey);
                LOG.info((Object)"Resources auto-approval configuration loaded");
                this.ensurePropertiesEncryption(autoApprovePropsFile, encryptionKeyFilePath);
            }
            finally {
                SecurityUtil.clearSensitiveData(encryptionKey);
            }
        }
        LOG.info((Object)"Resources auto-approval configuration not provided");
    }

    public boolean exists() {
        return this.autoApproveProps != null;
    }

    public boolean isAutoApproved(String resourceName) {
        return resourceName != null && this.exists() && Boolean.valueOf(this.autoApproveProps.getProperty(resourceName)) != false;
    }

    public Properties getPropertiesForResource(String resourceName) {
        Properties result = new Properties();
        if (!this.isAutoApproved(resourceName)) {
            return result;
        }
        int prefixLength = resourceName.length() + 1;
        for (Object keyRef : this.autoApproveProps.keySet()) {
            String key = (String)keyRef;
            if (key.equals(resourceName) || !key.startsWith(resourceName)) continue;
            result.put(key.substring(prefixLength), this.autoApproveProps.getProperty(key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadAutoApproveProps(File autoApprovePropsFile, char[] encryptionKey) {
        FileInputStream fis = null;
        try {
            Properties result = new Properties();
            fis = new FileInputStream(autoApprovePropsFile);
            result.load(fis);
            for (Object key : result.keySet()) {
                String keyStr = (String)key;
                String prop = result.getProperty(keyStr);
                if (!SecurityUtil.isMarkedEncrypted(prop)) continue;
                String decryptedProp = SecurityUtil.decrypt(encryptionKey, prop);
                result.setProperty(keyStr, decryptedProp);
            }
            Properties properties = result;
            return properties;
        }
        catch (IOException exc) {
            LOG.error((Object)"failed to load the properties file", (Throwable)exc);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    private void ensurePropertiesEncryption(File autoApprovePropsFile, String encryptionKeyFilePath) {
        HashSet<String> encSet = new HashSet<String>(this.autoApproveProps.size());
        for (Object key : this.autoApproveProps.keySet()) {
            encSet.add((String)key);
        }
        try {
            PropertyEncryptionUtil.ensurePropertiesEncryption(autoApprovePropsFile.getAbsolutePath(), encryptionKeyFilePath, encSet);
        }
        catch (PropertyUtilException exc) {
            LOG.info((Object)("Failed to ensure the encryption of auto-approve properties: " + exc.getMessage()));
        }
    }
}

