/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.Relationship;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelationshipModelWrapper
implements Map<String, Collection<String>> {
    private static final Log log = LogFactory.getLog(RelationshipModelWrapper.class);
    private static final String listSeparator = ",";
    private final String lineSeparator = "\n";
    private final String keyValueSeparator = "=";
    private Map<String, Collection<String>> innerMap = new HashMap<String, Collection<String>>();

    public RelationshipModelWrapper() {
    }

    public RelationshipModelWrapper(String relationshipModel) {
        for (String entry : relationshipModel.split("\n")) {
            String[] keyAndValue = entry.split("=", 2);
            String key = keyAndValue[0];
            Collection<String> value = this.getStringCollection(keyAndValue[1]);
            this.innerMap.put(key, value);
        }
    }

    private Collection<String> getStringCollection(String separatedStrings) {
        List<String> matchList = this.getSeparatedStrings(separatedStrings);
        ArrayList<String> result = new ArrayList<String>();
        for (String match : matchList) {
            if (StringUtils.isBlank((String)match)) continue;
            result.add(match.replaceAll(Pattern.quote(String.format("\\%s", listSeparator)), listSeparator));
        }
        return result;
    }

    private List<String> getSeparatedStrings(String separatedStrings) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile(String.format("(?:\\\\.|[^\\\\%s]++)*", listSeparator));
        Matcher regexMatcher = regex.matcher(separatedStrings);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList;
    }

    @Override
    public void put(String key, String value) {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)value)) {
            return;
        }
        log.debug((Object)String.format("'%s'='%s'", key, value));
        Object strings = this.get(key);
        if (strings == null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.innerMap.put(key, values);
            return;
        }
        this.innerMap.get(key).add(value);
    }

    public Map<String, Collection<String>> getInnerMap() {
        return this.innerMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Collection<String>> stringCollectionEntry : this.innerMap.entrySet()) {
            stringBuilder.append(stringCollectionEntry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(this.getEscapedValues(stringCollectionEntry.getValue()));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String getEscapedValues(Collection<String> strings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : strings) {
            stringBuilder.append(string.replace(listSeparator, "\\,"));
            stringBuilder.append(listSeparator);
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public void setInnerMap(Map<String, Collection<String>> innerMap) {
        this.innerMap = innerMap;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public Collection<String> get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public Collection<String> put(String key, Collection<String> values) {
        for (String value : values) {
            this.put(key, value);
        }
        return null;
    }

    @Override
    public Collection<String> remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Collection<String>> map) {
        log.debug((Object)String.format("adding: %s", map));
        this.innerMap.putAll(map);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<Collection<String>> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<String, Collection<String>>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.innerMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.innerMap.hashCode();
    }
}

