/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file.match;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.file.match.MasterMatchSelector;
import org.hyperic.util.file.match.MatchResults;
import org.hyperic.util.file.match.MatchSelector;
import org.hyperic.util.file.match.MatcherConfig;
import org.hyperic.util.file.match.MatcherException;
import org.hyperic.util.file.match.MatcherInterruptedException;
import org.hyperic.util.file.match.MatcherScanner;

public class Matcher {
    private List initScanners(MatcherConfig config, FileSystem[] filesystems, MatchResults results) {
        int i;
        List dirs = config.getSearchDirs();
        ArrayList<MatcherScanner> scanners = new ArrayList<MatcherScanner>();
        List selectorList = config.getMatchSelectors();
        List excludes = config.getExcludePatterns();
        Log log = config.getLog();
        MatchSelector[] selectors = new MatchSelector[selectorList.size()];
        for (i = 0; i < selectors.length; ++i) {
            selectors[i] = (MatchSelector)selectorList.get(i);
        }
        FileSelector[] masterSelectorArray = new FileSelector[]{new MasterMatchSelector(selectors, config.getAllowMultipleMatches())};
        String[] excludesArray = new String[excludes.size()];
        for (i = 0; i < excludesArray.length; ++i) {
            excludesArray[i] = excludes.get(i).toString();
        }
        for (i = 0; i < dirs.size(); ++i) {
            String dir = (String)dirs.get(i);
            if (this.shouldSkip(dir, log, results) || config.getFSTypes() != 0 && !this.isFSTypeMatch(dir, config.getFSTypes(), filesystems, log)) continue;
            MatcherScanner scanner = new MatcherScanner();
            scanner.setLog(log);
            scanner.setBasedir(new File(dir));
            scanner.setSelectors(masterSelectorArray);
            scanner.setExcludes(excludesArray);
            scanner.setFollowSymlinks(config.getFollowSymlinks());
            scanner.setMatcherInterruptCB(config.getMatcherInterruptCB());
            scanner.setMatcherProgressCB(config.getMatcherProgressCB());
            scanner.setMaxDepth(config.getMaxDepth());
            scanners.add(scanner);
        }
        return scanners;
    }

    private boolean isFSTypeMatch(String dir, int fstypes, FileSystem[] filesystems, Log log) {
        String longestMatch = "";
        int longestMatchIndex = -1;
        String absPath = new File(dir).getAbsolutePath();
        if (filesystems == null) {
            if (log != null) {
                log.error((Object)"matcher: filesystems array was never initialized.");
            }
            throw new IllegalArgumentException("filesystems array was never initialized.");
        }
        for (int i = 0; i < filesystems.length; ++i) {
            String fsMountPoint = filesystems[i].getDirName();
            if (!absPath.startsWith(fsMountPoint) || fsMountPoint.length() <= longestMatch.length()) continue;
            longestMatch = fsMountPoint;
            longestMatchIndex = i;
        }
        if (longestMatchIndex == -1) {
            if (log != null) {
                log.warn((Object)("Directory " + dir + " did not match " + "any filesystems, it will not be searched."));
            }
            return false;
        }
        return this.isCandidateFS(fstypes, filesystems[longestMatchIndex], log);
    }

    public boolean isCandidateFS(int fstype, FileSystem fs, Log log) {
        switch (fs.getType()) {
            case 0: {
                if (log != null) {
                    log.warn((Object)("Encountered UNKNOWN filesystem (device=" + fs.getDevName() + "): " + fs.getDirName()));
                }
                return false;
            }
            case 1: {
                if (log != null) {
                    log.warn((Object)("Encountered NONE filesystem (device=" + fs.getDevName() + "): " + fs.getDirName()));
                }
                return false;
            }
            case 2: {
                return fstype == 0 || fstype == 1;
            }
            case 3: {
                return fstype == 0 || fstype == 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        if (log != null) {
            log.warn((Object)("Encountered filesystem with invalid type (" + fs.getType() + ") (device=" + fs.getDevName() + "): " + fs.getDirName()));
        }
        return false;
    }

    private FileSystem[] loadFilesystems(MatcherConfig config) throws SigarException {
        Log log = config.getLog();
        if (config.getFSTypes() != 0) {
            Sigar sigar = new Sigar();
            try {
                FileSystem[] filesystems;
                FileSystem[] fileSystemArray = filesystems = sigar.getFileSystemList();
                return fileSystemArray;
            }
            catch (SigarException se) {
                if (log != null) {
                    log.error((Object)("matcher: error getting available filesystems:" + (Object)((Object)se)), (Throwable)se);
                }
                throw se;
            }
            finally {
                sigar.close();
            }
        }
        return null;
    }

    public synchronized MatchResults getMatches(MatcherConfig config) throws MatcherInterruptedException, SigarException {
        MatchResults results = new MatchResults();
        Log log = config.getLog();
        FileSystem[] filesystems = null;
        filesystems = this.loadFilesystems(config);
        List scanners = this.initScanners(config, filesystems, results);
        for (int i = 0; i < scanners.size(); ++i) {
            MatcherScanner scanner;
            block6: {
                scanner = (MatcherScanner)((Object)scanners.get(i));
                scanner.initMatches(results.matches);
                try {
                    scanner.doScan();
                }
                catch (MatcherInterruptedException mie) {
                    mie.setMatchesSoFar(scanner.getMatches());
                    if (log != null) {
                        log.warn((Object)"matcher: search interrupted.");
                    }
                    throw mie;
                }
                catch (Exception e) {
                    scanner.addError(new MatcherException("matcher: search error", e));
                    if (log == null) break block6;
                    log.error((Object)("matcher: search error: " + e), (Throwable)e);
                }
            }
            results.matches = scanner.getMatches();
            if (log != null) {
                log.debug((Object)("results.matches=" + results.matches));
            }
            results.errors.addAll(scanner.getErrors());
        }
        return results;
    }

    private boolean shouldSkip(String dir, Log log, MatchResults results) {
        if (dir == null) {
            String msg = "matcher: ignoring null dir.";
            if (log != null) {
                log.info((Object)msg);
            }
            results.errors.add(new MatcherException(msg));
            return true;
        }
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            String msg = "matcher: ignoring non-existent dir: " + dirFile.getAbsolutePath();
            if (log != null) {
                log.info((Object)msg);
            }
            results.errors.add(new MatcherException(msg));
            return true;
        }
        if (!dirFile.canRead()) {
            String msg = "matcher: ignoring unreadable dir: " + dirFile.getAbsolutePath();
            if (log != null) {
                log.info((Object)msg);
            }
            results.errors.add(new MatcherException(msg));
            return true;
        }
        if (!dirFile.isDirectory()) {
            String msg = "matcher: ignoring non-dir: " + dirFile.getAbsolutePath();
            if (log != null) {
                log.info((Object)msg);
            }
            results.errors.add(new MatcherException(msg));
            return true;
        }
        return false;
    }
}

