/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.RtStat;
import org.hyperic.hq.product.logparse.BaseLogParser;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class RtPlugin
extends GenericPlugin {
    protected BaseLogParser lp = null;
    private Log log = LogFactory.getLog(RtPlugin.class);
    double timeMultiplier = 1.0;
    public static String CONFIG_SVCID = "svcID";
    public static String CONFIG_TRANSFORM = "transforms";
    public static String CONFIG_DONTLOG = "dontlog";
    public static String CONFIG_INTERVAL = "interval";
    public static String CONFIG_LOGDIR = "logDir";
    public static String CONFIG_LOGMASK = "logMask";
    public static String CONFIG_EUINTERVAL = "eu_interval";
    public static String CONFIG_EULOGDIR = "eu_logDir";
    public static String CONFIG_EULOGMASK = "eu_logMask";
    public static final String PARAM_LOG_DIR = "responseTimeLogDir";
    public static final String DEFAULT_INTERVAL = "60";
    public static final String LOGFILE_SUFFIX = "_HQResponseTime.log";
    public static final int UNKNOWN = 0;
    public static final int ENDUSER = 1;
    public static final int WEBSERVER = 2;
    public static final int APPSERVER = 3;
    public static final int STARTRTTYPE = 1;
    public static final int ENDRTTYPE = 4;

    public abstract String convertFormat(String var1);

    public abstract int getSvcType();

    public abstract BaseLogParser getParser();

    public boolean supportsEndUser() {
        return false;
    }

    public String getLogFormat(ConfigResponse config) {
        return "";
    }

    public String getEULogFormat(ConfigResponse config) {
        return "";
    }

    public void dontLog(Long stat) {
        this.lp.DontLog(stat);
    }

    public void dontLog(String url) {
        this.lp.DontLog(url);
    }

    private void getTransforms(String transforms, ArrayList patterns, ArrayList subs) {
        String[] regexs = StringUtil.explode((String)transforms, (String)" ").toArray(new String[0]);
        for (int i = 0; i < regexs.length; ++i) {
            int ind = regexs[i].indexOf(124, 1);
            String pattern = regexs[i].substring(1, ind);
            String sub = regexs[i].substring(ind + 1, regexs[i].length() - 1);
            patterns.add(pattern);
            subs.add(sub);
        }
    }

    private void transformUrl(RtStat rs, String transforms) {
        if (transforms == null || transforms.equals("")) {
            return;
        }
        ArrayList patterns = new ArrayList();
        ArrayList subs = new ArrayList();
        this.getTransforms(transforms, patterns, subs);
        Perl5Matcher matcher = new Perl5Matcher();
        Pattern pattern = null;
        Perl5Compiler compiler = new Perl5Compiler();
        StringBuffer sb = new StringBuffer();
        Iterator p = patterns.iterator();
        Iterator s = subs.iterator();
        while (p.hasNext() && s.hasNext()) {
            int numsubs;
            String curpat = (String)p.next();
            String cursub = (String)s.next();
            try {
                sb.delete(0, sb.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            Perl5Substitution sub = new Perl5Substitution(cursub);
            try {
                pattern = compiler.compile(curpat);
            }
            catch (MalformedPatternException e) {
                this.log.error((Object)("Poorly formed pattern " + curpat.toString()));
            }
            if ((numsubs = Util.substitute((StringBuffer)sb, (PatternMatcher)matcher, (Pattern)pattern, (Substitution)sub, (String)rs.getUrl(), (int)-1)) == 0) continue;
            break;
        }
        rs.setUrl(sb.toString());
    }

    public void setTimeMultiplier(double t) {
        this.timeMultiplier = t;
    }

    public double getTimeMultiplier() {
        return this.timeMultiplier;
    }

    protected ParsedFile[] generateFileList(Properties alreadyParsedFiles, String logdir, String logmask) throws IOException {
        GlobFilenameFilter filter = new GlobFilenameFilter(logmask.trim());
        ArrayList<String> removedFiles = new ArrayList<String>();
        Enumeration<Object> en = alreadyParsedFiles.keys();
        while (en.hasMoreElements()) {
            String file = (String)en.nextElement();
            File temp = new File(file);
            if (!filter.accept(temp.getParentFile(), temp.getName())) continue;
            removedFiles.add(file);
        }
        File directory = new File(logdir);
        if (!directory.canRead()) {
            this.log.error((Object)("logDir (" + logdir + ") is not readable by the agent!"));
        }
        File[] flist = directory.listFiles((FilenameFilter)filter);
        ArrayList<ParsedFile> toParse = new ArrayList<ParsedFile>();
        if (flist == null || flist.length == 0) {
            this.log.warn((Object)("No valid response time log files found.  logDir='" + logdir + "', logMask='" + logmask + "'"));
            return toParse.toArray(new ParsedFile[0]);
        }
        for (int i = 0; i < flist.length; ++i) {
            Long len = new Long(flist[i].length());
            String canonPath = flist[i].getCanonicalPath();
            String value = alreadyParsedFiles.getProperty(canonPath);
            Long oldlen = value == null ? new Long(0L) : Long.valueOf(value);
            removedFiles.remove(canonPath);
            if (oldlen.compareTo(len) == 0) continue;
            this.log.debug((Object)("Adding " + canonPath + " to parse list " + "(offset=" + oldlen + ")"));
            toParse.add(new ParsedFile(canonPath, oldlen));
        }
        for (String toRemove : removedFiles) {
            this.log.debug((Object)("Removing " + toRemove + " from parse list"));
            this.log.debug((Object)toRemove);
            alreadyParsedFiles.remove(toRemove);
        }
        return toParse.toArray(new ParsedFile[0]);
    }

    protected void combineUrls(Hashtable foundNew, Hashtable foundOld, String transforms) {
        Enumeration en = foundNew.elements();
        while (en.hasMoreElements()) {
            RtStat rs = (RtStat)en.nextElement();
            this.transformUrl(rs, transforms);
            RtStat saved = (RtStat)foundOld.get(rs.getIpUrlKey());
            rs.recompute(saved);
            foundOld.put(rs.getIpUrlKey(), rs);
        }
    }

    public Collection getTimes(Integer svcID, Properties alreadyParsedFiles, String logdir, String logmask, String logfmt, int svcType, String transforms, ArrayList noLog, boolean collectIPs) throws IOException {
        Hashtable urls = new Hashtable();
        this.lp = this.getParser();
        this.lp.setTimeMultiplier(this.getTimeMultiplier());
        this.lp.urlDontLog(noLog);
        ParsedFile[] flist = this.generateFileList(alreadyParsedFiles, logdir, logmask);
        for (int i = 0; i < flist.length; ++i) {
            long[] flen = new long[1];
            ParsedFile f = flist[i];
            this.log.debug((Object)("Parsing log: " + f.fname));
            Hashtable rv = this.lp.parseLog(f.fname, this.convertFormat(logfmt), f.oldLen, svcID, svcType, flen, collectIPs);
            this.log.debug((Object)("Done parsing log, " + rv.keySet().size() + " elements in table"));
            alreadyParsedFiles.put(f.fname, Long.toString(flen[0]));
            this.combineUrls(rv, urls, transforms);
        }
        this.log.debug((Object)("Returning parsed data " + urls.values().size() + " entries"));
        return urls.values();
    }

    public static ConfigResponse getConfig(String prefix, String dir) {
        ConfigResponse config = new ConfigResponse();
        String file = prefix + LOGFILE_SUFFIX;
        if (dir != null) {
            config.setValue(CONFIG_LOGMASK, file);
            config.setValue(CONFIG_LOGDIR, dir);
            config.setValue(CONFIG_INTERVAL, DEFAULT_INTERVAL);
        }
        return config;
    }

    public static String getWebAppLogDir(InputStream is) {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        List filters = doc.getRootElement().getChildren("filter");
        for (int i = 0; i < filters.size(); ++i) {
            Element filter = (Element)filters.get(i);
            String filterName = filter.getChildText("filter-name");
            if (!"JMXFilter".equals(filterName)) continue;
            List params = filter.getChildren("init-param");
            for (int j = 0; j < params.size(); ++j) {
                Element param = (Element)params.get(j);
                String name = param.getChildText("param-name");
                String value = param.getChildText("param-value");
                if (!PARAM_LOG_DIR.equals(name)) continue;
                return value;
            }
        }
        return null;
    }

    protected class ParsedFile {
        public String fname;
        public long oldLen;

        public ParsedFile(String f, long len) {
            this.fname = f;
            this.oldLen = len;
        }

        public ParsedFile() {
        }
    }
}

