/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.util;

import java.io.File;
import java.io.IOException;
import org.springframework.roo.support.util.Assert;
import org.springframework.roo.support.util.FileCopyUtils;

public abstract class FileUtils {
    public static final boolean deleteRecursively(File file) {
        Assert.notNull(file, "File to delete required");
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (FileUtils.deleteRecursively(f)) continue;
                return false;
            }
        }
        file.delete();
        return true;
    }

    public static final boolean copyRecursively(File source, File destination, boolean deleteDestinationOnExit) {
        Assert.notNull(source, "Source directory required");
        Assert.notNull(destination, "Destination directory required");
        Assert.isTrue(source.exists(), "Source directory '" + source + "' must exist");
        Assert.isTrue(source.isDirectory(), "Source directory '" + source + "' must be a directory");
        if (destination.exists()) {
            Assert.isTrue(destination.isDirectory(), "Destination directory '" + destination + "' must be a directory");
        } else {
            destination.mkdirs();
            if (deleteDestinationOnExit) {
                destination.deleteOnExit();
            }
        }
        for (File s : source.listFiles()) {
            File d = new File(destination, s.getName());
            if (deleteDestinationOnExit) {
                d.deleteOnExit();
            }
            if (s.isFile()) {
                try {
                    FileCopyUtils.copy(s, d);
                    continue;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
            d.mkdir();
            if (FileUtils.copyRecursively(s, d, deleteDestinationOnExit)) continue;
            return false;
        }
        return true;
    }
}

