/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.client;

import java.util.Collection;
import java.util.Map;
import org.hyperic.hq.agent.AgentCommandsAPI;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.FileMetadata;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.client.AgentConnection;
import org.hyperic.hq.agent.commands.AgentBundle_args;
import org.hyperic.hq.agent.commands.AgentBundle_result;
import org.hyperic.hq.agent.commands.AgentDie_args;
import org.hyperic.hq.agent.commands.AgentPing_args;
import org.hyperic.hq.agent.commands.AgentRestart_args;
import org.hyperic.hq.agent.commands.AgentUpdateFiles_result;

public class LegacyAgentCommandsClientImpl
implements AgentCommandsClient {
    private AgentConnection agentConn;
    private AgentCommandsAPI verAPI;

    public LegacyAgentCommandsClientImpl(AgentConnection agentConn) {
        this.agentConn = agentConn;
        this.verAPI = new AgentCommandsAPI();
    }

    @Override
    public long ping() throws AgentRemoteException, AgentConnectionException {
        AgentPing_args args = new AgentPing_args();
        long sendTime = System.currentTimeMillis();
        this.agentConn.sendCommand("agent:ping", this.verAPI.getVersion(), args, false);
        long recvTime = System.currentTimeMillis();
        return recvTime - sendTime;
    }

    @Override
    public void restart() throws AgentRemoteException, AgentConnectionException {
        AgentRestart_args args = new AgentRestart_args();
        this.agentConn.sendCommand("agent:restart", this.verAPI.getVersion(), args);
    }

    @Override
    public void die() throws AgentRemoteException, AgentConnectionException {
        AgentDie_args args = new AgentDie_args();
        this.agentConn.sendCommand("agent:die", this.verAPI.getVersion(), args);
    }

    @Override
    public String getCurrentAgentBundle() throws AgentRemoteException, AgentConnectionException {
        AgentBundle_args args = new AgentBundle_args();
        AgentRemoteValue cmdRes = this.agentConn.sendCommand("agent:getCurrentAgentBundle", this.verAPI.getVersion(), args);
        return new AgentBundle_result(cmdRes).getCurrentAgentBundle();
    }

    @Override
    public AgentUpdateFiles_result agentUpdateFiles(FileMetadata[] filesToUpdate, String[] filesToRemove, Boolean restartIfSuccessful) throws AgentRemoteException, AgentConnectionException {
        throw new IllegalAccessError("Unidirectional agentUpdateFiles method was invoked on a bi-directional commands client.");
    }

    @Override
    public Map upgrade(String tarFile, String destination) throws AgentRemoteException, AgentConnectionException {
        throw new IllegalAccessError("Unidirectional upgrade method was invoked on a bi-directional commands client.");
    }

    public Map<String, Boolean> agentRemoveFile(Collection<String> files) throws AgentRemoteException, AgentConnectionException {
        throw new IllegalAccessError("Unidirectional agentRemoveFile method was invoked on a bi-directional commands client.");
    }
}

