create table "LdapServer" (
    "id" integer not null,
    "host" varchar(128) not null,
    "port" integer not null,
    "useSsl" boolean not null,
    "dn" varchar(128) not null,
    "password" varchar(128) not null,
    "baseDn" varchar(128) not null,
    "objectClass" varchar(128) not null
  );
create unique index "idx93330a92" on "Collection" ("vcServerId","start");
create table "VcimServer" (
    "id" integer primary key not null,
    "active" boolean not null,
    "host" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_VcimServer_id";
drop table "AggSample";
create unique index "idx2fab05d3" on "CustomerVm" ("vmId");
alter table "Token" drop column "expires";
alter table "Token" rename column "token" to "value";
alter table "CustomerVmRule" add column "createdBy" integer null;
update "CustomerVmRule" set "createdBy" = 1 where "createdBy" is null;
alter table "CustomerVmRule" alter column "createdBy" set not null;

create table "VcopsVmCollection" (
    "id" integer primary key not null,
    "vmId" integer not null,
    "collectionId" integer not null
  );
create sequence "s_VcopsVmCollection_id";
alter table "VcopsVmCollection" add constraint "VcopsVmCollectionFK20" foreign key ("vmId") references "Vm"("id");
alter table "VcopsVmCollection" add constraint "VcopsVmCollectionFK21" foreign key ("collectionId") references "Collection"("id");

create table "VcopsServer" (
    "id" integer primary key not null,
    "host" varchar(128) not null,
    "version" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_VcopsServer_id";

create table "VcVcops" (
    "vcServerId" bigint not null,
    "vcopsServerId" bigint not null,
    "changed" timestamp not null
  );
alter table "VcVcops" add constraint "VcVcopsFK8" foreign key ("vcServerId") references "VcServer"("id");
alter table "VcVcops" add constraint "VcVcopsFK9" foreign key ("vcopsServerId") references "VcopsServer"("id");
alter table "VcVcops" add constraint "VcVcopsCPK" unique("vcServerId","vcopsServerId");

alter table "VcServer" add column "instanceUuid" varchar(128);
update "VcServer" set "instanceUuid" = '' where "instanceUuid" is null;
alter table "VcServer" alter column "instanceUuid" set not null;
