alter table "EmailServer" add column "connectionSecurity" integer not null default(1);
alter table "EmailServer" alter column "connectionSecurity" drop default;

alter table "ZimbraServer" add column fingerprint varchar(128) not null default('');
alter table "ZimbraServer" alter column fingerprint drop default;
alter table "ZimbraServer" add column "randomArt" varchar(2000) not null default('');
alter table "ZimbraServer" alter column "randomArt" drop default;

alter table "LdapServer" add column "userNameAttr" varchar(128) not null default('sAMAccountName');
alter table "LdapServer" alter column "userNameAttr" drop default;

alter table "ReportSetLicenseSet" add constraint "ReportSetLicenseSetFK27" foreign key ("reportSetId") references "ReportSet"("id");
alter table "ReportSetLicenseSet" add constraint "ReportSetLicenseSetFK28" foreign key ("licenseSetId") references "LicenseSet"("id");

create table "InventoryItem" (
  "id" integer primary key not null,
  "vcServerId" integer not null,
  "nodeType" integer not null,
    "moref" varchar(128) not null,
    "name" varchar(128) not null,
    "parentMoref" varchar(128) not null,
    "resourcePoolMoref" varchar(128),
    "discovered" timestamp not null,
    "removed" timestamp
  );
create sequence "s_InventoryItem_id";
create unique index "InventoryItem_vcServerId_moref" on "InventoryItem" ("vcServerId","moref");

create table "SchemaInfo" (
    "id" integer not null,
    "version" integer not null,
    "migrationDone" boolean not null
  );
insert into "SchemaInfo" values(1, 12, false);

alter table "VmHistory" add column "hostId" integer null; -- Not null will be set by webapp later

create sequence "s_HostHistory_id";
create table "HostHistory" as select nextval('"s_HostHistory_id"') as id, id as "hostId",
  timestamp '2000-01-01' as time, timestamp '3000-01-01' as "nextTime", "fullName", version,
  "dnsName", "licenseId", "memSize" from "Host";
alter table "HostHistory" add constraint "HostHistoryFK2" foreign key ("hostId") references "Host"("id");
alter table "HostHistory" add constraint "HostHistoryFK4" foreign key ("licenseId") references "License"("id");
create unique index "HostHistory_hostId_time" on "HostHistory" ("hostId","time");

create view "HostLatestHistory" as
    select * from "HostHistory" a where exists(
        select * from (
            select distinct "hostId", max(time) over (partition by "hostId") latest from "HostHistory"
        ) b where a.time = b.latest and a."hostId" = b."hostId"
    );

drop view "LicenseHostCount";
create view "LicenseHostCount" as
    select l.id, l.name, l.code, count(l.code) as "numHosts" from "License" l, "HostLatestHistory" h
        where h."licenseId" = l.id
        group by l.id, l.name, l.code;

alter table "Host" drop column "fullName" cascade;
alter table "Host" drop column version cascade;
alter table "Host" drop column "dnsName" cascade;
alter table "Host" drop column "licenseId" cascade;
alter table "Host" drop column "memSize" cascade;

create view "HostLatest" as
    select h.id, h.uuid, h."vcServerId", moref, time, "nextTime", "fullName", version, "dnsName", "licenseId",
        "memSize" from "Host" h, "HostLatestHistory" hl where h.id = hl."hostId";

create view "VmHostHistory" as
    select distinct v."vcServerId", v."instanceUuid", v.moref as "vmMoref", v.id as "vmId", v."vcName" as "vmVcName",
        hh."dnsName" as "hostDnsName", vh.time as "vmFirstOnHost"
    from "Vm" v, "VmHistory" vh, "Host" h, "HostHistory" hh
    where v.id = vh."vmId" and v."hostId" = h.id and h.id = hh."hostId" and (vh.time, vh."nextTime") overlaps (hh.time, hh."nextTime");

create view "SampleToLicense" as
    select c."vcServerId", s.id "sampleId", s."collectionId", c.start, s."vmId",
    v."reportExclusionReason",
    vh.id "vmhId", vh."hostId",
    hh.id "hhId", hh."licenseId",
    l."licenseCategoryId",
    lc.billable
    from "Sample" s, "Collection" c, "Vm" v, "VmHistory" vh, "Host" h, "HostHistory" hh, "License" l, "LicenseCategory" lc
    where s."collectionId" = c.id and s."vmId" = v.id and v.id = vh."vmId" and (c.start, c.stop) overlaps (vh.time, vh."nextTime")
    and v."hostId" = h.id and hh."hostId" = h.id and (c.start, c.stop) overlaps (hh.time, hh."nextTime")
    and hh."licenseId" = l.id
    and l."licenseCategoryId" = lc.id;

alter table "VcdServer" drop column "vcloudService";

alter table "InventoryItem" add constraint "InventoryItemFK33" foreign key ("vcServerId") references "VcServer"("id");

update "CustomerLocation" set "countryCode" = 'GB' where "countryCode" = 'UK';
