-- See bug for details   https://bugzilla.eng.vmware.com/show_bug.cgi?id=1792573
-- By many reasons UM might mess with History Tables by creating overlapping records.

-- Note: this script is used for 3.5 varsion and used for that customer only. In case of other customers
--    it need to be tested first.

-- Script below try to solve this problem by resolving overlapping conflicts at VmHistory & HostHistory.
--  NOTE: for 3.6 more history tables need to add!

-- This script fix for History records for cases:
-- 1. Records duplications due open intervals failure
-- 2. System Time jittering. System time was changed significantly by going to the past => future => past.

-- # 2 case can be fixed by cleaning 'past' records. But in this case 'future' records will block metering.
-- Or #2 case can be fixed by sorting time intervals. This method is used in those cases.
--  To switch from one method to another use 'id' instead of 'time' & 'nextime' overlapping test.

UPDATE "VmHistory" as vh1
SET "nextTime"= (
   SELECT min(vh2.time) "minTime" from "VmHistory" vh2
   WHERE  vh2."vmId"=vh1."vmId" AND vh2.time > vh1.time
)
WHERE EXISTS (
   SELECT * from "VmHistory" vh2
   WHERE  vh2."vmId"=vh1."vmId" AND vh2.time > vh1.time AND vh2.time < vh1."nextTime"
);


UPDATE "HostHistory" as hh1
SET "nextTime"= (
   SELECT min(hh2.time) "minTime" from "HostHistory" hh2
   WHERE  hh2."hostId"=hh1."hostId" AND hh2.time > hh1.time
)
WHERE EXISTS (
   SELECT * from "HostHistory" hh2
   WHERE  hh2."hostId"=hh1."hostId" AND hh2.time > hh1.time AND hh2.time < hh1."nextTime"
);

-- For 3.6+ please add another History tables
