#!/bin/bash

source `dirname $0`/umsetenv.sh

function setConfigParam {
    if grep -q $2 $1; then
        sed -i  "s,^\($2=\).*,\1$3," $1
    else
        echo "$2=$3" >> $1
    fi

    echo "The number of collections, after which failing to collect products will be disabled, is set to $3."
}

if [ "$#" != 1 ]; then
    echo "Usage:"
    echo "./configureDisableProductPeriod.sh <collections>"
    exit 1
fi

numExpr='^[0-9]+$'
if ! [[ $1 =~ $numExpr ]] || [[ $1 -le 0 ]] || [[ $1 -gt 2147483647 ]]; then
      echo "Number of collections must be a positive integer." >&2; exit 1
fi


fileName=$TOMCAT_HOME/webapps/um/WEB-INF/classes/props/local.props
disableProductPeriodInHoursPropertyName=disableProductPeriodInHours
periodValue=$1

setConfigParam $fileName $disableProductPeriodInHoursPropertyName $periodValue

echo "Restarting vCloud Usage Meter"
sudo service tomcat stop
sudo service tomcat start
echo "Done with vCloud Usage Meter restart"

exit 0
