#!/usr/bin/perl

# Using /dev/random because perl's rand() function isn't cryptographically
# secure, and we don't want to install additional packages.
open(RANDOM, "/dev/random") || die $!;

# 8 bytes for the salt
read(RANDOM, $bytes, 8);
my $salt = join(', ', unpack('c*', $bytes));

# Set valid range for printable characters for the key phrase
my $min = 33;		# first printable char excluding space
my $range = 94;		# total number of printable chars

my $phrase = "";
# we need 7 random printable characters
for (my $i = 0; $i < 7; $i++) {
    # Skipping backslash because java interprets it as an escape
    my $char;
	do {
	    read(RANDOM, $byte, 1);
	    $char = chr((ord($byte) % $range) + $min);
	} until ($char ne '\\');
	$phrase .= $char;
}

close RANDOM;

# Define some locations and values for the local.props
my $developer_dir = "../../../../../../../webapp/src/main/resources/props";
my $deployed_dir = "/usr/share/tomcat/webapps/um/WEB-INF/classes/props";
my $localprops = "local.props";
my $saltparam = "encryptionKeySalt";
my $phraseparam = "encryptionKeyPhrase";

# Check if we're running in developer's env or deployed env
# Search for local.props
if (-e "$deployed_dir/$localprops") {
    # deployed env
    replace_params("$deployed_dir/$localprops", $salt, $phrase);
} elsif (-e "$developer_dir/$localprops") {
    # developer env
    replace_params("$developer_dir/$localprops", $salt, $phrase);
} elsif (-d $deployed_dir) {
    # deployed env, but file missing?
    warn("Warning: local.props file missing from $deployed_dir. Recreating.\n");
    create_localprops("$deployed_dir/$localprops", $salt, $phrase);
} elsif (-d $developer_dir) {
    # developer env, but file missing?
    warn("Warning: local.props file missing from $developer_dir. Recreating.\n");
    create_localprops("$developer_dir/$localprops", $salt, $phrase);
} else {
    die("Error: cannot determine the environment nor find local.props. Exiting.\n");
} 


sub replace_params {
    my $filename = shift(@_);
    my $salt     = shift(@_);
    my $phrase   = shift(@_);

    open(IN, $filename) || die $!;
    local $/ = undef;
    my $whole_file = <IN>;
    close IN;

    # Try to replace existing salt
    if(!($whole_file =~ s/$saltparam\s*=.*/$saltparam=$salt/)) {
        warn("Warning: $saltparam not found in $filename! Appending $saltparam instead.\n");
        $whole_file . "\n$saltparam=$salt\n";
    }

    # Try to replace existing phrase value
    if(!($whole_file =~ s/$phraseparam\s*=.*/$phraseparam=$phrase/)) {
        warn("Warning: $phraseparam not found in $filename! Appending $phraseparam instead.\n");
        $whole_file . "\n$phraseparam=$phrase\n";
    }

    print("Updating salt and key phrase in $filename\n");
    open(OUT, ">", $filename) || die $!;
    print(OUT $whole_file);
    close OUT;

    return;
}

sub create_localprops {
    my $filename = shift(@_);
    my $salt     = shift(@_);
    my $phrase   = shift(@_);

    print("Creating $filename with salt and key phrase\n");

    open(OUT, ">", $filename) || die $!;
    print(OUT "$saltparam=$salt\n");
    print(OUT "$phraseparam=$phrase\n");
    close OUT;

    return;
}


