#!/usr/bin/env bash
TOMCAT_HOME=/usr/share/tomcat
WEBAPPS=${TOMCAT_HOME}/webapps
UM=${WEBAPPS}/um
PATCH=/um361hp3
PATCH_SCRIPTS_FOLDER=/upgrade-scripts
BACKUP_DIR=/root
WAR_FILE=um.war
FILE_NAME_PATTERN=usage-meter-*
UM_HOME=/home/usgmtr
ROOT_DIR=/root
CLOUD_USAGE_METERING_DIR=/opt/vmware/cloudusagemetering
VERSION_FILE_DIR=${CLOUD_USAGE_METERING_DIR}/version
VERSION_FILE=${VERSION_FILE_DIR}/build_info.txt
if [ ! -f "${VERSION_FILE}" ]; then
    echo "UM Hot Patch 2 was installed wrongly. Restoring the deleted folders..."

    mkdir -p ${CLOUD_USAGE_METERING_DIR}
    cp -rf ${PATCH}${CLOUD_USAGE_METERING_DIR}/* ${CLOUD_USAGE_METERING_DIR}
    mkdir -p ${VERSION_FILE_DIR}

    echo "BuildNumber: 11832189" > ${VERSION_FILE}
    chown -R usgmtr:wheel ${CLOUD_USAGE_METERING_DIR}
    chmod -R u+rwx ${CLOUD_USAGE_METERING_DIR}

    mkdir -p ${UM_HOME}
    cp -rf ${PATCH}${UM_HOME} /home
    chown -R usgmtr:wheel ${UM_HOME}
    chmod -R u+rwx ${UM_HOME}
    
    cp -rf ${PATCH}${ROOT_DIR} /

    echo "Done restoring the "${CLOUD_USAGE_METERING_DIR}
fi

PATCH_VERSION_FILE=${PATCH}/build_info.txt
CURRENT_BUILD=`grep "BuildNumber" ${VERSION_FILE} | sed -r 's/\w+\:\s+//g'`
TARGET_BUILD=7359407
TARGET_PATCH_BUILD=8244445
TARGET_PATCH_LIMITED_BUILD=11273621
HP2_OFFICIAL_BUILD=11832189
CLASSES=WEB-INF/classes/com
LIB=WEB-INF/lib
HTML_FILES_FOLDER=/usr/share/tomcat/webapps/um
OLD_VIM_LIBRARY='vim25.jar'
NEW_VIM_LIBRARY='vim25-internal.jar'
SRM_LIBRARY_FOR_UPDATE='srm.jar'

# The script will be terminated if the build number of the appliance is different from 7359407 and 8244445
if [[ ${CURRENT_BUILD} = ${TARGET_BUILD} ]]; then
    echo "====================================================================="
    echo "Found Usage Meter 3.6.1 build 7359407. Proceed with patching..."
    echo "====================================================================="
elif [[ ${CURRENT_BUILD} = ${TARGET_PATCH_BUILD} ]] ; then
    echo "====================================================================="
    echo "Found Usage Meter 3.6.1 build 8244445. Proceed with patching..."
    echo "====================================================================="
elif [[ ${CURRENT_BUILD} = ${TARGET_PATCH_LIMITED_BUILD} ]] ; then
    echo "====================================================================="
    echo "Found Usage Meter 3.6.1 build 11273621. Proceed with patching..."
    echo "====================================================================="
elif [[ ${CURRENT_BUILD} = ${HP2_OFFICIAL_BUILD} ]] ; then
    echo "====================================================================="
    echo "Found Usage Meter 3.6.1 build 11832189. Proceed with patching..."
    echo "====================================================================="
else
    echo "======================================================================================"
    echo "This patch is produced especially for Usage Meter 3.6.1 build 7359407, 8244445"
    echo ", or 11832189 and supports only these versions. Terminating installation process!"
    echo "======================================================================================"
    exit 1
fi

service tomcat stop
sleep 2s
if [[ -e ${WEBAPPS}/${WAR_FILE} ]]; then
   mv ${WEBAPPS}/${WAR_FILE} ${BACKUP_DIR}
fi
cp ${VERSION_FILE} ${BACKUP_DIR}
# Copy class files from webapp
cp -fr ${PATCH}/${CLASSES}/* ${UM}/${CLASSES}
find ${UM}/${CLASSES} -type d -exec chmod 750 {} +
find ${UM}/${CLASSES} -type f -exec chmod 640 {} +
chown -R usgmtr:wheel ${UM}/${CLASSES}
# Copy libs
cp -fr ${PATCH}/${LIB}/${FILE_NAME_PATTERN} ${UM}/${LIB}/
rm -f ${UM}/${LIB}/$OLD_VIM_LIBRARY
cp -fr ${PATCH}/${LIB}/$NEW_VIM_LIBRARY ${UM}/${LIB}/
cp -fr ${PATCH}/${LIB}/$SRM_LIBRARY_FOR_UPDATE ${UM}/${LIB}/
chmod 640 ${UM}/${LIB}/${FILE_NAME_PATTERN}
chmod 640 ${UM}/${LIB}/$NEW_VIM_LIBRARY
chmod 640 ${UM}/${LIB}/$SRM_LIBRARY_FOR_UPDATE
chown -R usgmtr:wheel ${UM}/${LIB}/${FILE_NAME_PATTERN}
chown -R usgmtr:wheel ${UM}/${LIB}/$NEW_VIM_LIBRARY
chown -R usgmtr:wheel ${UM}/${LIB}/$SRM_LIBRARY_FOR_UPDATE

cp -rf ${PATCH}/_vcavServers.html ${HTML_FILES_FOLDER}/_vcavServers.html
chmod 640 ${HTML_FILES_FOLDER}/_vcavServers.html
chown -R usgmtr:wheel ${HTML_FILES_FOLDER}/_vcavServers.html

cp -rf ${PATCH}/_vcavServer.html ${HTML_FILES_FOLDER}/_vcavServer.html
chmod 640 ${HTML_FILES_FOLDER}/_vcavServer.html
chown -R usgmtr:wheel ${HTML_FILES_FOLDER}/_vcavServer.html

cp -rf ${PATCH}/manage.html ${HTML_FILES_FOLDER}/manage.html
chmod 640 ${HTML_FILES_FOLDER}/manage.html
chown -R usgmtr:wheel ${HTML_FILES_FOLDER}/manage.html

chmod 755 ${PATCH_SCRIPTS_FOLDER}/config-files-upgrade.sh
bash ${PATCH_SCRIPTS_FOLDER}/config-files-upgrade.sh

chmod 755 ${PATCH_SCRIPTS_FOLDER}/database-tables-upgrade.sh
bash ${PATCH_SCRIPTS_FOLDER}/database-tables-upgrade.sh

cp -f ${PATCH_VERSION_FILE} ${VERSION_FILE}
chmod 700 ${VERSION_FILE}
chown usgmtr:wheel ${VERSION_FILE}
sleep 2s
service tomcat start

# Fix the VAMI Welcome message
BUILD_NUM=$(cat ${PATCH}/build_num)
sed -i "s/\${app\.name} -.*/\${app\.name} - 3.6.1.0 Build ${BUILD_NUM}/" /opt/vmware/etc/isv/welcometext
chown usgmtr:wheel  /opt/vmware/etc/isv/welcometext
# Stop vami because we don't use it, and there are security issues logged against its ports (PR 1572959)
systemctl stop vami-sfcb
systemctl stop vami-lighttp
systemctl disable vami-sfcb
systemctl disable vami-lighttp
systemctl mask vami-sfcb
systemctl mask vami-lighttp

echo "All done!"
