/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.repository.model;

import org.apache.commons.lang.StringUtils;

public class ResourceKey {
    public static final String ID_SEPARATOR = "|";
    private String resourceMonitoredId;
    private String parentId;
    private ResourceKey parentResourceKey;

    public ResourceKey(String parentId, String resourceMonitoredId) {
        this.parentId = parentId;
        this.resourceMonitoredId = resourceMonitoredId;
        this.parentResourceKey = this.calcParentResourceKey();
    }

    public String getResourceMonitoredId() {
        return this.resourceMonitoredId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public ResourceKey getParentResourceKey() {
        return this.parentResourceKey;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ResourceKey)) {
            return false;
        }
        ResourceKey other = (ResourceKey)obj;
        boolean equals = this.resourceMonitoredId.equals(other.resourceMonitoredId);
        return equals &= this.parentId.equals(other.parentId);
    }

    public int hashCode() {
        return this.resourceMonitoredId.hashCode() + this.parentId.hashCode();
    }

    public String toString() {
        return this.parentId + " " + this.resourceMonitoredId;
    }

    private ResourceKey calcParentResourceKey() {
        String parentMonitoredResourceId;
        if (StringUtils.isEmpty((String)this.parentId)) {
            return null;
        }
        String parentParentId = StringUtils.substringBeforeLast((String)this.parentId, (String)ID_SEPARATOR);
        if (StringUtils.isEmpty((String)parentParentId)) {
            parentParentId = "NO_PARENT";
        }
        if (StringUtils.isEmpty((String)(parentMonitoredResourceId = StringUtils.substringAfterLast((String)this.parentId, (String)ID_SEPARATOR)))) {
            return null;
        }
        return new ResourceKey(parentParentId, parentMonitoredResourceId);
    }
}

