/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hqagent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.common.shared.ProductProperties;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.sigar.Sigar;
import org.hyperic.util.config.ConfigResponse;

public class AgentServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String UNAVAILABLE = "N/A";
    private static final String AGENT_BUNDLE_HOME = "agent.bundle.home";

    public ServerSignature getServerSignature() {
        return new ServerSignature("EP Ops Agent", new String[0], new String[0], new String[0]);
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> res = new ArrayList<ServerResource>();
        String platformDisplayName = this.getPlatformDisplayedName(platformConfig);
        String agtName = this.getAgentName(platformDisplayName);
        res.add(this.getAgentServerValue(agtName));
        return res;
    }

    private String getPlatformDisplayedName(ConfigResponse platformConfig) {
        return platformConfig.getValue("platform.display.name");
    }

    private String getAgentName(String platformDisplayName) {
        String agtName = "EP Ops Agent";
        return agtName + " - " + platformDisplayName;
    }

    private ServerResource getAgentServerValue(String agtName) {
        File dir;
        String version = ProductProperties.getVersion();
        String installPath = dir.getPath();
        for (dir = new File(".").getAbsoluteFile().getParentFile(); dir != null; dir = dir.getParentFile()) {
            if (!new File(dir, "conf/agent.properties").exists()) continue;
            installPath = dir.getPath();
            break;
        }
        ServerResource res = this.createServerResource(installPath);
        res.setName(agtName);
        res.setType("EP Ops Agent");
        res.setIdentifier("EP Ops Agent");
        res.setDescription("EP Ops Agent");
        ConfigResponse cprop = new ConfigResponse();
        cprop.setValue("version", version);
        cprop.setValue("JavaVersion", System.getProperty("java.version"));
        cprop.setValue("JavaVendor", System.getProperty("java.vm.vendor"));
        cprop.setValue("UserHome", System.getProperty("user.home"));
        cprop.setValue("SigarVersion", "1.6.6.0");
        cprop.setValue("SigarNativeVersion", Sigar.NATIVE_VERSION_STRING);
        cprop.setValue("AgentBundleVersion", this.getAgentBundleVersion());
        res.setCustomProperties(cprop);
        res.setProductConfig();
        res.setMeasurementConfig();
        return res;
    }

    private String getAgentBundleVersion() {
        String home = System.getProperty(AGENT_BUNDLE_HOME);
        if (home == null) {
            return UNAVAILABLE;
        }
        File bundleDir = new File(home);
        try {
            return bundleDir.getCanonicalFile().getName();
        }
        catch (IOException e) {
            return UNAVAILABLE;
        }
    }
}

