/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.agent.client.AskQuestionsUtil;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.CachedCertificateException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.RegisterAgentResult;
import org.hyperic.hq.bizapp.shared.lather.RegisterAgent_args;
import org.hyperic.hq.bizapp.shared.lather.RegisterAgent_result;
import org.hyperic.hq.bizapp.shared.lather.ServerInfo_result;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.NullLatherValue;
import org.hyperic.lather.client.LatherHTTPClient;
import org.hyperic.util.http.AgentRequest;
import org.hyperic.util.http.ServerHttpClient;
import org.hyperic.util.security.CertificateService;
import org.hyperic.util.security.EpopsSslSocketFactory;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;

public class BizappCallbackClient
extends AgentCallbackClient {
    private static final Log log = LogFactory.getLog(BizappCallbackClient.class);
    private static final String INVALID_CERT_IN_CHAIN_MSG = "Unable to complete agent setup. An unverified certificate without a valid chain was presented.";
    private static final String EXPIRED_CERT_IN_CHAIN_MSG = "Unable to complete agent setup. The certificate presented by the server has expired.";
    private static final String NOT_YET_VALID_CERT_IN_CHAIN_MSG = "Unable to complete agent setup. The certificate presented by the server is not valid.";
    private final KeystoreConfig keystoreConfig;

    public BizappCallbackClient(ProviderFetcher fetcher, AgentConfig bootConfig) {
        super(fetcher, bootConfig);
        if (bootConfig.isProxyServerSet()) {
            log.info((Object)("Setting proxy server: host=" + bootConfig.getProxyIp() + "; port=" + bootConfig.getProxyPort()));
            System.setProperty("lather.proxyHost", bootConfig.getProxyIp());
            System.setProperty("lather.proxyPort", String.valueOf(bootConfig.getProxyPort()));
        }
        String keyStorePropName = AgentConfig.PROP_KEYSTORE_PATH[0];
        System.setProperty(keyStorePropName, bootConfig.getBootProperties().getProperty(keyStorePropName));
        this.keystoreConfig = new AgentKeystoreConfig(bootConfig);
    }

    public void bizappServerInfo(X509Certificate[] cachedCertificatesChain) throws AgentCallbackClientException, IOException, AskQuestionsUtil.AutoQuestionException, AskQuestionsUtil.UserQuestionException {
        BizappCallbackHTTPClient httpClient;
        ProviderInfo provider = this.getProvider();
        String address = provider.getProviderAddress();
        if (address == null) {
            throw new IllegalStateException("Remote address is empty.");
        }
        try {
            httpClient = this.createBizappHttpClient(false);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        LatherHTTPClient latherClient = new LatherHTTPClient(address, (ServerHttpClient)httpClient);
        HttpResponse serverInfoHttpResponse = this.invokeUnparsedLatherCall(provider, "serverInfo", (LatherValue)NullLatherValue.INSTANCE, latherClient, true);
        if (serverInfoHttpResponse == null) {
            throw new AgentCallbackClientException("Got null server info response");
        }
        Object[] chain = httpClient.getAndResetUnverifiedCertificatesChain();
        if (chain == null) {
            this.getServerInfoResult(latherClient, serverInfoHttpResponse, (X509Certificate[])chain);
            return;
        }
        if (!Arrays.equals(chain, cachedCertificatesChain)) {
            log.debug((Object)("acceptChangedSSLCertFromServer : " + AgentConfig.acceptChangedSSLCertFromServer));
            if (!AgentConfig.acceptChangedSSLCertFromServer) {
                this.approveCertificate((X509Certificate[])chain);
            }
        }
        ServerInfo_result serverInfoResult = this.getServerInfoResult(latherClient, serverInfoHttpResponse, (X509Certificate[])chain);
        boolean isCustomCertificate = serverInfoResult.getIsCustomCertificate();
        log.info((Object)String.format("Is custom certificate: %s", isCustomCertificate));
        int certificateChainIndex = this.getCertificateChainIndex(isCustomCertificate);
        if (!isCustomCertificate && chain.length < 2) {
            System.out.println(INVALID_CERT_IN_CHAIN_MSG);
            throw new AskQuestionsUtil.AutoQuestionException(INVALID_CERT_IN_CHAIN_MSG);
        }
        BizappCallbackClient.importServerCertificate((X509Certificate)chain[certificateChainIndex], BizappCallbackClient.getAgentConfig());
    }

    private BizappCallbackHTTPClient createBizappHttpClient(boolean isSecure) throws KeyStoreException, IOException {
        X509TrustManager customTrustManager = KeystoreManager.getCustomTrustManager((KeystoreConfig)this.keystoreConfig);
        BizappCallbackHTTPClient httpClient = new BizappCallbackHTTPClient(this.keystoreConfig, customTrustManager, isSecure);
        return httpClient;
    }

    private ServerInfo_result getServerInfoResult(LatherHTTPClient latherClient, HttpResponse serverInfoHttpResponse, X509Certificate[] chain) throws AgentCallbackClientException {
        ServerInfo_result serverInfoResult;
        try {
            serverInfoResult = (ServerInfo_result)latherClient.parseLatherHttpResponse(serverInfoHttpResponse);
        }
        catch (LatherRemoteException e) {
            throw new AgentCallbackClientException(new CachedCertificateException(chain, (Exception)((Object)e)));
        }
        catch (IOException e) {
            throw new AgentCallbackClientException(e);
        }
        return serverInfoResult;
    }

    private void approveCertificate(X509Certificate[] chain) throws AskQuestionsUtil.AutoQuestionException, AgentCallbackClientException, AskQuestionsUtil.UserQuestionException {
        X509Certificate unverifiedCertificate = chain[0];
        String untrustedCertificateMsg = "\nThe server has presented an untrusted certificate. \n" + CertificateService.printCert((X509Certificate)unverifiedCertificate) + "\n\nVerify that the certificate above matches that of the Certificate Authority (CA) for your " + "server" + " Manager's cluster." + "\nThe CA is the direct signer of the certificates for the " + "server" + " nodes.\nThe agent must trust the CA certificate to connect to any node of the cluster.\n" + "\n\nFor more information on the certificate chain, choose the \"more\" option below.";
        System.out.println(untrustedCertificateMsg);
        log.info((Object)untrustedCertificateMsg);
        AskQuestionsUtil askQuestionsUtil = new AskQuestionsUtil(BizappCallbackClient.getAgentConfig());
        String certificateQuestion = "Do you trust this certificate";
        Boolean isTrustCertificateAnswer = false;
        try {
            isTrustCertificateAnswer = askQuestionsUtil.askYesNoMoreQuestion(certificateQuestion, false, null);
        }
        catch (IOException ex) {
            throw new AgentCallbackClientException(ex);
        }
        if (isTrustCertificateAnswer == null) {
            for (int i = 0; i < chain.length; ++i) {
                untrustedCertificateMsg = CertificateService.printCert((X509Certificate)chain[i]);
                System.out.println(untrustedCertificateMsg);
                log.info((Object)"user answered 'more'");
                log.info((Object)untrustedCertificateMsg);
            }
            System.out.println();
            try {
                isTrustCertificateAnswer = askQuestionsUtil.askYesNoQuestion(certificateQuestion, false, null);
            }
            catch (IOException ex) {
                throw new AgentCallbackClientException(ex);
            }
        }
        if (!isTrustCertificateAnswer.booleanValue()) {
            throw new AskQuestionsUtil.UserQuestionException("The certificate was rejected by the user");
        }
        Boolean isTrustHostName = false;
        try {
            boolean hostNameMatching;
            ProviderInfo provider = this.getProvider();
            String providerHost = provider.getProviderHost();
            String certificateCNField = CertificateService.extractAgentTokenFromCertificate((X509Certificate)unverifiedCertificate);
            String certificateHost = certificateCNField == null ? "" : certificateCNField;
            boolean bl = hostNameMatching = certificateHost != "" && certificateHost.equalsIgnoreCase(providerHost);
            if (!hostNameMatching) {
                String hostNameFailedMessage = "\nThe host name in the certificate could not be verified";
                System.out.println(hostNameFailedMessage);
                log.info((Object)hostNameFailedMessage);
                String trustHostNameQuestion = "Do you trust this host " + certificateHost + " in the certificate";
                isTrustHostName = askQuestionsUtil.askYesNoQuestion(trustHostNameQuestion, false, null);
                log.debug((Object)("isTrustHostName: " + isTrustHostName));
            } else {
                isTrustHostName = true;
                String hostNameValidated = "\nThe host name in the certificate is validated successfully";
                System.out.println(hostNameValidated);
                log.info((Object)hostNameValidated);
            }
        }
        catch (IOException ex) {
            throw new AgentCallbackClientException(ex);
        }
        if (!isTrustHostName.booleanValue()) {
            throw new AskQuestionsUtil.UserQuestionException("The hostname was not trusted in the certificate");
        }
    }

    private int getCertificateChainIndex(boolean isCustomCertificate) {
        return isCustomCertificate ? 0 : 1;
    }

    private static X509Certificate getCertificateByThumbprint(X509Certificate[] unverifiedCertificatesChain, String certificateThumbprint) {
        log.info((Object)("The following server certificate thumbprint will be trusted during registration: " + certificateThumbprint));
        for (X509Certificate certificate : unverifiedCertificatesChain) {
            if (!CertificateService.compareCertificateToThumbprint((X509Certificate)certificate, (String)certificateThumbprint)) continue;
            String trustServerCertificateThumbprintMsg = "Found a certificate thumbprint that matches the one provided in the properties file.";
            System.out.println(trustServerCertificateThumbprintMsg);
            log.info((Object)trustServerCertificateThumbprintMsg);
            return certificate;
        }
        return null;
    }

    public RegisterAgentResult registerAgent(String user, String pword, String agentIP, String version, byte[] csr) throws AgentCallbackClientException {
        BizappCallbackHTTPClient httpClient;
        if (ArrayUtils.isEmpty((byte[])csr)) {
            this.logAndThrowRegisterAgentNullArgumentError("certificate signing request", "csr");
        }
        ProviderInfo provider = this.getProvider();
        RegisterAgent_args args = new RegisterAgent_args();
        args.setUser(user);
        args.setPword(pword);
        args.setAgentIP(agentIP);
        args.setVersion(version);
        args.setCertificateRequest(csr);
        try {
            httpClient = this.createBizappHttpClient(true);
        }
        catch (KeyStoreException e) {
            throw new AgentCallbackClientException(e);
        }
        catch (IOException e) {
            throw new AgentCallbackClientException(e);
        }
        LatherHTTPClient latherClient = new LatherHTTPClient(provider.getProviderAddress(), (ServerHttpClient)httpClient);
        RegisterAgent_result res = (RegisterAgent_result)this.invokeLatherCall(provider, "registerAgent", (LatherValue)args, latherClient, true);
        return new RegisterAgentResult(res.getCertificate(), res.getErrorMessage());
    }

    private void logAndThrowRegisterAgentNullArgumentError(String argumentDescription, String argumentName) {
        log.error((Object)("Register agent called with no " + argumentDescription));
        throw new NullArgumentException(argumentName);
    }

    public static void importServerCertificate(X509Certificate certificate, AgentConfig agentConfig) {
        KeystoreManager keystoreManager = KeystoreManager.getKeystoreManager();
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(agentConfig.getBootProperties());
        keystoreManager.importServerCert((KeystoreConfig)keystoreConfig, certificate);
    }

    protected HttpResponse invokeUnparsedLatherCall(ProviderInfo provider, String methodName, LatherValue args, LatherHTTPClient latherClient, boolean closeConn) throws AgentCallbackClientException {
        String addr = provider.getProviderAddress();
        try {
            HttpResponse rtn = latherClient.invokeUnparsed(methodName, args, closeConn);
            return rtn;
        }
        catch (ConnectException exc) {
            String eMsg = "Unable to contact server @ " + addr + ": " + exc;
            log.error((Object)eMsg, (Throwable)exc);
            throw new AgentCallbackClientException(eMsg, exc);
        }
        catch (LatherRemoteException exc) {
            String eMsg = "Remote error while invoking '" + methodName + ": " + (Object)((Object)exc);
            log.error((Object)eMsg, (Throwable)exc);
            throw new AgentCallbackClientException(eMsg, exc);
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            throw new AgentCallbackClientException(exc);
        }
    }

    private static class ServerInfoCommandTrustStrategy
    implements TrustStrategy {
        private X509Certificate[] unverifiedCertificatesChain = null;
        private final X509TrustManager trustManager;

        public ServerInfoCommandTrustStrategy(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.setUnverifiedCertificatesChain(null);
            if (chain == null || chain.length < 1) {
                System.out.println(BizappCallbackClient.INVALID_CERT_IN_CHAIN_MSG);
                throw new CertificateException(BizappCallbackClient.INVALID_CERT_IN_CHAIN_MSG);
            }
            try {
                this.trustManager.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateExpiredException e) {
                System.out.println(BizappCallbackClient.EXPIRED_CERT_IN_CHAIN_MSG);
                log.error((Object)BizappCallbackClient.EXPIRED_CERT_IN_CHAIN_MSG, (Throwable)e);
                throw new CertificateException(BizappCallbackClient.EXPIRED_CERT_IN_CHAIN_MSG, e);
            }
            catch (CertificateNotYetValidException e) {
                System.out.println(BizappCallbackClient.NOT_YET_VALID_CERT_IN_CHAIN_MSG);
                log.error((Object)BizappCallbackClient.NOT_YET_VALID_CERT_IN_CHAIN_MSG, (Throwable)e);
                throw new CertificateException(BizappCallbackClient.NOT_YET_VALID_CERT_IN_CHAIN_MSG, e);
            }
            catch (CertificateException certException) {
                String serverCertificateThumbprintPropValue = AgentCallbackClient.getAgentConfig().getBootProperty("agent.setup.serverCertificateThumbprint");
                X509Certificate autoVerifiedCertificate = null;
                if (StringUtils.isNotEmpty((String)serverCertificateThumbprintPropValue) && !AgentConfig.acceptChangedSSLCertFromServer) {
                    autoVerifiedCertificate = BizappCallbackClient.getCertificateByThumbprint(chain, serverCertificateThumbprintPropValue = this.removeNonValidCharsFromThumb(serverCertificateThumbprintPropValue));
                    if (autoVerifiedCertificate != null) {
                        BizappCallbackClient.importServerCertificate(autoVerifiedCertificate, AgentCallbackClient.getAgentConfig());
                        return true;
                    }
                    throw certException;
                }
                this.setUnverifiedCertificatesChain(chain);
                return true;
            }
        }

        private String removeNonValidCharsFromThumb(String serverCertificateThumbprint) {
            return serverCertificateThumbprint.replaceAll("[^\\w\\s]", "");
        }

        private synchronized void setUnverifiedCertificatesChain(X509Certificate[] unverifiedCertificatesChain) {
            this.unverifiedCertificatesChain = unverifiedCertificatesChain;
        }

        public synchronized X509Certificate[] getAndResetUnverifiedCertificatesChain() {
            X509Certificate[] chain = this.unverifiedCertificatesChain;
            this.unverifiedCertificatesChain = null;
            return chain;
        }
    }

    private static class BizappCallbackHTTPClient
    extends ServerHttpClient {
        private final Log log = LogFactory.getLog(BizappCallbackHTTPClient.class);
        private final ServerInfoCommandTrustStrategy insecureTrustStrategy;

        public BizappCallbackHTTPClient(KeystoreConfig keystoreConfig, X509TrustManager defaultTrustManager, boolean isSecure) {
            super(keystoreConfig, LatherHTTPClient.getHttpConfig((int)10000, (int)40000), false, LatherHTTPClient.getMaxRequestsPerConnection(), LatherHTTPClient.isSupportRRDNS(), LatherHTTPClient.getFailPeriodInMin(), LatherHTTPClient.getDownPeriodInMin());
            if (!isSecure) {
                this.insecureTrustStrategy = new ServerInfoCommandTrustStrategy(defaultTrustManager);
                this.log.debug((Object)"Create BizappCallbackHTTPClient - not secure mode");
                SSLSocketFactory sslSocketFactory = this.getServerInfoCommandSSLSocketFactory(defaultTrustManager);
                this.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory));
            } else {
                this.insecureTrustStrategy = null;
                this.log.debug((Object)"Create BizappCallbackHTTPClient - secure mode");
            }
        }

        public HttpResponse post(String url, Map<String, String> params, boolean closeConn) throws ClientProtocolException, IOException {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Method", params.get("method"));
            AgentRequest request = new AgentRequest(url, AgentRequest.AgentHttpMethod.POST);
            request.setHeaders(headers);
            request.setParams(params);
            return this.serversManager.sendTryAll(request);
        }

        public X509Certificate[] getAndResetUnverifiedCertificatesChain() {
            return this.insecureTrustStrategy.getAndResetUnverifiedCertificatesChain();
        }

        private SSLSocketFactory getServerInfoCommandSSLSocketFactory(X509TrustManager defaultTrustManager) {
            RegisterSocketFactory sslSocketFactory;
            try {
                sslSocketFactory = new RegisterSocketFactory(this.insecureTrustStrategy, (X509HostnameVerifier)new AllowAllHostnameVerifier());
            }
            catch (Exception e) {
                this.log.error((Object)"Unknown exception occurred: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            return sslSocketFactory;
        }

        private class RegisterSocketFactory
        extends EpopsSslSocketFactory {
            public RegisterSocketFactory(TrustStrategy trustStrategy, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
                super(trustStrategy, hostnameVerifier);
            }

            public Socket createSocket() throws IOException {
                SSLSocket sslSocket = (SSLSocket)super.createSocket();
                this.setEnabledProtocols(sslSocket);
                return sslSocket;
            }

            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws UnknownHostException, IOException {
                SSLSocket sslSocket = (SSLSocket)super.createSocket(s, host, port, autoClose);
                this.setEnabledProtocols(sslSocket);
                return sslSocket;
            }

            public Socket createSocket(HttpParams params) throws IOException {
                SSLSocket sslSocket = (SSLSocket)super.createSocket(params);
                this.setEnabledProtocols(sslSocket);
                return sslSocket;
            }
        }
    }
}

