/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.bizapp.client.AgentCommandsCallbackClient;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.common.InvocationRequest;
import org.hyperic.hq.common.InvocationResponse;
import org.hyperic.hq.transport.PollerClient;

public class PollerClientImpl
implements PollerClient {
    private final AgentCommandsCallbackClient agentCommandsClient;
    private final Map<Class<?>, Object> serviceInterfaceName2ServiceInterface = new HashMap();
    private final ExecutorService invokersExecutor;
    private final ScheduledExecutorService scheduler;
    private final long frequency;

    public PollerClientImpl(AgentConfig config, AgentStorageProvider storageProvider, long frequency, int asyncThreadPoolSize) {
        this.agentCommandsClient = new AgentCommandsCallbackClient(new StorageProviderFetcher(storageProvider), config);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.invokersExecutor = Executors.newFixedThreadPool(asyncThreadPoolSize);
        this.frequency = frequency;
    }

    @Override
    public void start() {
        this.scheduler.scheduleAtFixedRate(new PollingRunnable(), this.frequency, this.frequency, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() throws InterruptedException {
        this.scheduler.shutdown();
        this.invokersExecutor.shutdown();
    }

    @Override
    public void registerService(Class<?> serviceInterface, Object serviceImpl) {
        this.serviceInterfaceName2ServiceInterface.put(serviceInterface, serviceImpl);
    }

    private class PollingRunnable
    implements Runnable {
        private final Log _log = LogFactory.getLog(PollingRunnable.class);
        private final LinkedBlockingQueue<InvocationResponse> responseQueue = new LinkedBlockingQueue();

        @Override
        public void run() {
            try {
                this.doPolling();
            }
            catch (Throwable t) {
                this._log.error((Object)"error while polling messages from server: ", t);
            }
        }

        private void doPolling() throws Throwable {
            List<InvocationRequest> invocations = PollerClientImpl.this.agentCommandsClient.getAgentCommands();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Got invocation requests from the server '" + invocations + "'"));
            }
            if (!invocations.isEmpty()) {
                this.dispatchInvocationRequests(invocations, this.responseQueue);
            }
            ArrayList<InvocationResponse> responses = new ArrayList<InvocationResponse>();
            this.responseQueue.drainTo(responses);
            if (!responses.isEmpty()) {
                if (!PollerClientImpl.this.agentCommandsClient.sendAgentResponses(responses)) {
                    this._log.error((Object)("A problem has occured while sending these responses to the server: " + responses));
                } else if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Successfully sent these responses to the server: " + responses));
                }
            }
        }

        private void dispatchInvocationRequests(List<InvocationRequest> invocations, final LinkedBlockingQueue<InvocationResponse> responseQueue) throws Throwable {
            final CountDownLatch doneSignal = new CountDownLatch(invocations.size());
            for (final InvocationRequest invocation : invocations) {
                PollerClientImpl.this.invokersExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Object service = PollerClientImpl.this.serviceInterfaceName2ServiceInterface.get(invocation.getServiceInterface());
                        try {
                            Method method = service.getClass().getMethod(invocation.getMethod(), invocation.getParameterTypes());
                            Object result = method.invoke(service, invocation.getArgs());
                            InvocationResponse response = new InvocationResponse(invocation.getSessionId(), result);
                            responseQueue.put(response);
                        }
                        catch (Throwable t) {
                            PollingRunnable.this._log.error((Object)t, t);
                        }
                        doneSignal.countDown();
                    }
                });
            }
            doneSignal.await();
        }
    }
}

