/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.hyperic.hq.product.PluginException;

public class ReadData {
    public static long MAX_BYTES = 0x100000L;
    private String _path;
    private long _fileSize;
    private long _offset;
    private long _numBytes;
    private long _lastModified;
    private String _data;

    void populate(String path, long offset, int numBytes) throws PluginException {
        if ((long)numBytes > MAX_BYTES) {
            throw new PluginException("Requested to read " + numBytes + " which exceeds the maximum of " + MAX_BYTES);
        }
        File f = new File(path);
        this._path = f.getAbsolutePath();
        this._fileSize = f.length();
        this._lastModified = f.lastModified();
        FileReader fIn = null;
        try {
            fIn = new FileReader(f);
            if (offset < 0L) {
                offset = this._fileSize + offset;
            }
            char[] buf = new char[numBytes];
            fIn.skip(offset);
            int numRead = fIn.read(buf);
            this._data = new String(buf, 0, numRead);
            this._offset = offset;
            this._numBytes = numRead;
        }
        catch (FileNotFoundException e) {
            throw new PluginException("Cannot read [" + path + "].  File not found");
        }
        catch (IOException e) {
            throw new PluginException("IOException reading file: " + e.getMessage());
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String getPath() {
        return this._path;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public long getOffset() {
        return this._offset;
    }

    public long getNumBytes() {
        return this._numBytes;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public String getData() {
        return this._data;
    }

    public static ReadData gather(String file, long offset, int numBytes) throws PluginException {
        ReadData res = new ReadData();
        res.populate(file, offset, numBytes);
        return res;
    }
}

