/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import org.hyperic.hq.plugin.system.WhoLogTrackPlugin;
import org.hyperic.hq.plugin.system.WindowsEventLogNotification;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.Win32EventLogNotification;
import org.hyperic.hq.product.Win32EventLogTrackPlugin;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.StringConfigOption;

public class WindowsLogTrackPlugin
extends Win32EventLogTrackPlugin {
    private WhoLogTrackPlugin whoTracker = null;
    private boolean enableWhoTracker;

    protected boolean supportsPatternMatching() {
        return false;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.enableWhoTracker = manager.isPropertyEnabled("system.whoTracker", true);
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        if (this.enableWhoTracker) {
            this.whoTracker = new WhoLogTrackPlugin((LogTrackPlugin)this);
            this.getManager().addRunnableTracker((Runnable)this.whoTracker);
        }
        String prop = "platform.log_track.default";
        this.getManager().getProperties().setProperty("platform.log_track.default", this.getName());
    }

    public void shutdown() throws PluginException {
        if (this.whoTracker != null) {
            this.getManager().removeRunnableTracker((Runnable)this.whoTracker);
            this.whoTracker.shutdown();
            this.whoTracker = null;
        }
        super.shutdown();
    }

    static void setDefaultConfig(ConfigResponse config) {
        config.setValue("platform.log_track.eventlogs", "System");
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        StringConfigOption option = new StringConfigOption("platform.log_track.eventlogs", "Event Log names", "System");
        schema.addOption((ConfigOption)option);
        return schema;
    }

    public Win32EventLogNotification getEventLogNotification() {
        return new WindowsEventLogNotification((LogTrackPlugin)this);
    }
}

