/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.PropertyPair;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.ShouldShutdownGracefully;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.measurement.agent.ScheduledMeasurement;
import org.hyperic.hq.measurement.agent.client.MeasurementCommandsClient;
import org.hyperic.hq.measurement.agent.commands.DeleteProperties_args;
import org.hyperic.hq.measurement.agent.commands.GetMeasurements_args;
import org.hyperic.hq.measurement.agent.commands.GetMeasurements_result;
import org.hyperic.hq.measurement.agent.commands.ScheduleMeasurements_args;
import org.hyperic.hq.measurement.agent.commands.ScheduleMeasurements_metric;
import org.hyperic.hq.measurement.agent.commands.ScheduleTopn_args;
import org.hyperic.hq.measurement.agent.commands.SetProperties_args;
import org.hyperic.hq.measurement.agent.commands.TrackPluginAdd_args;
import org.hyperic.hq.measurement.agent.commands.TrackPluginRemove_args;
import org.hyperic.hq.measurement.agent.commands.UnscheduleMeasurementsById_args;
import org.hyperic.hq.measurement.agent.commands.UnscheduleMeasurements_args;
import org.hyperic.hq.measurement.agent.server.MeasurementSchedule;
import org.hyperic.hq.measurement.agent.server.ScheduleThread;
import org.hyperic.hq.measurement.agent.server.TopNScheduler;
import org.hyperic.hq.measurement.server.session.SRN;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginExistsException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.schedule.UnscheduledItemException;
import org.hyperic.util.timer.StopWatch;

public class MeasurementCommandsService
implements MeasurementCommandsClient,
ShouldShutdownGracefully {
    private static final Log _log = LogFactory.getLog(MeasurementCommandsService.class);
    private final AgentStorageProvider _storage;
    private final Map _validProps;
    private final MeasurementSchedule _schedStorage;
    private final ScheduleThread _scheduleObject;
    private final TopNScheduler _topNScheduler;
    private final LinkedBlockingQueue<ScheduleMeasurements_args> argQueue = new LinkedBlockingQueue();
    private final Scheduler _scheduler;
    private static final int[] resourcesType = new int[]{1, 2, 3};

    public MeasurementCommandsService(AgentStorageProvider storage, Map validProps, MeasurementSchedule schedStorage, ScheduleThread scheduleObject, TopNScheduler topNScheduler) {
        this._storage = storage;
        this._validProps = validProps;
        this._schedStorage = schedStorage;
        this._scheduleObject = scheduleObject;
        this._topNScheduler = topNScheduler;
        this._scheduler = new Scheduler();
        this._scheduler.start();
    }

    public void addTrackPlugin(String id, String pluginType, String resourceName, ConfigResponse response) throws AgentRemoteException {
        boolean isUpdate;
        GenericPlugin plugin;
        if (!pluginType.equals("log_track")) {
            throw new AgentRemoteException("Unknown plugin type=" + pluginType);
        }
        LogTrackPluginManager manager = AgentDaemon.getMainInstance().getLogTrackPluginManager();
        try {
            plugin = manager.getPlugin(id);
            isUpdate = true;
        }
        catch (PluginNotFoundException e) {
            plugin = null;
            isUpdate = false;
        }
        try {
            _log.info((Object)((isUpdate ? "Updating" : "Creating") + " " + manager.getName() + " plugin " + id + " [" + resourceName + "]"));
            if (isUpdate) {
                manager.updatePlugin(plugin, response);
            } else {
                manager.createPlugin(id, resourceName, response);
            }
        }
        catch (PluginNotFoundException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PluginExistsException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PluginException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new AgentRemoteException(e.getMessage());
        }
    }

    void addTrackPlugin(TrackPluginAdd_args ta) throws AgentRemoteException {
        String id = ta.getName();
        String pluginType = ta.getType();
        String resourceName = ta.getResourceName();
        ConfigResponse response = ta.getConfigResponse();
        this.addTrackPlugin(id, pluginType, resourceName, response);
    }

    public void deleteProperties(DeleteProperties_args args) throws AgentRemoteException {
        int i;
        int nProps = args.getNumProperties();
        for (i = 0; i < nProps; ++i) {
            if (this._validProps.get(args.getPropertyName(i)) != null) continue;
            throw new AgentRemoteException("Unknown measurement property name, '" + args.getPropertyName(i) + "'");
        }
        for (i = 0; i < nProps; ++i) {
            this._storage.setValue(args.getPropertyName(i), null);
        }
    }

    public GetMeasurements_result getMeasurements(GetMeasurements_args args) throws AgentRemoteException {
        GetMeasurements_result res = new GetMeasurements_result();
        int nArgs = args.getNumMeasurements();
        boolean isDebug = _log.isDebugEnabled();
        _log.debug((Object)"Getting real time measurements");
        for (int i = 0; i < nArgs; ++i) {
            Throwable tExc = null;
            String arg = args.getMeasurement(i);
            String excMsg = null;
            String tmpl = arg.substring(arg.indexOf(58) + 1);
            try {
                MetricValue val = AgentDaemon.getMainInstance().getMeasurementPluginManager().getValue(arg);
                res.addMeasurement(val);
                if (isDebug) {
                    tmpl = Metric.parse((String)tmpl).toDebugString();
                    _log.debug((Object)("Getting real time measurement: " + tmpl));
                    _log.debug((Object)("Result was: " + val));
                }
            }
            catch (PluginNotFoundException exc) {
                excMsg = "Plugin not found: ";
                tExc = exc;
            }
            catch (PluginException exc) {
                excMsg = "Plugin error: ";
                tExc = exc;
            }
            catch (MetricInvalidException exc) {
                excMsg = "Invalid request: ";
                tExc = exc;
            }
            catch (MetricNotFoundException exc) {
                excMsg = "Error retrieving value: ";
                tExc = exc;
            }
            catch (MetricUnreachableException exc) {
                excMsg = "Error contacting resource: ";
                tExc = exc;
            }
            if (excMsg == null || tExc == null) continue;
            excMsg = tExc.getMessage() == null ? excMsg + tExc : excMsg + tExc.getMessage();
            if (isDebug) {
                tmpl = Metric.parse((String)tmpl).toDebugString();
                _log.debug((Object)("Error getting real time measurement '" + tmpl + "': " + excMsg), tExc);
            } else {
                _log.error((Object)("Error getting real time measurement: " + excMsg));
            }
            res.addException(excMsg);
        }
        _log.debug((Object)"Finished getting real time measurements");
        return res;
    }

    public void removeTrackPlugin(String id, String pluginType) throws AgentRemoteException {
        try {
            if (!pluginType.equals("log_track")) {
                throw new AgentRemoteException("Unknown plugin type");
            }
            AgentDaemon.getMainInstance().getLogTrackPluginManager().removePlugin(id);
        }
        catch (PluginNotFoundException e) {
        }
        catch (PluginException e) {
            throw new AgentRemoteException(e.getMessage());
        }
    }

    void removeTrackPlugin(TrackPluginRemove_args ta) throws AgentRemoteException {
        String id = ta.getName();
        String pluginType = ta.getType();
        this.removeTrackPlugin(id, pluginType);
    }

    public void scheduleMeasurements(ScheduleMeasurements_args args) throws AgentRemoteException {
        this.argQueue.add(args);
    }

    private void scheduleMeasurements(Collection<ScheduleMeasurements_args> args) throws AgentRemoteException {
        HashMap<AppdefEntityID, SRN> aeids = new HashMap<AppdefEntityID, SRN>();
        StopWatch watch = new StopWatch();
        ArrayList<ScheduledMeasurement> metrics = new ArrayList<ScheduledMeasurement>(args.size());
        boolean debug = _log.isDebugEnabled();
        if (debug) {
            watch.markTimeBegin("unscheduleMeasurements");
        }
        for (ScheduleMeasurements_args arg : args) {
            SRN srn = arg.getSRN();
            AppdefEntityID aeid = srn.getEntity();
            aeids.put(aeid, srn);
            try {
                this.unscheduleMeasurements(aeid);
            }
            catch (UnscheduledItemException e) {
                _log.debug((Object)e, (Throwable)e);
            }
        }
        if (debug) {
            watch.markTimeEnd("unscheduleMeasurements");
        }
        if (debug) {
            watch.markTimeBegin("deleteMeasurements");
        }
        try {
            this._schedStorage.deleteMeasurements(aeids.keySet());
        }
        catch (AgentStorageException exc) {
            _log.error((Object)("Failed to delete from measurement storage: " + (Object)((Object)exc)), (Throwable)exc);
        }
        if (debug) {
            watch.markTimeEnd("deleteMeasurements");
        }
        if (debug) {
            watch.markTimeBegin("updateSRN");
        }
        for (ScheduleMeasurements_args arg : args) {
            int numMeasurements = arg.getNumMeasurements();
            SRN srn = arg.getSRN();
            AppdefEntityID aeid = srn.getEntity();
            for (int i = 0; i < numMeasurements; ++i) {
                ScheduleMeasurements_metric metric = arg.getMeasurement(i);
                ScheduledMeasurement sMetric = new ScheduledMeasurement(metric.getDSN(), metric.getInterval(), metric.getDerivedID(), metric.getDSNID(), aeid, metric.getCategory(), metric.getUnits());
                metrics.add(sMetric);
            }
            try {
                this._schedStorage.updateSRN(srn);
            }
            catch (AgentStorageException e) {
                _log.error((Object)("Unable to update SRN in storage: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        if (debug) {
            watch.markTimeEnd("updateSRN");
        }
        if (debug) {
            watch.markTimeBegin("storeMeasurements");
        }
        try {
            this._schedStorage.storeMeasurements(metrics);
        }
        catch (AgentStorageException exc) {
            _log.error((Object)("Failed to store measurements: " + (Object)((Object)exc)), (Throwable)exc);
        }
        if (debug) {
            watch.markTimeEnd("storeMeasurements");
        }
        if (debug) {
            watch.markTimeBegin("scheduleMeasurement");
        }
        ListIterator metricsListIterator = metrics.listIterator(metrics.size());
        while (metricsListIterator.hasPrevious()) {
            this._scheduleObject.scheduleMeasurement((ScheduledMeasurement)metricsListIterator.previous());
        }
        if (debug) {
            watch.markTimeEnd("scheduleMeasurement");
        }
        if (debug) {
            _log.debug((Object)("scheduled " + metrics.size() + " measurements, " + watch));
        }
    }

    void scheduleMeasurement(ScheduledMeasurement m) {
        this._scheduleObject.scheduleMeasurement(m);
    }

    public void setProperties(SetProperties_args args) throws AgentRemoteException {
        PropertyPair pp;
        int i;
        int nProps = args.getNumProperties();
        Vector<PropertyPair> tmpVec = new Vector<PropertyPair>();
        for (i = 0; i < nProps; ++i) {
            pp = args.getProperty(i);
            if (this._validProps.get(pp.getName()) == null) {
                throw new AgentRemoteException("Unknown measurement property name, '" + pp.getName() + "'");
            }
            tmpVec.add(pp);
        }
        for (i = 0; i < nProps; ++i) {
            pp = (PropertyPair)tmpVec.get(i);
            this._storage.setValue(pp.getName(), pp.getValue());
        }
    }

    public void unscheduleMeasurementsById(UnscheduleMeasurementsById_args args) throws AgentRemoteException {
        int resourceInternalId = args.getResourceInternalId();
        _log.debug((Object)("Processing UnscheduleMeasurementsById command for resource id " + resourceInternalId));
        boolean mearuementsFound = false;
        for (int resourceType : resourcesType) {
            AppdefEntityID id = new AppdefEntityID(resourceType, resourceInternalId);
            if (!this._scheduleObject.isMeasurementsScheduledForResource(id)) continue;
            _log.debug((Object)("Unscheduling measurements for resource " + resourceType + ":" + resourceInternalId));
            this.deleteMeasurements(id);
            mearuementsFound = true;
        }
        if (!mearuementsFound) {
            _log.debug((Object)("No measurements were found to unschedule for resource id " + resourceInternalId));
        }
    }

    public void unscheduleMeasurements(UnscheduleMeasurements_args args) throws AgentRemoteException {
        int nEnts = args.getNumEntities();
        _log.debug((Object)("Received unschedule request for " + nEnts + " resources"));
        for (int i = 0; i < nEnts; ++i) {
            AppdefEntityID ent = args.getEntity(i);
            this.deleteMeasurements(ent);
        }
    }

    private void deleteMeasurements(AppdefEntityID ent) throws AgentRemoteException {
        UnscheduledItemException resExc = null;
        AppdefEntityID failedEnt = null;
        _log.debug((Object)("Deleting metrics for " + ent));
        try {
            try {
                this.unscheduleMeasurements(ent);
                this._schedStorage.removeSRN(ent);
            }
            catch (UnscheduledItemException exc) {
                resExc = exc;
                failedEnt = ent;
            }
            if (resExc == null) {
                this._schedStorage.deleteMeasurements(Collections.singletonMap(ent, null).keySet());
            }
        }
        catch (AgentStorageException exc) {
            _log.error((Object)"Failed to delete measurement from storage");
        }
        if (resExc != null) {
            throw new AgentRemoteException("Failed to unschedule metrics for entity " + failedEnt + ": " + resExc.getMessage());
        }
    }

    private void unscheduleMeasurements(AppdefEntityID id) throws UnscheduledItemException {
        this._scheduleObject.unscheduleMeasurements(id);
    }

    public void scheduleTopn(ScheduleTopn_args args) throws AgentRemoteException {
        this._topNScheduler.scheduleTopN(args);
    }

    public void unscheduleTopn() throws AgentRemoteException {
        this._topNScheduler.unscheduleTopN();
    }

    public void shutdownGracefully() {
        this._scheduler.shutdown(true);
        while (this._scheduler.isAlive()) {
            try {
                _log.info((Object)"Waiting for the scheduler to finish proccessing the queue...");
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class Scheduler
    extends Thread {
        final AtomicBoolean shutdown;
        boolean isGracefully;

        private Scheduler() {
            super("MeasurementSchedulerThread");
            this.shutdown = new AtomicBoolean(false);
            this.isGracefully = false;
            this.setDaemon(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown.get() || this.isGracefully && !MeasurementCommandsService.this.argQueue.isEmpty()) {
                    try {
                        ArrayList list = new ArrayList();
                        MeasurementCommandsService.this.argQueue.drainTo(list);
                        if (!list.isEmpty()) {
                            _log.info((Object)("Going to schedule measurements for " + list.size() + " resources."));
                            MeasurementCommandsService.this.scheduleMeasurements(list);
                        }
                        if (this.shutdown.get()) continue;
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        _log.debug((Object)e, (Throwable)e);
                    }
                }
                _log.info((Object)"Scheduler has exit from the run loop.");
                return;
            }
            catch (Throwable t) {
                _log.error((Object)t, t);
            }
        }

        private void shutdown(boolean isGracefully) {
            this.shutdown.set(true);
            this.isGracefully = isGracefully;
        }
    }
}

