/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.livedata.agent.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.util.encoding.Base64;

public class LiveData_result
extends AgentRemoteValue {
    private static final Log _log = LogFactory.getLog(LiveData_result.class);
    private static final String PARAM_RESULT = "result";
    private static final String PARAM_NUM = "num";
    private static final String PARAM_CHUNK = "chunk.";
    private static final int CHUNK_MAX = 65535;

    @Override
    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public LiveData_result() {
    }

    public LiveData_result(AgentRemoteValue val) throws AgentRemoteException {
        String res = val.getValue(PARAM_RESULT);
        String num = val.getValue(PARAM_NUM);
        if (num != null) {
            int numChunks = Integer.parseInt(num);
            for (int i = 0; i < numChunks; ++i) {
                String key = PARAM_CHUNK + i;
                super.setValue(key, val.getValue(key));
            }
            super.setValue(PARAM_NUM, String.valueOf(num));
        } else {
            super.setValue(PARAM_RESULT, res);
        }
    }

    public void setResult(String result) throws IOException {
        String compressed = this.compress(result);
        _log.debug((Object)("Compressed " + result.length() + " bytes to " + compressed.length() + " bytes."));
        int num = 0;
        while (num * 65535 < compressed.length()) {
            int start = num * 65535;
            int end = start + 65535 > compressed.length() ? compressed.length() : start + 65535;
            String chunk = compressed.substring(start, end);
            super.setValue(PARAM_CHUNK + num, chunk);
            ++num;
        }
        super.setValue(PARAM_NUM, String.valueOf(num));
    }

    public String getResult() throws IOException, DataFormatException {
        String compressed = super.getValue(PARAM_RESULT);
        if (compressed == null) {
            StringBuffer result = new StringBuffer();
            int num = Integer.parseInt(super.getValue(PARAM_NUM));
            for (int i = 0; i < num; ++i) {
                String key = PARAM_CHUNK + i;
                result.append(super.getValue(key));
            }
            compressed = result.toString();
        }
        _log.debug((Object)("Decompressing " + compressed.length() + " bytes"));
        return this.decompress(compressed);
    }

    private String compress(String s) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setInput(s.getBytes("UTF-8"));
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        bos.close();
        byte[] compressedData = bos.toByteArray();
        return Base64.encode((byte[])compressedData);
    }

    private String decompress(String s) throws IOException, DataFormatException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(Base64.decode((String)s));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buf);
            bos.write(buf, 0, count);
        }
        bos.close();
        byte[] decompressedData = bos.toByteArray();
        return new String(decompressedData, 0, decompressedData.length, "UTF-8");
    }
}

