/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hyperic.hq.plugin.system.ProcessReport;

public class TopReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long createTime;
    private String upTime;
    private String procStat;
    private String cpu;
    private String mem;
    private String swap;
    private Set<ProcessReport> processes = new HashSet<ProcessReport>();

    public void filterTopProcesses(int topNumber) {
        if (this.processes.size() <= topNumber) {
            return;
        }
        ArrayList<ProcessReport> processesList = new ArrayList<ProcessReport>(this.processes);
        this.processes.clear();
        this.sortProcessesByCpu(processesList);
        if (1 == topNumber) {
            this.processes.add((ProcessReport)processesList.get(0));
        } else {
            this.processes.addAll(processesList.subList(0, topNumber - 1));
        }
        this.sortProcessesByMemory(processesList);
        if (1 == topNumber) {
            this.processes.add((ProcessReport)processesList.get(0));
        } else {
            this.processes.addAll(processesList.subList(0, topNumber - 1));
        }
        this.sortProcessesByDiskIOBytes(processesList);
        if (1 == topNumber) {
            this.processes.add((ProcessReport)processesList.get(0));
        } else {
            this.processes.addAll(processesList.subList(0, topNumber - 1));
        }
    }

    private void sortProcessesByDiskIOBytes(List<ProcessReport> processesList) {
        Collections.sort(processesList, new Comparator<ProcessReport>(){

            @Override
            public int compare(ProcessReport first, ProcessReport second) {
                long secondIO;
                long firstIO = first.getTotalDiskBytes();
                return firstIO == (secondIO = Long.valueOf(second.getTotalDiskBytes()).longValue()) ? 0 : (firstIO > secondIO ? -1 : 1);
            }
        });
    }

    private void sortProcessesByMemory(List<ProcessReport> processesList) {
        Collections.sort(processesList, new Comparator<ProcessReport>(){

            @Override
            public int compare(ProcessReport first, ProcessReport second) {
                double firstMem = -1.0;
                double secondMem = -1.0;
                if (first.getMemPerc().contains("%")) {
                    firstMem = Double.valueOf(first.getMemPerc().replace("%", "").replace(",", ".").trim());
                }
                if (second.getMemPerc().contains("%")) {
                    secondMem = Double.valueOf(second.getMemPerc().replace("%", "").replace(",", ".").trim());
                }
                return Double.compare(secondMem, firstMem);
            }
        });
    }

    private void sortProcessesByCpu(List<ProcessReport> processesList) {
        Collections.sort(processesList, new Comparator<ProcessReport>(){

            @Override
            public int compare(ProcessReport first, ProcessReport second) {
                double firstCpu = -1.0;
                double secondCpu = -1.0;
                if (first.getCpuPerc().contains("%")) {
                    firstCpu = Double.valueOf(first.getCpuPerc().replace("%", "").replace(",", ".").trim());
                }
                if (second.getCpuPerc().contains("%")) {
                    secondCpu = Double.valueOf(second.getCpuPerc().replace("%", "").replace(",", ".").trim());
                }
                return Double.compare(secondCpu, firstCpu);
            }
        });
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long creatTime) {
        this.createTime = creatTime;
    }

    public String getUpTime() {
        return this.upTime;
    }

    public void setUpTime(String upTime) {
        this.upTime = upTime;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getMem() {
        return this.mem;
    }

    public void setMem(String mem) {
        this.mem = mem;
    }

    public String getSwap() {
        return this.swap;
    }

    public void setSwap(String swap) {
        this.swap = swap;
    }

    public void setProcStat(String procStat) {
        this.procStat = procStat;
    }

    public String getProcStat() {
        return this.procStat;
    }

    public List<ProcessReport> getProcessesSorted(TOPN_SORT_TYPE type) {
        ArrayList<ProcessReport> processesList = new ArrayList<ProcessReport>(this.processes);
        switch (type) {
            case CPU: {
                this.sortProcessesByCpu(processesList);
                break;
            }
            case MEM: {
                this.sortProcessesByMemory(processesList);
                break;
            }
            case DISK_IO: {
                this.sortProcessesByDiskIOBytes(processesList);
                break;
            }
        }
        return processesList;
    }

    public Set<ProcessReport> getProcesses() {
        return this.processes;
    }

    public void setProcesses(Set<ProcessReport> processes) {
        this.processes = processes;
    }

    public void addProcess(ProcessReport process) {
        this.processes.add(process);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.createTime = in.readLong();
        this.upTime = in.readUTF();
        this.cpu = in.readUTF();
        this.mem = in.readUTF();
        this.swap = in.readUTF();
        this.procStat = in.readUTF();
        this.processes = (Set)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.createTime);
        out.writeUTF(this.upTime);
        out.writeUTF(this.cpu);
        out.writeUTF(this.mem);
        out.writeUTF(this.swap);
        out.writeUTF(this.procStat);
        out.writeObject(this.processes);
    }

    public byte[] toSerializedForm() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(outputStream);
        objStream.writeObject(this);
        objStream.close();
        return outputStream.toByteArray();
    }

    public static final TopReport fromSerializedForm(byte[] data, int startPos, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data, startPos, length);
        ObjectInputStream objStream = new ObjectInputStream(inStream);
        return (TopReport)objStream.readObject();
    }

    public static final TopReport fromSerializedForm(byte[] data) throws IOException, ClassNotFoundException {
        return TopReport.fromSerializedForm(data, 0, data.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TopReport\n").append("------------------------------\n").append("createTime=").append(this.createTime).append("\n").append("upTime=").append(this.upTime).append("\n").append("cpu=").append(this.cpu).append("\n").append("mem=").append(this.mem).append("\n").append("swap=").append(this.swap).append("\n\n").append("processes\n").append("------------------------------\n");
        for (ProcessReport process : this.processes) {
            sb.append(process.toString()).append("\n");
        }
        return sb.toString();
    }

    public static enum TOPN_SORT_TYPE {
        CPU,
        MEM,
        DISK_IO;

    }
}

