/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hyperic.tools.db.Column;
import org.hyperic.tools.db.Data;
import org.hyperic.tools.db.DataSet;
import org.hyperic.tools.db.Index;
import org.hyperic.tools.db.Table;
import org.hyperic.tools.db.TypeMap;
import org.hyperic.tools.db.View;
import org.hyperic.util.StrongCollection;
import org.hyperic.util.jdbc.JDBC;
import org.hyperic.util.xmlparser.XmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBSetup {
    private static final String COPYRIGHT = "DBSetup, Copyright (C) 2005, Hyperic, Inc. All Rights Reserved.";
    private boolean m_bQuiet;
    private boolean m_bNoninteractive;
    private boolean m_bVerbose;
    private String m_logFileName = null;
    private boolean m_logAppend = false;
    private FileWriter m_log = null;
    public static boolean m_bDMLonly = false;
    private String m_typeMapFile = null;
    private InputStream m_typeMapStream = null;
    private int m_lCreatedIndexes;
    private int m_lCreatedTables;
    private int m_lCreatedViews;
    private int m_lFailedIndexes;
    private int m_lFailedTables;
    private int m_lFailedViews;
    private Connection m_conn = null;

    public DBSetup() {
    }

    public DBSetup(boolean quiet) {
        this.setQuiet(quiet);
    }

    public DBSetup(boolean quiet, boolean verbose) {
        if (quiet && verbose) {
            verbose = false;
        }
        this.setQuiet(quiet);
        this.setVerbose(verbose);
    }

    public DBSetup(boolean quiet, boolean verbose, boolean nonInteractive, String logFileName, boolean append, boolean noexec) {
        this(quiet, verbose);
        this.m_bNoninteractive = nonInteractive;
        this.m_logFileName = logFileName;
        this.m_logAppend = append;
    }

    public void create(String file, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        try {
            File f;
            this.m_conn = this.connect(database, username, password);
            Document doc = this.newDocument();
            Element elemRoot = doc.createElement("Covalent.DBSetup");
            elemRoot.setAttribute("name", file);
            elemRoot.setAttribute("notice", COPYRIGHT);
            doc.appendChild(elemRoot);
            for (Table tab : Table.getTables(this, username)) {
                Element elemChild;
                if (!this.isQuiet()) {
                    System.out.println("\nFound Table : " + tab.getName());
                }
                Element elemTab = doc.createElement("table");
                elemTab.setAttribute("name", tab.getName());
                elemRoot.appendChild(elemTab);
                for (Column col : tab.getColumns()) {
                    if (!this.isQuiet()) {
                        System.out.println("Found Column: " + col.getName());
                    }
                    elemChild = doc.createElement("column");
                    elemChild.setAttribute("name", col.getName());
                    elemChild.setAttribute("type", col.getType());
                    elemChild.setAttribute("size", String.valueOf(col.getSize()));
                    if (col.isRequired()) {
                        elemChild.setAttribute("required", String.valueOf(col.isRequired()));
                    }
                    elemTab.appendChild(elemChild);
                }
                DataSet dataset = tab.getDataSet();
                while (dataset.next()) {
                    elemChild = doc.createElement("data");
                    int iCols = tab.getColumns().size();
                    for (int i = 0; i < iCols; ++i) {
                        Data data = dataset.getData(i);
                        elemChild.setAttribute(data.getColumnName(), data.getValue());
                    }
                    elemTab.appendChild(elemChild);
                }
                ++this.m_lCreatedTables;
            }
            boolean bWrite = true;
            if (!this.isQuiet() && (f = new File(file)).exists()) {
                System.out.print("\nThe file " + file + " already exist. Do you want to overwrite this file? (Y/N): ");
                char ch = (char)System.in.read();
                if (Character.toUpperCase(ch) != 'Y') {
                    System.out.println("Aborted.");
                    bWrite = false;
                }
            }
            if (bWrite) {
                this.writeDocument(doc, file);
            }
            if (!this.isQuiet()) {
                DecimalFormat fmt = new DecimalFormat("#,###");
                System.out.println();
                System.out.println(fmt.format(this.m_lCreatedViews) + " views validated.");
                System.out.println(fmt.format(this.m_lFailedViews) + " views failed to validate.");
                System.out.println(fmt.format(this.m_lCreatedTables) + " tables validated.");
                System.out.println(fmt.format(this.m_lFailedTables) + " tables failed to validate.");
                System.out.println(fmt.format(this.m_lCreatedIndexes) + " indexes validated.");
                System.out.println(fmt.format(this.m_lFailedIndexes) + " indexes failed to validate.");
            }
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (this.m_conn != null) {
                    this.m_conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public Document newDocument() throws SAXException {
        Document docResult = null;
        try {
            DocumentBuilderFactory factory = XmlParser.createDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler());
            docResult = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return docResult;
    }

    protected static Node copyNode(Document target, Node source, boolean deep) {
        Node nodeNew;
        String strNodeName = source.getNodeName();
        String strNodeValue = source.getNodeValue();
        switch (source.getNodeType()) {
            case 1: {
                Element elem = target.createElement(strNodeName);
                nodeNew = elem;
                NamedNodeMap map = source.getAttributes();
                for (int iMap = 0; iMap < map.getLength(); ++iMap) {
                    Node attr = map.item(iMap);
                    elem.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
                break;
            }
            case 8: {
                nodeNew = target.createComment(strNodeName);
                break;
            }
            case 3: {
                nodeNew = target.createTextNode(strNodeName);
                break;
            }
            default: {
                nodeNew = null;
            }
        }
        nodeNew.setNodeValue(strNodeValue);
        if (deep && nodeNew != null) {
            DBSetup.importChildNodes(nodeNew, source, deep);
        }
        return nodeNew;
    }

    protected static void importNodeAfter(Node after, Node source, boolean deep) {
        Node nodeNew = DBSetup.copyNode(after.getOwnerDocument(), source, deep);
        Node nodeNext = after.getNextSibling();
        if (nodeNext != null) {
            after.getParentNode().insertBefore(nodeNew, after);
        } else {
            after.getParentNode().appendChild(nodeNew);
        }
    }

    protected static void importChildNodes(Node parent, Node source, boolean deep) {
        NodeList listChildren = source.getChildNodes();
        for (int i = 0; i < listChildren.getLength(); ++i) {
            parent.appendChild(DBSetup.copyNode(parent.getOwnerDocument(), listChildren.item(i), deep));
        }
    }

    public Document readDocument(String file) throws IOException, SAXException {
        Document docResult = this.readDocument(file, null);
        return docResult;
    }

    public Document readDocument(InputStream is) throws IOException, SAXException {
        Document docResult = this.readDocument(is, null);
        return docResult;
    }

    public Document readDocument(Object source, Node after) throws IOException, SAXException {
        Node docResult = null;
        try {
            DocumentBuilderFactory factory = XmlParser.createDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler());
            File f = null;
            if (source instanceof String) {
                f = new File((String)source);
                docResult = builder.parse(f);
            } else if (source instanceof InputStream) {
                docResult = builder.parse((InputStream)source);
            }
            Node nodeRoot = docResult.getFirstChild();
            if (!nodeRoot.getNodeName().equalsIgnoreCase("Covalent.DBSetup")) {
                if (source instanceof String) {
                    throw new IOException(source.toString() + " is not a DBSetup XML file.");
                }
                throw new IOException("Source is not a DBSetup XML file.");
            }
            NodeList listNodes = nodeRoot.getChildNodes();
            for (int iNode = 0; iNode < listNodes.getLength(); ++iNode) {
                Node node = listNodes.item(iNode);
                if (node.getNodeName().equalsIgnoreCase("include")) {
                    NamedNodeMap map = node.getAttributes();
                    for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                        Node nodeMap = map.item(iAttr);
                        if (!nodeMap.getNodeName().equalsIgnoreCase("file")) continue;
                        File fileInclude = new File(nodeMap.getNodeValue());
                        if (!fileInclude.isAbsolute()) {
                            if (!(source instanceof String)) {
                                throw new IOException("Cannot resolve paths relative to a stream.");
                            }
                            String strPath = f.getAbsolutePath();
                            int iIndex = strPath.lastIndexOf(File.separatorChar);
                            strPath = strPath.substring(0, iIndex);
                            fileInclude = new File(strPath + File.separatorChar + fileInclude.getPath());
                        }
                        this.readDocument(fileInclude.getAbsolutePath(), node);
                        nodeRoot.removeChild(node);
                    }
                    continue;
                }
                if (after == null) continue;
                DBSetup.importNodeAfter(after, node, true);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return docResult;
    }

    public void writeDocument(Document doc, String file) throws IOException, SAXException {
        try {
            TransformerFactory factory = XmlParser.createTransformerFactory();
            Transformer trans = factory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource src = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(file));
            trans.transform(src, result);
        }
        catch (TransformerException e) {
            throw new SAXException(e);
        }
    }

    public boolean setup(String file, String database) throws ClassNotFoundException, IOException, SQLException {
        return this.doSetup(file, database, null, null);
    }

    public boolean setup(String file, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        return this.doSetup(file, database, username, password);
    }

    public boolean setup(String file, String database, String username, String password, String table, boolean doDelete) throws ClassNotFoundException, IOException, SQLException {
        return this.doSetup(file, database, username, password, table, doDelete);
    }

    public boolean setup(InputStream is, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        return this.doSetup(is, database, username, password);
    }

    protected boolean doSetup(Object source, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        return this.doSetup(source, database, username, password, null, false);
    }

    protected boolean doSetup(Object source, String database, String username, String password, String table, boolean doDelete) throws ClassNotFoundException, IOException, SQLException {
        try {
            Document doc = null;
            if (source instanceof String) {
                doc = this.readDocument((String)source);
            } else if (source instanceof InputStream) {
                doc = this.readDocument((InputStream)source);
            }
            JDBC.loadDriver((String)database);
            if (!this.isQuiet()) {
                System.out.println("Successfully loaded the database driver.");
            }
            this.m_conn = this.connect(database, username, password);
            if (!this.isQuiet()) {
                System.out.println("Successfully connected to the database.");
            }
            Collection collTypeMaps = null;
            collTypeMaps = this.m_typeMapFile != null ? TypeMap.readTypeMaps(this.readDocument(this.m_typeMapFile).getFirstChild()) : (this.m_typeMapStream != null ? TypeMap.readTypeMaps(this.readDocument(this.m_typeMapStream).getFirstChild()) : TypeMap.readTypeMaps(doc.getFirstChild()));
            Node rootNode = doc.getFirstChild();
            Iterator<Table> iterTab = Table.getTables(rootNode, JDBC.toType((String)database), this).iterator();
            if (this.m_logFileName != null) {
                this.m_log = new FileWriter(this.m_logFileName, this.m_logAppend);
            }
            while (iterTab.hasNext()) {
                Table tab = iterTab.next();
                if (table != null) {
                    if (!table.equals(tab.getName())) continue;
                    if (doDelete) {
                        tab.clear();
                    }
                }
                if (this.isVerbose()) {
                    System.out.println("Processing Table: " + tab.getName());
                }
                if (!m_bDMLonly) {
                    try {
                        if (tab.getColumns().size() > 0) {
                            tab.create(collTypeMaps);
                            if (!this.isQuiet()) {
                                System.out.println("Created Table: " + tab.getName());
                            }
                            ++this.m_lCreatedTables;
                        }
                    }
                    catch (SQLException e) {
                        if (!this.isQuiet()) {
                            System.out.println("Error: Cannot create table " + tab.getName());
                            JDBC.printSQLException((SQLException)e);
                        }
                        ++this.m_lFailedTables;
                    }
                    for (Index idx : tab.getIndexes()) {
                        try {
                            idx.create();
                            if (!this.isQuiet()) {
                                System.out.println("Created Index: " + idx.getName() + " for Table '" + idx.getTable().getName() + '\'');
                            }
                            ++this.m_lCreatedIndexes;
                        }
                        catch (SQLException e) {
                            if (!this.isQuiet()) {
                                System.out.println("Error: Cannot create index " + idx.getName());
                                JDBC.printSQLException((SQLException)e);
                            }
                            ++this.m_lFailedIndexes;
                        }
                    }
                }
                DataSet dataset = tab.getDataSet();
                try {
                    int iRowCnt = dataset.create();
                    if (this.isQuiet()) continue;
                    System.out.println("Created " + iRowCnt + " Row(s).");
                }
                catch (SQLException e) {
                    if (this.isQuiet()) continue;
                    System.out.println("Error: Cannot create Row.");
                    JDBC.printSQLException((SQLException)e);
                    if (!this.isVerbose()) continue;
                    e.printStackTrace();
                }
            }
            Iterator iterView = View.getViews(rootNode, JDBC.toType((String)database), this).iterator();
            if (this.m_logFileName != null) {
                this.m_log = new FileWriter(this.m_logFileName, this.m_logAppend);
            }
            while (iterView.hasNext()) {
                View view = (View)iterView.next();
                if (this.isVerbose()) {
                    System.out.println("Processing view: " + view.getName());
                }
                if (m_bDMLonly) continue;
                try {
                    view.create(collTypeMaps);
                    if (!this.isQuiet()) {
                        System.out.println("Created View: " + view.getName());
                    }
                    ++this.m_lCreatedViews;
                }
                catch (SQLException e) {
                    if (this.isQuiet()) continue;
                    System.out.println("Error: Cannot create View.");
                    JDBC.printSQLException((SQLException)e);
                    if (!this.isVerbose()) continue;
                    e.printStackTrace();
                }
            }
            if (!this.isQuiet()) {
                DecimalFormat fmt = new DecimalFormat("#,###");
                System.out.println();
                System.out.println(fmt.format(this.m_lCreatedTables) + " tables created succesfully.");
                System.out.println(fmt.format(this.m_lCreatedViews) + " views created succesfully.");
                System.out.println(fmt.format(this.m_lCreatedIndexes) + " indexes created successfully.");
                System.out.println(fmt.format(this.m_lFailedTables) + " tables failed to create.");
                System.out.println(fmt.format(this.m_lFailedIndexes) + " indexes failed to create.");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            if (this.m_log != null) {
                try {
                    this.m_log.close();
                }
                catch (Exception e) {}
            }
            try {
                if (this.m_conn != null) {
                    this.m_conn.close();
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }

    public boolean clear(String file, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        return this.clear(file, database, username, password, null);
    }

    public boolean clear(String file, String database, String username, String password, String table) throws ClassNotFoundException, IOException, SQLException {
        boolean bProceed = false;
        Statement stmt = null;
        try {
            Document doc = this.readDocument(file);
            this.m_conn = this.connect(database, username, password);
            stmt = this.m_conn.createStatement();
            if (!this.isQuiet() && !this.isNoninteractive()) {
                System.out.print("DBSetup will permanently delete data. DO YOU WANT TO PROCEED? (Y/N): ");
                if (Character.toUpperCase((char)System.in.read()) == 'Y') {
                    System.out.println();
                    bProceed = true;
                } else {
                    System.out.println("Aborted.");
                }
            } else {
                bProceed = true;
            }
            if (bProceed) {
                StrongCollection tables = (StrongCollection)Table.getTables(doc.getFirstChild(), JDBC.toType((String)database), this);
                tables.reverse();
                for (Table tab : tables) {
                    if (table != null && tab.getName().compareToIgnoreCase(table) != 0) continue;
                    try {
                        tab.clear();
                        if (!this.isQuiet()) {
                            System.out.println("Clear Table: " + tab.getName());
                        }
                        ++this.m_lCreatedTables;
                    }
                    catch (SQLException e) {
                        if (!this.isQuiet()) {
                            System.out.println("Error: Cannot clear table " + tab.getName());
                            JDBC.printSQLException((SQLException)e);
                        }
                        ++this.m_lFailedTables;
                    }
                }
            }
            if (!this.isQuiet()) {
                DecimalFormat fmt = new DecimalFormat("#,###");
                System.out.println();
                System.out.println(fmt.format(this.m_lCreatedTables) + " tables cleared succesfully.");
                System.out.println(fmt.format(this.m_lFailedTables) + " tables failed to clear.");
            }
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.m_conn != null) {
                    this.m_conn.close();
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }

    public boolean uninstall(String file, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        return this.doUninstall(file, database, username, password);
    }

    public boolean uninstall(InputStream is, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        return this.doUninstall(is, database, username, password);
    }

    protected boolean doUninstall(Object source, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        boolean bProceed = false;
        Statement stmt = null;
        try {
            if (this.m_logFileName != null) {
                this.m_log = new FileWriter(this.m_logFileName, this.m_logAppend);
            }
            Document doc = null;
            if (source instanceof String) {
                doc = this.readDocument((String)source);
            } else if (source instanceof InputStream) {
                doc = this.readDocument((InputStream)source);
            }
            this.m_conn = this.connect(database, username, password);
            stmt = this.m_conn.createStatement();
            if (!this.isQuiet() && !this.isNoninteractive()) {
                System.out.print("DBSetup will permanently drop tables and data. DO YOU WANT TO PROCEED? (Y/N): ");
                if (Character.toUpperCase((char)System.in.read()) == 'Y') {
                    System.out.println();
                    bProceed = true;
                } else {
                    System.out.println("Aborted.");
                }
            } else {
                bProceed = true;
            }
            if (bProceed) {
                StrongCollection views = (StrongCollection)View.getViews(doc.getFirstChild(), JDBC.toType((String)database), this);
                for (View view : views) {
                    try {
                        view.drop();
                        if (!this.isQuiet()) {
                            System.out.println("Dropped View: " + view.getName());
                        }
                        ++this.m_lCreatedViews;
                    }
                    catch (SQLException e) {
                        if (!this.isQuiet()) {
                            System.out.println("Error: Cannot drop view " + view.getName());
                            JDBC.printSQLException((SQLException)e);
                        }
                        ++this.m_lFailedViews;
                    }
                }
                View.uninstallCleanup(this);
                StrongCollection tables = (StrongCollection)Table.getTables(doc.getFirstChild(), JDBC.toType((String)database), this);
                tables.reverse();
                for (Table tab : tables) {
                    try {
                        tab.drop();
                        if (!this.isQuiet()) {
                            System.out.println("Dropped Table: " + tab.getName());
                        }
                        ++this.m_lCreatedTables;
                    }
                    catch (SQLException e) {
                        if (!this.isQuiet()) {
                            System.out.println("Error: Cannot drop table " + tab.getName());
                            JDBC.printSQLException((SQLException)e);
                        }
                        ++this.m_lFailedTables;
                    }
                }
                Table.uninstallCleanup(this);
            }
            if (!this.isQuiet()) {
                DecimalFormat fmt = new DecimalFormat("#,###");
                System.out.println();
                System.out.println(fmt.format(this.m_lCreatedViews) + " views dropped succesfully.");
                System.out.println(fmt.format(this.m_lFailedViews) + " views failed to drop.");
                System.out.println(fmt.format(this.m_lCreatedTables) + " tables dropped succesfully.");
                System.out.println(fmt.format(this.m_lFailedTables) + " tables failed to drop.");
            }
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (this.m_log != null) {
                try {
                    this.m_log.close();
                }
                catch (Exception e) {}
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.m_conn != null) {
                    this.m_conn.close();
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }

    public boolean validate(String file, String database, String username, String password) throws ClassNotFoundException, IOException, SQLException {
        try {
            Document doc = this.readDocument(file);
            this.m_conn = this.connect(database, username, password);
            DatabaseMetaData meta = this.m_conn.getMetaData();
            for (Table tab : Table.getTables(doc.getFirstChild(), JDBC.toType((String)database), this)) {
                try {
                    ResultSet set = meta.getTables(null, null, tab.getName(), null);
                    if (!set.next()) continue;
                    if (!this.isQuiet()) {
                        System.out.println("Found Table : " + tab.getName());
                    }
                    for (Column col : tab.getColumns()) {
                        set = meta.getColumns(null, null, tab.getName(), col.getName());
                        if (!set.next() || this.isQuiet()) continue;
                        System.out.println("Found Column: " + col.getName());
                    }
                    ++this.m_lCreatedTables;
                }
                catch (SQLException e) {
                    if (!this.isQuiet()) {
                        System.out.println("Error: Cannot find table " + tab.getName());
                        JDBC.printSQLException((SQLException)e);
                    }
                    ++this.m_lFailedTables;
                }
            }
            if (!this.isQuiet()) {
                DecimalFormat fmt = new DecimalFormat("#,###");
                System.out.println();
                System.out.println(fmt.format(this.m_lCreatedTables) + " tables validated.");
                System.out.println(fmt.format(this.m_lFailedTables) + " tables failed to validate.");
                System.out.println(fmt.format(this.m_lCreatedIndexes) + " indexes validated.");
                System.out.println(fmt.format(this.m_lFailedIndexes) + " indexes failed to validate.");
            }
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (this.m_conn != null) {
                    this.m_conn.close();
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }

    public boolean isQuiet() {
        return this.m_bQuiet;
    }

    public void setQuiet(boolean quiet) {
        this.m_bQuiet = quiet;
    }

    public boolean isNoninteractive() {
        return this.m_bNoninteractive;
    }

    public void setNoninteractive(boolean noninteractive) {
        this.m_bNoninteractive = noninteractive;
    }

    public boolean isVerbose() {
        return this.m_bVerbose;
    }

    public void setVerbose(boolean quiet) {
        this.m_bVerbose = quiet;
    }

    protected void doSQL(String cmd) throws SQLException {
        this.doSQL(cmd, false);
    }

    protected Statement doSQL(String cmd, boolean bPrepared) throws SQLException {
        boolean committing = this.getConn().getAutoCommit();
        if (committing) {
            this.getConn().setAutoCommit(false);
        }
        Statement stmt = bPrepared ? this.getConn().prepareStatement(cmd) : this.getConn().createStatement();
        if (this.m_bVerbose) {
            System.out.println("Command: " + cmd);
        }
        if (!bPrepared) {
            try {
                stmt.executeUpdate(cmd);
                this.getConn().commit();
            }
            catch (SQLException e) {
                try {
                    this.getConn().rollback();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        this.getConn().setAutoCommit(committing);
        return stmt;
    }

    protected Connection getConn() {
        return this.m_conn;
    }

    public void setTypeMapFile(String tmapFile) {
        this.m_typeMapFile = tmapFile;
    }

    public void setTypeMapStream(InputStream is) {
        this.m_typeMapStream = is;
    }

    private Connection connect(String database, String user, String password) throws ClassNotFoundException, SQLException {
        return this.connect(null, database, user, password);
    }

    private Connection connect(String driver, String database, String user, String password) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        if (driver == null) {
            driver = JDBC.getDriverString((String)database);
        }
        JDBC.loadDriver((String)driver);
        conn = DriverManager.getConnection(database, user, password);
        conn.setAutoCommit(false);
        return conn;
    }

    public void init(boolean verbose, boolean sqlonly) {
    }

    public void logSQL(String sql) {
        if (this.m_log != null) {
            try {
                this.m_log.write(sql + ";\n");
                this.m_log.flush();
            }
            catch (Exception e) {
                System.err.println("DBSetup: ERROR writing to log file: " + e);
            }
        }
    }

    protected int getDbType() {
        int iResult = -1;
        try {
            iResult = JDBC.toType((String)this.getConn().getMetaData().getURL());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return iResult;
    }

    private class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            System.out.println("Fatal Error: " + e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            System.out.println("Error: " + e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println("Warning: " + e);
        }
    }
}

