/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.oro.text.perl.Perl5Util;
import org.hyperic.tools.db.DBSetup;
import org.hyperic.tools.db.Data;

abstract class DataSet {
    private DBSetup m_parent;
    private String m_strTableName;
    private static Perl5Util regexp = new Perl5Util();

    protected DataSet(String tableName, DBSetup dbsetup) {
        this.m_strTableName = tableName;
        this.m_parent = dbsetup;
    }

    protected int create() throws SQLException {
        Statement stmt = null;
        int rowcnt = 0;
        try {
            while (this.next()) {
                if (rowcnt == 0) {
                    String strCmd = this.getCreateCommand();
                    stmt = (PreparedStatement)this.m_parent.doSQL(strCmd, true);
                }
                if (this.setSqlData((PreparedStatement)stmt)) {
                    stmt.executeUpdate();
                    this.m_parent.getConn().commit();
                }
                ++rowcnt;
            }
        }
        catch (SQLException e) {
            try {
                this.m_parent.getConn().rollback();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return rowcnt;
    }

    protected String getCreateCommand() throws SQLException {
        int i;
        int iCols = this.getNumberColumns();
        StringBuffer strCmd = new StringBuffer("INSERT INTO ");
        strCmd.append(this.getTableName());
        strCmd.append(" (");
        for (i = 0; i < iCols; ++i) {
            Data data = this.getData(i);
            if (i > 0) {
                strCmd.append(',');
            }
            strCmd.append(data.getColumnName());
        }
        strCmd.append(") VALUES (");
        for (i = 0; i < iCols; ++i) {
            if (i > 0) {
                strCmd.append(',');
            }
            strCmd.append('?');
        }
        strCmd.append(')');
        return strCmd.toString();
    }

    protected String getUpdateCommand(String strCol) throws SQLException {
        int iCols = this.getNumberColumns();
        StringBuffer strCmd = new StringBuffer("UPDATE ");
        strCmd.append(this.getTableName());
        strCmd.append(" SET ");
        for (int i = 0; i < iCols; ++i) {
            Data data = this.getData(i);
            String colName = data.getColumnName();
            if (colName.equals("CTIME") || colName.equals("ENTRY_TIME")) continue;
            if (i > 0) {
                strCmd.append(',');
            }
            strCmd.append(colName);
            strCmd.append(" = ?");
        }
        strCmd.append(" WHERE ").append(strCol).append(" = ?");
        return strCmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setSqlData(PreparedStatement stmt) throws SQLException {
        String strSelect;
        String strValue;
        Data data;
        int i;
        Statement stmtQuery = null;
        boolean bResult = true;
        ResultSet results = null;
        String cid = "0";
        int iCols = this.getNumberColumns();
        for (i = 0; i < iCols; ++i) {
            data = this.getData(i);
            if (!data.getColumnName().equalsIgnoreCase("CID") && !data.getColumnName().equalsIgnoreCase("ID")) continue;
            String strCol = data.getColumnName();
            strValue = data.getValue();
            strSelect = "SELECT " + strCol + " FROM " + this.getTableName() + " WHERE " + strCol + " = " + strValue;
            try {
                stmtQuery = this.m_parent.getConn().createStatement();
                results = stmtQuery.executeQuery(strSelect);
                if (!results.next()) break;
                bResult = false;
                cid = strValue;
                String strCmd = this.getUpdateCommand(strCol);
                if (stmt != null) {
                    stmt.close();
                }
                stmt = (PreparedStatement)this.m_parent.doSQL(strCmd, true);
                break;
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e2) {}
                }
                if (stmtQuery != null) {
                    try {
                        stmtQuery.close();
                    }
                    catch (SQLException e2) {}
                }
            }
        }
        for (i = 0; i < iCols; ++i) {
            data = this.getData(i);
            String colName = data.getColumnName();
            if (!bResult && (colName.equals("CTIME") || colName.equals("ENTRY_TIME"))) continue;
            strValue = data.getValue();
            if (strValue.length() > 1 && strValue.charAt(0) == '%' && strValue.charAt(1) != '%' && regexp.match("m/^%[A-Z]+\\w+\\.[A-Z]+\\w+:\\d+$/i", strValue)) {
                int iColDelim = strValue.indexOf(46);
                int iDataDelim = strValue.indexOf(58);
                String strTab = strValue.substring(1, iColDelim);
                String strCol = strValue.substring(iColDelim + 1, iDataDelim);
                String strSID = strValue.substring(iDataDelim + 1);
                strSelect = "SELECT " + strCol + " FROM " + strTab + " WHERE " + strCol + " = " + strSID;
                try {
                    stmtQuery = this.m_parent.getConn().createStatement();
                    results = stmtQuery.executeQuery(strSelect);
                    if (results.next()) {
                        strValue = results.getString(1);
                    } else {
                        strValue = null;
                        if (!this.m_parent.isQuiet()) {
                            System.out.println("Error: Cannot find Foreign Key: '" + strSelect + '\'');
                        }
                    }
                }
                finally {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException e2) {}
                    }
                    if (stmtQuery != null) {
                        try {
                            stmtQuery.close();
                        }
                        catch (SQLException e2) {}
                    }
                }
            }
            if (strValue != null) {
                if (strValue.equals("TRUE")) {
                    stmt.setBoolean(i + 1, true);
                    continue;
                }
                if (strValue.equals("FALSE")) {
                    stmt.setBoolean(i + 1, false);
                    continue;
                }
                if (strValue.equals("NOW()")) {
                    stmt.setLong(i + 1, System.currentTimeMillis());
                    continue;
                }
                stmt.setString(i + 1, strValue);
                continue;
            }
            stmt.setNull(i + 1, 4);
        }
        if (!bResult) {
            stmt.setString(iCols + 1, cid);
            try {
                stmt.executeUpdate();
                this.m_parent.getConn().commit();
            }
            catch (SQLException e) {
                try {
                    this.m_parent.getConn().rollback();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        return bResult;
    }

    protected int getNumberColumns() {
        return 0;
    }

    protected String getTableName() {
        return this.m_strTableName;
    }

    protected abstract Data getData(int var1);

    protected abstract boolean next();
}

