/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.hyperic.tools.db.CloudscapeTable;
import org.hyperic.tools.db.Column;
import org.hyperic.tools.db.Constraint;
import org.hyperic.tools.db.DBSetup;
import org.hyperic.tools.db.DataSet;
import org.hyperic.tools.db.Index;
import org.hyperic.tools.db.MySQLTable;
import org.hyperic.tools.db.OracleTable;
import org.hyperic.tools.db.PointbaseTable;
import org.hyperic.tools.db.SqlDataSet;
import org.hyperic.tools.db.XmlDataSet;
import org.hyperic.util.StringList;
import org.hyperic.util.StrongCollection;
import org.hyperic.util.jdbc.JDBC;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Table {
    private DBSetup m_parent;
    private String m_strName;
    private boolean m_indexOrganized = false;
    private boolean m_parallel = false;
    private boolean m_logging = false;
    private boolean m_cache = false;
    private String m_tableSpace;
    private String m_storage;
    private String m_engine;
    private List m_listColumns;
    private Collection m_collIndexes;
    private Collection m_collConstraints;
    private DataSet m_dataset;

    protected Table() {
    }

    protected Table(Node node, int dbtype, DBSetup dbsetup) throws SAXException {
        this.m_parent = dbsetup;
        if (Table.isTable(node)) {
            NamedNodeMap map = node.getAttributes();
            for (int iTab = 0; iTab < map.getLength(); ++iTab) {
                Node nodeMap = map.item(iTab);
                if (nodeMap.getNodeName().equalsIgnoreCase("name")) {
                    this.m_strName = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("index-organized")) {
                    this.m_indexOrganized = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("parallel")) {
                    this.m_parallel = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("logging")) {
                    this.m_logging = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("cache")) {
                    this.m_cache = nodeMap.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("tablespace")) {
                    this.m_tableSpace = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("storage-options")) {
                    this.m_storage = nodeMap.getNodeValue();
                    continue;
                }
                if (nodeMap.getNodeName().equalsIgnoreCase("engine")) {
                    this.m_engine = nodeMap.getNodeValue();
                    continue;
                }
                if (!this.m_parent.isVerbose()) continue;
                System.out.println("Unknown attribute '" + nodeMap.getNodeName() + "' in tag 'table'");
            }
        } else {
            throw new SAXException("node is not a table.");
        }
        this.m_listColumns = Column.getColumns(node, this, dbtype);
        this.m_collIndexes = Index.getIndexes(this, node, dbtype);
        this.m_collConstraints = Constraint.getConstraints(this, node, dbtype);
        this.m_dataset = new XmlDataSet(this, node);
    }

    protected Table(ResultSet set, DatabaseMetaData meta, DBSetup dbsetup) throws SQLException {
        this.m_parent = dbsetup;
        this.m_strName = set.getString(3);
        this.m_listColumns = Column.getColumns(meta, this);
        this.m_dataset = new SqlDataSet(this);
    }

    protected void create(Collection typemaps) throws SQLException {
        Vector collCmds = new Vector();
        this.getCreateCommands(collCmds, typemaps, JDBC.toType((String)this.m_parent.getConn().getMetaData().getURL()));
        for (String strCmd : collCmds) {
            this.m_parent.doSQL(strCmd);
        }
    }

    private void doCmd(List collCmds) throws SQLException {
        for (String strCmd : collCmds) {
            this.m_parent.doSQL(strCmd);
        }
    }

    protected void clear() throws SQLException {
        StringList collCmds = new StringList();
        this.getClearCommands((List)collCmds);
        this.doCmd((List)collCmds);
    }

    protected void drop() throws SQLException {
        StringList collCmds = new StringList();
        this.getDropCommands((List)collCmds);
        this.doCmd((List)collCmds);
    }

    protected List getColumns() {
        return this.m_listColumns;
    }

    protected String getTableSpace() {
        return this.m_tableSpace;
    }

    protected String getStorage() {
        return this.m_storage;
    }

    protected String getEngine() {
        return this.m_engine;
    }

    protected void getCreateCommands(List cmds, Collection typemaps, int dbtype) {
        String strCmd = "CREATE TABLE " + this.getName() + " (";
        Iterator iter = this.getColumns().iterator();
        boolean bFirst = true;
        StringList preCreateCommands = new StringList();
        StringList postCreateCommands = new StringList();
        Column col = null;
        while (iter.hasNext()) {
            if (bFirst) {
                bFirst = false;
            } else {
                strCmd = strCmd + ", ";
            }
            col = (Column)iter.next();
            col.getPreCreateCommands((List)preCreateCommands);
            strCmd = strCmd + col.getCreateCommand(cmds, typemaps, dbtype);
            col.getPostCreateCommands((List)postCreateCommands);
        }
        iter = this.getConstraints().iterator();
        Constraint constraint = null;
        while (iter.hasNext()) {
            constraint = (Constraint)iter.next();
            strCmd = strCmd + constraint.getCreateString();
            constraint.getPostCreateCommands((List)postCreateCommands);
        }
        strCmd = strCmd + ')';
        if (this.m_indexOrganized) {
            strCmd = strCmd + this.getIndexOrganizedSyntax(dbtype);
        }
        if (this.m_tableSpace != null && !this.m_tableSpace.equals("DEFAULT") && !this.getTableSpaceSyntax().equals("")) {
            strCmd = strCmd + this.getTableSpaceSyntax() + this.getTableSpace();
        }
        strCmd = strCmd + this.getStorageClause();
        if (this.m_parallel) {
            strCmd = strCmd + this.getParallelSyntax();
        }
        if (!this.m_logging) {
            strCmd = strCmd + this.getLoggingSyntax();
        }
        if (this.m_cache) {
            strCmd = strCmd + this.getCacheSyntax();
        }
        cmds.addAll(preCreateCommands);
        cmds.add(strCmd);
        cmds.addAll(postCreateCommands);
    }

    public String getStorageClause() {
        if (this.m_storage != null && !this.getStorageSyntax().equals("")) {
            return this.getStorageSyntax() + "(" + this.m_storage + ")";
        }
        return "";
    }

    public String getEngineClause() {
        if (!this.getEngineSyntax().equals("")) {
            return this.getEngineSyntax();
        }
        return "";
    }

    protected String getIndexOrganizedSyntax(int dbtype) {
        return dbtype == 3 ? " ORGANIZATION INDEX" : "";
    }

    protected String getParallelSyntax() {
        return "";
    }

    protected String getLoggingSyntax() {
        return "";
    }

    protected String getCacheSyntax() {
        return "";
    }

    protected String getTableSpaceSyntax() {
        return "";
    }

    protected String getStorageSyntax() {
        return "";
    }

    protected String getEngineSyntax() {
        return "";
    }

    protected DataSet getDataSet() {
        return this.m_dataset;
    }

    protected void getClearCommands(List cmds) {
        String strCmd = "DELETE FROM " + this.getName();
        cmds.add(strCmd);
    }

    protected void getDropCommands(List cmds) {
        String strCmd = "DROP TABLE " + this.getName();
        cmds.add(strCmd);
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            ((Column)iter.next()).getDropCommands(cmds);
        }
    }

    protected Collection getConstraints() {
        return this.m_collConstraints;
    }

    protected Collection getIndexes() {
        return this.m_collIndexes;
    }

    protected String getQueryCommand() {
        String strCmd = "SELECT ";
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            strCmd = strCmd + ((Column)iter.next()).getName();
            if (iter.hasNext()) {
                strCmd = strCmd + ',';
            }
            strCmd = strCmd + ' ';
        }
        strCmd = strCmd + "FROM " + this.getName();
        return strCmd;
    }

    protected String getName() {
        return this.m_strName.toUpperCase();
    }

    protected static Collection<Table> getTables(Node node, int dbtype, DBSetup parent) {
        StrongCollection colResult = new StrongCollection("org.hyperic.tools.db.Table");
        NodeList listTabs = node.getChildNodes();
        String strTmp = node.getNodeName();
        for (int iTab = 0; iTab < listTabs.getLength(); ++iTab) {
            Node nodeTab = listTabs.item(iTab);
            if (!Table.isTable(nodeTab)) continue;
            try {
                switch (dbtype) {
                    case 3: {
                        colResult.add(new OracleTable(nodeTab, dbtype, parent));
                        break;
                    }
                    case 8: {
                        colResult.add(new MySQLTable(nodeTab, dbtype, parent));
                        break;
                    }
                    default: {
                        colResult.add(new Table(nodeTab, dbtype, parent));
                        break;
                    }
                }
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected static Collection<Table> getTables(DBSetup parent, String username) throws SQLException {
        int dbtype = JDBC.toType((String)parent.getConn().getMetaData().getURL());
        switch (dbtype) {
            case 3: {
                return OracleTable.getTables(parent, username);
            }
            case 1: {
                return CloudscapeTable.getTables(parent, username);
            }
        }
        if (username != null) {
            username = username.toUpperCase();
        }
        StrongCollection coll = new StrongCollection("org.hyperic.tools.db.Table");
        DatabaseMetaData meta = parent.getConn().getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet setTabs = meta.getTables(null, username, "%", types);
        while (setTabs.next()) {
            coll.add(new Table(setTabs, meta, parent));
        }
        return coll;
    }

    protected static boolean isTable(Node nodeTable) {
        return nodeTable.getNodeName().equalsIgnoreCase("table");
    }

    protected static void uninstallCleanup(DBSetup parent) throws SQLException {
        int dbtype = JDBC.toType((String)parent.getConn().getMetaData().getURL());
        if (dbtype == PointbaseTable.getClassType()) {
            PointbaseTable.uninstallCleanup(parent.getConn());
        }
    }

    protected DBSetup getDBSetup() {
        return this.m_parent;
    }
}

