/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.ScanMethodConfig;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.bizapp.shared.lather.ScanMethodConfigValue;
import org.hyperic.hq.bizapp.shared.lather.ServerSignatureValue;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class ScanConfigurationCoreValue
extends LatherValue {
    private static final String PROP_NSCANCONFIGS = "nscanConfigs";
    private static final String PROP_SCANCONFIGS = "scanConfigs";
    private static final String PROP_NSERVERSIGS = "nserverSigs";
    private static final String PROP_SERVERSIGS = "serverSigs";
    private static final String PROP_CONFIG = "configResponse";

    public ScanConfigurationCoreValue() {
    }

    public ScanConfigurationCoreValue(ScanConfigurationCore core) throws LatherRemoteException {
        int i;
        ScanMethodConfig[] configs = core.getScanMethodConfigs();
        ServerSignature[] sigs = core.getServerSignatures();
        ConfigResponse configResponse = core.getConfigResponse();
        this.setIntValue(PROP_NSCANCONFIGS, configs.length);
        for (i = 0; i < configs.length; ++i) {
            this.addObjectToList(PROP_SCANCONFIGS, (Object)new ScanMethodConfigValue(configs[i]));
        }
        this.setIntValue(PROP_NSERVERSIGS, sigs.length);
        for (i = 0; i < sigs.length; ++i) {
            this.addObjectToList(PROP_SERVERSIGS, (Object)new ServerSignatureValue(sigs[i]));
        }
        try {
            this.setByteAValue(PROP_CONFIG, configResponse.encode());
        }
        catch (Exception e) {
            throw new LatherRemoteException("Error encoding configuration: " + e.getMessage());
        }
    }

    public ScanConfigurationCore getCore() throws LatherRemoteException {
        ServerSignature[] sigs;
        int i;
        ScanMethodConfig[] configs;
        LatherValue[] lVals;
        ScanConfigurationCore res = new ScanConfigurationCore();
        if (this.getIntValue(PROP_NSCANCONFIGS) != 0) {
            lVals = (LatherValue[])this.getObjectList(PROP_SCANCONFIGS);
            configs = new ScanMethodConfig[lVals.length];
            for (i = 0; i < lVals.length; ++i) {
                ScanMethodConfigValue scVal = (ScanMethodConfigValue)lVals[i];
                configs[i] = new ScanMethodConfig();
                configs[i].setMethodClass(scVal.getMethodClass());
                configs[i].setConfig(scVal.getConfig());
            }
        } else {
            configs = new ScanMethodConfig[]{};
        }
        if (this.getIntValue(PROP_NSERVERSIGS) != 0) {
            lVals = (LatherValue[])this.getObjectList(PROP_SERVERSIGS);
            sigs = new ServerSignature[lVals.length];
            for (i = 0; i < lVals.length; ++i) {
                ServerSignatureValue svVal = (ServerSignatureValue)lVals[i];
                sigs[i] = svVal.getSignature();
            }
        } else {
            sigs = new ServerSignature[]{};
        }
        res.setScanMethodConfigs(configs);
        res.setServerSignatures(sigs);
        res.setConfigResponse(this.getConfig());
        return res;
    }

    private ConfigResponse getConfig() throws LatherRemoteException {
        try {
            return ConfigResponse.decode((byte[])this.getByteAValue(PROP_CONFIG));
        }
        catch (EncodingException e) {
            throw new LatherRemoteException("Error decoding configuration: " + e.getMessage());
        }
    }

    public void validate() throws LatherRemoteException {
        try {
            this.getCore();
        }
        catch (LatherKeyNotFoundException exc) {
            throw new LatherRemoteException(exc.getMessage() + " key not set");
        }
    }
}

