/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class ServerSignatureValue
extends LatherValue {
    private static final String PROP_SERVERTYPENAME = "serverTypeName";
    private static final String PROP_FILEPATTERNS = "filePatterns";
    private static final String PROP_FILEEXPATTERNS = "fileExcludePatterns";
    private static final String PROP_REGPATTERNS = "registryPatterns";

    public ServerSignatureValue() {
    }

    public ServerSignatureValue(ServerSignature sig) {
        int i;
        this.setStringValue(PROP_SERVERTYPENAME, sig.getServerTypeName());
        String[] vals = sig.getFileMatchPatterns();
        for (i = 0; i < vals.length; ++i) {
            this.addStringToList(PROP_FILEPATTERNS, vals[i]);
        }
        vals = sig.getFileExcludePatterns();
        for (i = 0; i < vals.length; ++i) {
            this.addStringToList(PROP_FILEEXPATTERNS, vals[i]);
        }
        vals = sig.getRegistryMatchPatterns();
        for (i = 0; i < vals.length; ++i) {
            this.addStringToList(PROP_REGPATTERNS, vals[i]);
        }
    }

    private String[] getStrings(String prop) {
        try {
            return this.getStringList(prop);
        }
        catch (LatherKeyNotFoundException e) {
            return null;
        }
    }

    public ServerSignature getSignature() {
        ServerSignature res = new ServerSignature();
        res.setServerTypeName(this.getStringValue(PROP_SERVERTYPENAME));
        res.setFileMatchPatterns(this.getStrings(PROP_FILEPATTERNS));
        res.setFileExcludePatterns(this.getStrings(PROP_FILEEXPATTERNS));
        res.setRegistryMatchPatterns(this.getStrings(PROP_REGPATTERNS));
        return res;
    }

    public void validate() throws LatherRemoteException {
        try {
            this.getSignature();
        }
        catch (LatherKeyNotFoundException exc) {
            throw new LatherRemoteException("All values not set");
        }
    }
}

