/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.util.config.ConfigResponse;

public class AutoinventoryPluginManager
extends PluginManager {
    private Map serviceConfigs = new HashMap();
    private Map notes = new HashMap();

    public AutoinventoryPluginManager() {
    }

    public AutoinventoryPluginManager(Properties props) {
        super(props);
    }

    @Override
    public String getName() {
        return "autoinventory";
    }

    public void addServiceConfig(String type, ConfigResponse config) {
        HashMap<String, ConfigResponse> services = (HashMap<String, ConfigResponse>)this.serviceConfigs.get(type);
        String name = config.getValue("resource.name");
        if (services == null) {
            services = new HashMap<String, ConfigResponse>();
            this.serviceConfigs.put(type, services);
        }
        services.put(name, config);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Add service config: " + type + "=" + config));
        }
    }

    public List getServiceConfigs(String type) {
        ArrayList registered = new ArrayList();
        Map services = (Map)this.serviceConfigs.get(type);
        if (services != null) {
            registered.addAll(services.values());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get service configs " + type + "=" + services));
        }
        return registered;
    }

    public Map getNotes() {
        return this.notes;
    }

    public void endScan() {
        this.serviceConfigs.clear();
        this.getNotes().clear();
        ServerDetector.clearSigarCache();
    }

    @Override
    public void shutdown() throws PluginException {
        this.endScan();
        super.shutdown();
    }
}

